/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.ancientspellcraft.mixin.ebwizardry;

import com.windanesz.ancientspellcraft.integration.baubles.ASBaublesIntegration;
import com.windanesz.ancientspellcraft.item.AbstractItemArtefactWithSlots;
import com.windanesz.ancientspellcraft.registry.ASItems;
import electroblob.wizardry.constants.Element;
import electroblob.wizardry.constants.Tier;
import electroblob.wizardry.data.WizardData;
import electroblob.wizardry.item.ItemArtefact;
import electroblob.wizardry.item.ItemScroll;
import electroblob.wizardry.item.ItemSpellBook;
import electroblob.wizardry.loot.RandomSpell;
import electroblob.wizardry.registry.Spells;
import electroblob.wizardry.registry.WizardryItems;
import electroblob.wizardry.spell.Spell;
import electroblob.wizardry.util.SpellProperties;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(value={RandomSpell.class})
public abstract class MixinRandomSpell {
    @Shadow(remap=false)
    @Final
    private List<Tier> tiers;
    @Shadow(remap=false)
    @Final
    private List<Spells> spells;
    @Shadow(remap=false)
    @Final
    private List<Element> elements;
    @Shadow(remap=false)
    @Final
    private boolean ignoreWeighting;
    @Shadow(remap=false)
    @Final
    private float undiscoveredBias;

    @Overwrite(remap=false)
    private Spell pickRandomSpell(ItemStack stack, Random random, SpellProperties.Context spellContext, EntityPlayer player) {
        List possibleSpells = Spell.getSpells(s -> !(!s.isEnabled(new SpellProperties.Context[]{spellContext}) || !s.applicableForItem(stack.func_77973_b()) || this.tiers != null && !this.tiers.contains(s.getTier()) || this.elements != null && !this.elements.contains(s.getElement())));
        if (this.spells != null && !this.spells.isEmpty()) {
            possibleSpells.retainAll(this.spells);
        }
        if (stack.func_77973_b() instanceof ItemScroll) {
            possibleSpells.removeIf(s -> !s.isEnabled(new SpellProperties.Context[]{SpellProperties.Context.SCROLL}));
        }
        if (stack.func_77973_b() instanceof ItemSpellBook) {
            possibleSpells.removeIf(s -> !s.isEnabled(new SpellProperties.Context[]{SpellProperties.Context.BOOK}));
        }
        ArrayList<Tier> possibleTiers = new ArrayList<Tier>();
        if (this.tiers == null || this.tiers.isEmpty()) {
            possibleTiers.addAll(Arrays.asList(Tier.values()));
        } else {
            possibleTiers.addAll(this.tiers);
        }
        possibleTiers.removeIf(t -> possibleSpells.stream().noneMatch(s -> s.getTier() == t));
        if (possibleTiers.isEmpty()) {
            return Spells.none;
        }
        Tier tier = this.ignoreWeighting ? (Tier)possibleTiers.get(random.nextInt(possibleTiers.size())) : Tier.getWeightedRandomTier((Random)random, (Tier[])possibleTiers.toArray(new Tier[0]));
        possibleSpells.removeIf(s -> s.getTier() != tier);
        if (possibleSpells.isEmpty()) {
            return Spells.none;
        }
        ArrayList<Element> possibleElements = new ArrayList<Element>();
        if (this.elements == null || this.elements.isEmpty()) {
            possibleElements.addAll(Arrays.asList(Element.values()));
        } else {
            possibleElements.addAll(this.elements);
        }
        possibleElements.removeIf(e -> possibleSpells.stream().noneMatch(s -> s.getElement() == e));
        if (possibleElements.isEmpty()) {
            return Spells.none;
        }
        Element element = (Element)possibleElements.get(random.nextInt(possibleElements.size()));
        if (player != null && ASBaublesIntegration.enabled()) {
            List<ItemStack> equippedArtefacts = ASBaublesIntegration.getEquippedArtefactStacks(player, ItemArtefact.Type.AMULET);
            equippedArtefacts.stream().filter(s -> s.func_77973_b() == ASItems.amulet_talisman_of_affinity).findFirst().ifPresent(s -> {
                if (s.func_77973_b() instanceof AbstractItemArtefactWithSlots) {
                    ItemStack crystalStack = AbstractItemArtefactWithSlots.getItemForSlot(s, 0);
                    Element element1 = Element.values()[crystalStack.func_77960_j()];
                    if ((double)random.nextFloat() < 0.99) {
                        possibleElements.clear();
                        possibleElements.add(element1);
                    }
                }
            });
        }
        possibleSpells.removeIf(s -> s.getElement() != element);
        if (possibleSpells.isEmpty()) {
            return Spells.none;
        }
        if (player != null) {
            float bias = this.undiscoveredBias;
            if (ItemArtefact.isArtefactActive((EntityPlayer)player, (Item)WizardryItems.charm_spell_discovery)) {
                bias = Math.min(bias + 0.4f, 0.9f);
            }
            if (bias > 0.0f) {
                WizardData data = WizardData.get((EntityPlayer)player);
                int discoveredCount = (int)possibleSpells.stream().filter(arg_0 -> ((WizardData)data).hasSpellBeenDiscovered(arg_0)).count();
                if (discoveredCount > 0 && discoveredCount < possibleSpells.size()) {
                    boolean keepDiscovered = random.nextFloat() > 0.5f + 0.5f * bias;
                    possibleSpells.removeIf(s -> keepDiscovered != data.hasSpellBeenDiscovered(s));
                }
            }
        }
        return (Spell)possibleSpells.get(random.nextInt(possibleSpells.size()));
    }
}

