/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.ancientspellcraft.packet;

import com.windanesz.ancientspellcraft.registry.ASBlocks;
import com.windanesz.ancientspellcraft.registry.ASItems;
import com.windanesz.ancientspellcraft.spell.AbsorbSpell;
import com.windanesz.ancientspellcraft.util.SpellcastUtils;
import electroblob.wizardry.event.SpellCastEvent;
import electroblob.wizardry.item.ItemArtefact;
import electroblob.wizardry.item.ItemSpellBook;
import electroblob.wizardry.spell.Spell;
import electroblob.wizardry.util.SpellModifiers;
import io.netty.buffer.ByteBuf;
import java.util.Optional;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketCastWarlockSpell
implements IMessageHandler<Message, IMessage> {
    public IMessage onMessage(Message message, MessageContext ctx) {
        if (ctx.side.isServer()) {
            EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
            player.func_71121_q().func_152344_a(() -> {
                switch (message.controlType) {
                    case START: {
                        this.castSpell(player, true);
                        break;
                    }
                    case END: {
                        this.castSpell(player, false);
                    }
                }
            });
        }
        return null;
    }

    private void castSpell(EntityPlayerMP player, boolean shouldCast) {
        if (shouldCast) {
            Optional<Spell> spellOptional = AbsorbSpell.getSpell((EntityPlayer)player);
            SpellModifiers spellModifier = new SpellModifiers();
            if (spellOptional.isPresent() && AbsorbSpell.canCast((EntityPlayer)player) && SpellcastUtils.tryCastSpellAsPlayer((EntityPlayer)player, spellOptional.get(), EnumHand.MAIN_HAND, SpellCastEvent.Source.WAND, spellModifier, 40)) {
                player.func_184811_cZ().func_185145_a(ItemSpellBook.func_150898_a((Block)ASBlocks.DIMENSION_FOCUS), spellOptional.get().getCooldown());
                if (!player.func_184812_l_()) {
                    int hunger = Math.max(1, (int)(((float)spellOptional.get().getCost() * spellModifier.get("cost") + 0.1f) / 5.0f));
                    if (ItemArtefact.isArtefactActive((EntityPlayer)player, (Item)ASItems.amulet_spellbinding)) {
                        hunger = Math.max(1, hunger / 2);
                    }
                    if (player.func_71024_bL().func_75116_a() == 0) {
                        player.func_70097_a(DamageSource.field_76366_f, (float)spellOptional.get().getCost() / 5.0f);
                    } else if (player.func_71024_bL().func_75116_a() >= hunger) {
                        player.func_71024_bL().func_75122_a(-hunger, 0.0f);
                    } else {
                        player.func_71024_bL().func_75122_a(-player.func_71024_bL().func_75116_a(), 0.0f);
                    }
                }
            }
        }
    }

    public static class Message
    implements IMessage {
        private ControlType controlType;

        public Message() {
        }

        public Message(ControlType type) {
            this.controlType = type;
        }

        public void fromBytes(ByteBuf buf) {
            this.controlType = ControlType.values()[buf.readInt()];
        }

        public void toBytes(ByteBuf buf) {
            buf.writeInt(this.controlType.ordinal());
        }
    }

    public static enum ControlType {
        START,
        END;

    }
}

