/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.ancientspellcraft.packet;

import com.windanesz.ancientspellcraft.AncientSpellcraft;
import com.windanesz.ancientspellcraft.client.gui.ContainerScribingDesk;
import com.windanesz.ancientspellcraft.client.gui.ContainerSphereCognizance;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketControlInput
implements IMessageHandler<Message, IMessage> {
    public IMessage onMessage(Message message, MessageContext ctx) {
        if (ctx.side.isServer()) {
            EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
            player.func_71121_q().func_152344_a(() -> {
                switch (message.controlType) {
                    case APPLY_BUTTON: {
                        if (!(player.field_71070_bA instanceof ContainerSphereCognizance)) {
                            AncientSpellcraft.logger.warn("Received a PacketControlInput, but the player that sent it was not currently using a crystal ball of cognizance. This should not happen!");
                            break;
                        }
                        ContainerSphereCognizance container = (ContainerSphereCognizance)player.field_71070_bA;
                        container.onApplyButtonPressed();
                        break;
                    }
                    case CRAFT_SPELL: {
                        if (!(player.field_71070_bA instanceof ContainerScribingDesk)) {
                            AncientSpellcraft.logger.warn("Received a PacketControlInput, but the player that sent it was not currently using a scribing desc. This should not happen!");
                            break;
                        }
                        ContainerScribingDesk container = (ContainerScribingDesk)player.field_71070_bA;
                        container.onApplyButtonPressed();
                    }
                }
            });
        }
        return null;
    }

    public static class Message
    implements IMessage {
        private ControlType controlType;

        public Message() {
        }

        public Message(ControlType type) {
            this.controlType = type;
        }

        public void fromBytes(ByteBuf buf) {
            this.controlType = ControlType.values()[buf.readInt()];
        }

        public void toBytes(ByteBuf buf) {
            buf.writeInt(this.controlType.ordinal());
        }
    }

    public static enum ControlType {
        APPLY_BUTTON,
        CRAFT_SPELL;

    }
}

