/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.ancientspellcraft.ritual;

import com.windanesz.ancientspellcraft.ritual.IRitualIngredient;
import com.windanesz.ancientspellcraft.ritual.Ritual;
import com.windanesz.ancientspellcraft.spell.WarlockElementalSpellEffects;
import com.windanesz.ancientspellcraft.tileentity.TileRune;
import com.windanesz.ancientspellcraft.util.ASUtils;
import electroblob.wizardry.constants.Element;
import electroblob.wizardry.data.IStoredVariable;
import electroblob.wizardry.data.Persistence;
import electroblob.wizardry.data.WizardData;
import electroblob.wizardry.item.ItemCrystal;
import electroblob.wizardry.item.SpellActions;
import electroblob.wizardry.registry.WizardryItems;
import electroblob.wizardry.util.ParticleBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class ElementalAttunement
extends Ritual
implements IRitualIngredient {
    public static final IStoredVariable<Integer> ELEMENTAL_ATTUNEMENT = IStoredVariable.StoredVariable.ofInt((String)"ElementalAttunement", (Persistence)Persistence.ALWAYS);

    public ElementalAttunement() {
        super("ancientspellcraft", "elemental_attunement", SpellActions.SUMMON, false);
        WizardData.registerStoredVariables((IStoredVariable[])new IStoredVariable[]{ELEMENTAL_ATTUNEMENT});
    }

    @Override
    public void initialEffect(World world, EntityPlayer caster, TileRune centerPiece) {
        this.ruinNonCenterPieceRunes(centerPiece, world);
        List crystals = this.getActualIngredients(world, centerPiece, 1);
        if (!crystals.isEmpty() && ((EntityItem)crystals.get(0)).func_92059_d().func_77973_b() instanceof ItemCrystal) {
            ((EntityItem)crystals.get(0)).func_174867_a(this.getMaxLifeTime() + 10);
        }
    }

    public static Optional<Element> getElement(EntityPlayer player) {
        WizardData data = WizardData.get((EntityPlayer)player);
        if (data.getVariable(ELEMENTAL_ATTUNEMENT) == null || (Integer)data.getVariable(ELEMENTAL_ATTUNEMENT) == -1) {
            return Optional.empty();
        }
        return Optional.of(Element.values()[(Integer)data.getVariable(ELEMENTAL_ATTUNEMENT)]);
    }

    @Override
    public void onRitualFinish(World world, EntityPlayer caster, TileRune centerPiece) {
        WizardData data = WizardData.get((EntityPlayer)caster);
        List crystals = this.getActualIngredients(world, centerPiece, 1);
        if (!crystals.isEmpty() && ((EntityItem)crystals.get(0)).func_92059_d().func_77973_b() instanceof ItemCrystal) {
            Element element = Element.values()[((EntityItem)crystals.get(0)).func_92059_d().func_77960_j()];
            if (element == Element.MAGIC) {
                data.setVariable(ELEMENTAL_ATTUNEMENT, null);
                ASUtils.sendMessage((Entity)caster, "ritual.ancientspellcraft:elemental_attunement.not_attuned", false, element.getDisplayName());
            } else {
                data.setVariable(ELEMENTAL_ATTUNEMENT, (Object)element.ordinal());
                ASUtils.sendMessage((Entity)caster, "ritual.ancientspellcraft:elemental_attunement.attuned", false, element.getDisplayName());
            }
            ((EntityItem)crystals.get(0)).func_92059_d().func_190918_g(1);
        }
        super.onRitualFinish(world, caster, centerPiece);
    }

    @Override
    public void effect(World world, EntityPlayer caster, TileRune centerPiece) {
        List crystals;
        super.effect(world, caster, centerPiece);
        if (world.field_72995_K && !(crystals = this.getActualIngredients(world, centerPiece, 1)).isEmpty() && ((EntityItem)crystals.get(0)).func_92059_d().func_77973_b() instanceof ItemCrystal) {
            Element element = Element.values()[((EntityItem)crystals.get(0)).func_92059_d().func_77960_j()];
            Vec3d target = new Vec3d((double)centerPiece.getXCenter(), 256.0, (double)centerPiece.getZCenter());
            int clr = WarlockElementalSpellEffects.PARTICLE_COLOURS.get(element)[0];
            if (world.func_82737_E() % 7L == 0L) {
                ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.BEAM).clr(clr).pos((double)centerPiece.getXCenter(), (double)(centerPiece.getYCenter() - 0.5f), (double)centerPiece.getZCenter()).scale(2.0f).time(80).target(target).spawn(world);
            }
            ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.BEAM).clr(clr).pos((double)centerPiece.getXCenter(), (double)(centerPiece.getYCenter() - 0.5f), (double)centerPiece.getZCenter()).scale(1.0f).time(70).target(target).spawn(world);
            ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.FLASH).face(EnumFacing.UP).clr(clr).pos((double)centerPiece.getXCenter(), (double)(centerPiece.getYCenter() - 0.3f), (double)centerPiece.getZCenter()).time(70).scale(2.0f).spawn(world);
        }
    }

    @Override
    public List<List<ItemStack>> getRequiredIngredients() {
        ArrayList<List<ItemStack>> ingredients = new ArrayList<List<ItemStack>>();
        ArrayList crystals = new ArrayList();
        Arrays.stream(Element.values()).iterator().forEachRemaining(e -> crystals.add(new ItemStack(WizardryItems.magic_crystal, 1, e.ordinal())));
        ingredients.add(crystals);
        return ingredients;
    }
}

