/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.ancientspellcraft.ritual;

import com.windanesz.ancientspellcraft.ritual.Ritual;
import com.windanesz.ancientspellcraft.spell.WarlockElementalSpellEffects;
import com.windanesz.ancientspellcraft.tileentity.TileRune;
import electroblob.wizardry.constants.Element;
import electroblob.wizardry.data.IStoredVariable;
import electroblob.wizardry.data.Persistence;
import electroblob.wizardry.data.WizardData;
import electroblob.wizardry.item.SpellActions;
import electroblob.wizardry.util.ParticleBuilder;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;

public class WarlockAttunement
extends Ritual {
    public static final IStoredVariable<Boolean> WARLOCK_ATTUNED = IStoredVariable.StoredVariable.ofBoolean((String)"WarlockAttuned", (Persistence)Persistence.ALWAYS);

    public WarlockAttunement() {
        super("ancientspellcraft", "warlock_attunement", SpellActions.SUMMON, false);
        WizardData.registerStoredVariables((IStoredVariable[])new IStoredVariable[]{WARLOCK_ATTUNED});
    }

    @Override
    public void initialEffect(World world, EntityPlayer caster, TileRune centerPiece) {
        this.ruinNonCenterPieceRunes(centerPiece, world);
    }

    public static boolean isWarlockAttuned(EntityPlayer player) {
        WizardData data = WizardData.get((EntityPlayer)player);
        return data.getVariable(WARLOCK_ATTUNED) != null && (Boolean)data.getVariable(WARLOCK_ATTUNED) != false;
    }

    @Override
    public void onRitualFinish(World world, EntityPlayer caster, TileRune centerPiece) {
        WizardData data = WizardData.get((EntityPlayer)caster);
        if (data.getVariable(WARLOCK_ATTUNED) == null) {
            data.setVariable(WARLOCK_ATTUNED, (Object)true);
        } else {
            data.setVariable(WARLOCK_ATTUNED, (Object)((Boolean)data.getVariable(WARLOCK_ATTUNED) == false ? 1 : 0));
        }
        data.sync();
        if (caster != null && !world.field_72995_K) {
            if (WarlockAttunement.isWarlockAttuned(caster)) {
                caster.func_145747_a((ITextComponent)new TextComponentTranslation("ritual.ancientspellcraft:warlock_attunement.attuned", new Object[]{centerPiece.getX(), centerPiece.getY(), centerPiece.getZ()}));
            } else {
                caster.func_145747_a((ITextComponent)new TextComponentTranslation("ritual.ancientspellcraft:warlock_attunement.not_attuned", new Object[]{centerPiece.getX(), centerPiece.getY(), centerPiece.getZ()}));
            }
        }
        super.onRitualFinish(world, caster, centerPiece);
    }

    @Override
    public void effect(World world, EntityPlayer caster, TileRune centerPiece) {
        super.effect(world, caster, centerPiece);
        if (world.field_72995_K) {
            int[] color = WarlockElementalSpellEffects.PARTICLE_COLOURS.get(Element.MAGIC);
            Vec3d target = new Vec3d((double)centerPiece.getXCenter(), 256.0, (double)centerPiece.getZCenter());
            if (world.func_82737_E() % 7L == 0L) {
                ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.BEAM).clr(color[0]).pos((double)centerPiece.getXCenter(), (double)(centerPiece.getYCenter() - 0.5f), (double)centerPiece.getZCenter()).scale(2.0f).time(10).target(target).spawn(world);
            }
            ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.BEAM).clr(color[0]).pos((double)centerPiece.getXCenter(), (double)(centerPiece.getYCenter() - 0.5f), (double)centerPiece.getZCenter()).scale(1.0f).time(5).target(target).spawn(world);
            ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.FLASH).clr(color[0]).pos((double)centerPiece.getXCenter(), (double)centerPiece.getYCenter(), (double)centerPiece.getZCenter()).scale(2.0f).spawn(world);
            ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.FLASH).clr(color[0]).pos((double)centerPiece.getXCenter(), (double)(centerPiece.getYCenter() + 0.5f), (double)centerPiece.getZCenter()).scale(0.9f).spawn(world);
        }
    }
}

