/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.ancientspellcraft.spell;

import com.windanesz.ancientspellcraft.Settings;
import com.windanesz.ancientspellcraft.registry.ASItems;
import com.windanesz.ancientspellcraft.spell.IClassSpell;
import com.windanesz.ancientspellcraft.spell.WarlockElementalSpellEffects;
import com.windanesz.ancientspellcraft.util.ASUtils;
import electroblob.wizardry.Wizardry;
import electroblob.wizardry.constants.Element;
import electroblob.wizardry.data.IStoredVariable;
import electroblob.wizardry.data.Persistence;
import electroblob.wizardry.data.WizardData;
import electroblob.wizardry.item.ItemArtefact;
import electroblob.wizardry.item.ItemWizardArmour;
import electroblob.wizardry.item.SpellActions;
import electroblob.wizardry.registry.WizardryItems;
import electroblob.wizardry.spell.Spell;
import electroblob.wizardry.util.ParticleBuilder;
import electroblob.wizardry.util.SpellModifiers;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Optional;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntityDispenser;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public class AbsorbArtefact
extends Spell
implements IClassSpell {
    public static final IStoredVariable<String> ARTEFACT = IStoredVariable.StoredVariable.ofString((String)"AbsorbArtefact", (Persistence)Persistence.ALWAYS);
    public static final IStoredVariable<Integer> POWER_GEM_COUNT = IStoredVariable.StoredVariable.ofInt((String)"PowerGemCount", (Persistence)Persistence.ALWAYS);
    public static final String TIER_LIMIT = "tier_limit";

    public AbsorbArtefact() {
        super("ancientspellcraft", "absorb_artefact", SpellActions.SUMMON, true);
        WizardData.registerStoredVariables((IStoredVariable[])new IStoredVariable[]{ARTEFACT, POWER_GEM_COUNT});
        this.addProperties(new String[]{TIER_LIMIT});
    }

    public boolean cast(World world, EntityPlayer caster, EnumHand hand, int ticksInUse, SpellModifiers modifiers) {
        Element element = this.getElementOrMagicElement((EntityLivingBase)caster);
        ItemStack artefact = caster.func_184592_cb();
        if (ticksInUse % 40 == 0) {
            this.playSound(world, (EntityLivingBase)caster, ticksInUse, -1, modifiers, new String[0]);
        }
        if (!(artefact.func_77973_b() instanceof ItemArtefact)) {
            ASUtils.sendMessage((Entity)caster, "You must hold an artefact in your offhand", true, new Object[0]);
            return false;
        }
        String rarity = artefact.func_77973_b().getForgeRarity(artefact).getName();
        if (Rarities.isKnownRarity(rarity) && Rarities.valueOf(rarity.toUpperCase()).ordinal() > this.getProperty(TIER_LIMIT).intValue()) {
            ASUtils.sendMessage((Entity)caster, "This artefact is too powerful to be absorbed", true, new Object[0]);
            return false;
        }
        ArrayList<String> blacklist = new ArrayList<String>(Arrays.asList(Settings.generalSettings.absorb_artefact_blacklist));
        if (blacklist.contains(artefact.func_77973_b().getRegistryName().toString())) {
            ASUtils.sendMessage((Entity)caster, "This artefact cannot be absorbed", true, new Object[0]);
            return false;
        }
        Random rand = caster.field_70170_p.field_73012_v;
        double posX = caster.field_70165_t;
        double posY = caster.field_70163_u;
        double posZ = caster.field_70161_v;
        if (world.field_72995_K) {
            if (world.func_82737_E() % 3L == 0L) {
                ParticleBuilder.create((ResourceLocation)WarlockElementalSpellEffects.getElementalParticle(element), (Random)rand, (double)(posX + rand.nextDouble() * 0.5 * (double)(rand.nextBoolean() ? 1 : -1)), (double)posY, (double)(posZ + rand.nextDouble() * 0.5 * (double)(rand.nextBoolean() ? 1 : -1)), (double)0.03, (boolean)true).vel(0.0, 0.3, 0.0).clr(WarlockElementalSpellEffects.PARTICLE_COLOURS.get(element)[0]).time(20 + rand.nextInt(50)).spawn(world);
                ParticleBuilder.create((ResourceLocation)WarlockElementalSpellEffects.getElementalParticle(element), (Random)rand, (double)(posX + rand.nextDouble() * 0.5 * (double)(rand.nextBoolean() ? 1 : -1)), (double)posY, (double)(posZ + rand.nextDouble() * 0.5 * (double)(rand.nextBoolean() ? 1 : -1)), (double)0.03, (boolean)true).vel(0.0, 0.3, 0.0).clr(WarlockElementalSpellEffects.PARTICLE_COLOURS.get(element)[0]).time(20 + rand.nextInt(50)).spawn(world);
                ParticleBuilder.create((ResourceLocation)WarlockElementalSpellEffects.getElementalParticle(element), (Random)rand, (double)(posX + rand.nextDouble() * 0.2 * (double)(rand.nextBoolean() ? 1 : -1)), (double)posY, (double)(posZ + rand.nextDouble() * 0.2 * (double)(rand.nextBoolean() ? 1 : -1)), (double)0.03, (boolean)true).spin(0.7, 0.05).vel(0.0, 0.3, 0.0).clr(WarlockElementalSpellEffects.PARTICLE_COLOURS.get(element)[0]).time(20 + rand.nextInt(50)).spawn(world);
            }
            ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.FLASH).pos(caster.field_70165_t, caster.field_70163_u + 0.101, caster.field_70161_v).face(EnumFacing.UP).clr(WarlockElementalSpellEffects.PARTICLE_COLOURS.get(element)[1]).collide(false).scale(2.3f).time(10).spawn(world);
        }
        if (ticksInUse == 60) {
            WizardData data = WizardData.get((EntityPlayer)caster);
            if (caster.func_184592_cb().func_77973_b() == ASItems.body_power_gem) {
                if ((double)AbsorbArtefact.getPowerGemCount(data) <= Settings.generalSettings.gem_of_power_max_absorb_amount) {
                    AbsorbArtefact.addToPowerGemCount(caster);
                }
            } else {
                data.setVariable(ARTEFACT, (Object)caster.func_184592_cb().func_77973_b().getRegistryName().toString());
            }
            Wizardry.proxy.shakeScreen(caster, 10.0f);
            caster.func_184597_cx();
            ASUtils.sendMessage((Entity)caster, "Absorbed " + caster.func_184592_cb().func_82833_r(), true, new Object[0]);
            this.spawnParticleEffect(world, 5.0, (EntityLivingBase)caster, modifiers);
            caster.func_184592_cb().func_190918_g(1);
        }
        return true;
    }

    public static int getPowerGemCount(EntityPlayer player) {
        WizardData data = WizardData.get((EntityPlayer)player);
        if (data.getVariable(POWER_GEM_COUNT) != null) {
            return (Integer)data.getVariable(POWER_GEM_COUNT);
        }
        return 0;
    }

    public static int getPowerGemCount(WizardData data) {
        if (data.getVariable(POWER_GEM_COUNT) != null) {
            return (Integer)data.getVariable(POWER_GEM_COUNT);
        }
        return 0;
    }

    public static void addToPowerGemCount(EntityPlayer player) {
        WizardData data = WizardData.get((EntityPlayer)player);
        int count = 0;
        if (data.getVariable(POWER_GEM_COUNT) != null) {
            count = (Integer)data.getVariable(POWER_GEM_COUNT);
        }
        data.setVariable(POWER_GEM_COUNT, (Object)(++count));
        data.sync();
    }

    public boolean canBeCastBy(TileEntityDispenser dispenser) {
        return false;
    }

    public static Optional<Item> getArtefact(WizardData data) {
        return data.getVariable(ARTEFACT) == null ? Optional.empty() : Optional.of(ForgeRegistries.ITEMS.getValue(new ResourceLocation(((String)data.getVariable(ARTEFACT)).toString())));
    }

    public static boolean isArtefactActive(EntityPlayer player, Item artefact) {
        WizardData data = WizardData.get((EntityPlayer)player);
        if (data != null && data.getVariable(ARTEFACT) != null) {
            return ForgeRegistries.ITEMS.getValue(new ResourceLocation((String)data.getVariable(ARTEFACT))) != null && ForgeRegistries.ITEMS.getValue(new ResourceLocation((String)data.getVariable(ARTEFACT))) == artefact;
        }
        return false;
    }

    protected void spawnParticleEffect(World world, double radius, EntityLivingBase caster, SpellModifiers modifiers) {
        if (!world.field_72995_K) {
            return;
        }
        Vec3d origin = caster.func_174791_d();
        int i = 0;
        while ((float)i < 40.0f * modifiers.get(WizardryItems.blast_upgrade)) {
            double particleX = origin.field_72450_a - 1.0 + 2.0 * world.field_73012_v.nextDouble();
            double particleZ = origin.field_72449_c - 1.0 + 2.0 * world.field_73012_v.nextDouble();
            ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.DARK_MAGIC).pos(particleX, origin.field_72448_b, particleZ).vel(particleX - origin.field_72450_a, 0.0, particleZ - origin.field_72449_c).clr(0.1f, 0.0f, 0.0f).spawn(world);
            particleX = origin.field_72450_a - 1.0 + 2.0 * world.field_73012_v.nextDouble();
            particleZ = origin.field_72449_c - 1.0 + 2.0 * world.field_73012_v.nextDouble();
            ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.SPARKLE).pos(particleX, origin.field_72448_b, particleZ).vel(particleX - origin.field_72450_a, 0.0, particleZ - origin.field_72449_c).time(30).clr(0.1f, 0.0f, 0.05f).spawn(world);
            particleX = origin.field_72450_a - 1.0 + 2.0 * world.field_73012_v.nextDouble();
            particleZ = origin.field_72449_c - 1.0 + 2.0 * world.field_73012_v.nextDouble();
            ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.SCORCH).pos(caster.field_70165_t, caster.field_70163_u + 0.101, caster.field_70161_v).face(EnumFacing.UP).clr(0.1f, 0.0f, 0.05f).collide(false).scale(4.3f).time(100).spawn(world);
            IBlockState block = world.func_180495_p(new BlockPos(origin.field_72450_a, origin.field_72448_b - 0.5, origin.field_72449_c));
            if (block != null) {
                world.func_175688_a(EnumParticleTypes.BLOCK_DUST, particleX, origin.field_72448_b, particleZ, particleX - origin.field_72450_a, 0.0, particleZ - origin.field_72449_c, new int[]{Block.func_176210_f((IBlockState)block)});
            }
            ++i;
        }
        ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.SPHERE).pos(origin.func_72441_c(0.0, 0.1, 0.0)).scale((float)radius * 0.8f).clr(0.8f, 0.0f, 0.05f).spawn(world);
    }

    @Override
    public ItemWizardArmour.ArmourClass getArmourClass() {
        return ItemWizardArmour.ArmourClass.WARLOCK;
    }

    public boolean applicableForItem(Item item) {
        return item == ASItems.forbidden_tome;
    }

    public boolean canBeCastBy(EntityLiving npc, boolean override) {
        return this.canBeCastByClassNPC((EntityLivingBase)npc);
    }

    public static enum Rarities {
        UNCOMMON,
        RARE,
        EPIC;


        static boolean isKnownRarity(String rarity) {
            for (Rarities r : Rarities.values()) {
                if (!r.name().equalsIgnoreCase(rarity)) continue;
                return true;
            }
            return false;
        }
    }
}

