/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.ancientspellcraft.spell;

import com.windanesz.ancientspellcraft.registry.ASItems;
import com.windanesz.ancientspellcraft.spell.IClassSpell;
import com.windanesz.ancientspellcraft.spell.WarlockElementalSpellEffects;
import com.windanesz.ancientspellcraft.util.ASUtils;
import com.windanesz.ancientspellcraft.util.WizardArmourUtils;
import electroblob.wizardry.client.DrawingUtils;
import electroblob.wizardry.constants.Element;
import electroblob.wizardry.data.IStoredVariable;
import electroblob.wizardry.data.Persistence;
import electroblob.wizardry.data.WizardData;
import electroblob.wizardry.item.ItemArtefact;
import electroblob.wizardry.item.ItemCrystal;
import electroblob.wizardry.item.ItemWizardArmour;
import electroblob.wizardry.item.SpellActions;
import electroblob.wizardry.registry.WizardryBlocks;
import electroblob.wizardry.spell.Spell;
import electroblob.wizardry.util.ParticleBuilder;
import electroblob.wizardry.util.SpellModifiers;
import java.util.Optional;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntityDispenser;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;

public class AbsorbCrystal
extends Spell
implements IClassSpell {
    public static final IStoredVariable<Integer> ELEMENT = IStoredVariable.StoredVariable.ofInt((String)"AbsorbCrystalElement", (Persistence)Persistence.ALWAYS);

    public AbsorbCrystal() {
        super("ancientspellcraft", "absorb_crystal", SpellActions.SUMMON, true);
        WizardData.registerStoredVariables((IStoredVariable[])new IStoredVariable[]{ELEMENT});
    }

    public boolean cast(World world, EntityPlayer caster, EnumHand hand, int ticksInUse, SpellModifiers modifiers) {
        boolean isBlock;
        Optional<Element> elementOptional = WizardArmourUtils.getFullSetElementForClassOptional((EntityLivingBase)caster, ItemWizardArmour.ArmourClass.WARLOCK);
        ItemStack crystal = caster.func_184592_cb();
        boolean bl = isBlock = crystal.func_77973_b() == Item.func_150898_a((Block)WizardryBlocks.crystal_block);
        if (!(crystal.func_77973_b() instanceof ItemCrystal) || isBlock && !ItemArtefact.isArtefactActive((EntityPlayer)caster, (Item)ASItems.ring_absorb_crystal) || crystal.func_77952_i() == 0) {
            ASUtils.sendMessage((Entity)caster, "You must hold an elemental crystal in your offhand", true, new Object[0]);
            return false;
        }
        if (ticksInUse % 40 == 0) {
            this.playSound(world, (EntityLivingBase)caster, ticksInUse, -1, modifiers, new String[0]);
        }
        if (elementOptional.isPresent()) {
            Element element = elementOptional.get();
            Random rand = caster.field_70170_p.field_73012_v;
            double posX = caster.field_70165_t;
            double posY = caster.field_70163_u;
            double posZ = caster.field_70161_v;
            if (world.field_72995_K) {
                if (world.func_82737_E() % 3L == 0L) {
                    ParticleBuilder.create((ResourceLocation)WarlockElementalSpellEffects.getElementalParticle(element), (Random)rand, (double)(posX + rand.nextDouble() * 0.5 * (double)(rand.nextBoolean() ? 1 : -1)), (double)posY, (double)(posZ + rand.nextDouble() * 0.5 * (double)(rand.nextBoolean() ? 1 : -1)), (double)0.03, (boolean)true).vel(0.0, 0.3, 0.0).clr(WarlockElementalSpellEffects.PARTICLE_COLOURS.get(element)[0]).time(20 + rand.nextInt(50)).spawn(world);
                    ParticleBuilder.create((ResourceLocation)WarlockElementalSpellEffects.getElementalParticle(element), (Random)rand, (double)(posX + rand.nextDouble() * 0.5 * (double)(rand.nextBoolean() ? 1 : -1)), (double)posY, (double)(posZ + rand.nextDouble() * 0.5 * (double)(rand.nextBoolean() ? 1 : -1)), (double)0.03, (boolean)true).vel(0.0, 0.3, 0.0).clr(WarlockElementalSpellEffects.PARTICLE_COLOURS.get(element)[1]).time(20 + rand.nextInt(50)).spawn(world);
                    ParticleBuilder.create((ResourceLocation)WarlockElementalSpellEffects.getElementalParticle(element), (Random)rand, (double)(posX + rand.nextDouble() * 0.2 * (double)(rand.nextBoolean() ? 1 : -1)), (double)posY, (double)(posZ + rand.nextDouble() * 0.2 * (double)(rand.nextBoolean() ? 1 : -1)), (double)0.03, (boolean)true).spin(0.7, 0.05).vel(0.0, 0.3, 0.0).clr(WarlockElementalSpellEffects.PARTICLE_COLOURS.get(element)[2]).time(20 + rand.nextInt(50)).spawn(world);
                }
                ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.FLASH).pos(caster.field_70165_t, caster.field_70163_u + 0.101, caster.field_70161_v).face(EnumFacing.UP).clr(DrawingUtils.mix((int)WarlockElementalSpellEffects.PARTICLE_COLOURS.get(element)[1], (int)WarlockElementalSpellEffects.PARTICLE_COLOURS.get(element)[2], (float)0.5f)).collide(false).scale(2.3f).time(10).spawn(world);
            } else if (ticksInUse == 60) {
                WizardData data = WizardData.get((EntityPlayer)caster);
                data.setVariable(ELEMENT, (Object)(isBlock ? caster.func_184592_cb().func_77952_i() + 7 : caster.func_184592_cb().func_77952_i()));
                caster.func_184597_cx();
                ASUtils.sendMessage((Entity)caster, "Absorbed " + caster.func_184592_cb().func_82833_r(), true, new Object[0]);
                caster.func_184592_cb().func_190918_g(1);
                return true;
            }
        }
        return false;
    }

    public boolean canBeCastBy(EntityLiving npc, boolean override) {
        return false;
    }

    public boolean canBeCastBy(TileEntityDispenser dispenser) {
        return false;
    }

    @Override
    public ItemWizardArmour.ArmourClass getArmourClass() {
        return ItemWizardArmour.ArmourClass.WARLOCK;
    }

    public static Optional<Element> getElement(WizardData data) {
        if (data.getVariable(ELEMENT) == null) {
            return Optional.empty();
        }
        return Optional.of(Element.values()[(Integer)data.getVariable(ELEMENT) > 7 ? (Integer)data.getVariable(ELEMENT) - 7 : (Integer)data.getVariable(ELEMENT)]);
    }

    public static boolean isBlock(WizardData data) {
        if (data.getVariable(ELEMENT) == null) {
            return false;
        }
        return (Integer)data.getVariable(ELEMENT) > 7;
    }

    public boolean applicableForItem(Item item) {
        return item == ASItems.forbidden_tome;
    }
}

