/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.ancientspellcraft.spell;

import com.google.common.collect.Sets;
import com.windanesz.ancientspellcraft.Settings;
import com.windanesz.ancientspellcraft.registry.ASItems;
import com.windanesz.ancientspellcraft.spell.IClassSpell;
import electroblob.wizardry.Wizardry;
import electroblob.wizardry.item.ItemWizardArmour;
import electroblob.wizardry.item.SpellActions;
import electroblob.wizardry.spell.SpellRay;
import electroblob.wizardry.util.BlockUtils;
import electroblob.wizardry.util.EntityUtils;
import electroblob.wizardry.util.ParticleBuilder;
import electroblob.wizardry.util.SpellModifiers;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.projectile.EntityTippedArrow;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.potion.PotionEffect;
import net.minecraft.potion.PotionUtils;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityDispenser;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class AbsorbObject
extends SpellRay
implements IClassSpell {
    public AbsorbObject() {
        super("ancientspellcraft", "absorb_object", SpellActions.POINT, true);
        this.ignoreUncollidables = false;
        this.soundValues(1.0f, 1.0f, 0.4f);
    }

    public boolean cast(World world, EntityPlayer caster, EnumHand hand, int ticksInUse, SpellModifiers modifiers) {
        Vec3d look = caster.func_70040_Z();
        Vec3d origin = new Vec3d(caster.field_70165_t, caster.field_70163_u + (double)caster.func_70047_e() - 0.25, caster.field_70161_v);
        if (!this.isContinuous && world.field_72995_K && !Wizardry.proxy.isFirstPerson((Entity)caster)) {
            origin = origin.func_178787_e(look.func_186678_a(1.2));
        }
        if (!this.shootSpell(world, origin, look, (EntityLivingBase)caster, ticksInUse, modifiers)) {
            return false;
        }
        if (this.casterSwingsArm(world, (EntityLivingBase)caster, hand, ticksInUse, modifiers)) {
            caster.func_184609_a(hand);
        }
        if (ticksInUse == 0 || ticksInUse % 80 == 0) {
            this.playSound(world, (EntityLivingBase)caster, ticksInUse, -1, modifiers, new String[0]);
        }
        return true;
    }

    protected boolean onEntityHit(World world, Entity target, Vec3d hit, EntityLivingBase caster, Vec3d origin, int ticksInUse, SpellModifiers modifiers) {
        return false;
    }

    protected boolean onBlockHit(World world, BlockPos pos, EnumFacing side, Vec3d hit, EntityLivingBase caster, Vec3d origin, int ticksInUse, SpellModifiers modifiers) {
        NBTTagCompound nbt;
        ItemStack stack;
        boolean hasStack = false;
        if (caster.func_184600_cs() == EnumHand.MAIN_HAND && (stack = caster.func_184614_ca()).func_77942_o() && (nbt = stack.func_77978_p()).func_74764_b("SpellAbsorbObject")) {
            hasStack = true;
        }
        if (caster.func_70093_af() && hasStack) {
            return false;
        }
        if (!world.field_72995_K) {
            if (ticksInUse == 60) {
                NBTTagCompound spellAbsorbObject;
                if (!caster.func_70093_af() && BlockUtils.canPlaceBlock((Entity)caster, (World)world, (BlockPos)(pos = pos.func_177972_a(side))) && caster.func_184600_cs() == EnumHand.MAIN_HAND && (stack = caster.func_184614_ca()).func_77942_o() && (nbt = stack.func_77978_p()).func_74764_b("SpellAbsorbObject") && (spellAbsorbObject = nbt.func_74775_l("SpellAbsorbObject")).func_74764_b("state")) {
                    NBTUtil.func_190008_d((NBTTagCompound)spellAbsorbObject.func_74775_l("state"));
                    world.func_175656_a(pos, NBTUtil.func_190008_d((NBTTagCompound)spellAbsorbObject.func_74775_l("state")));
                    nbt.func_82580_o("SpellAbsorbObject");
                    stack.func_77982_d(nbt);
                    if (spellAbsorbObject.func_74764_b("tile")) {
                        NBTTagCompound tileNBT = spellAbsorbObject.func_74775_l("tile");
                        world.func_175690_a(pos, TileEntity.func_190200_a((World)world, (NBTTagCompound)tileNBT));
                    }
                    return true;
                }
                if (BlockUtils.isBlockUnbreakable((World)world, (BlockPos)pos)) {
                    return false;
                }
                ArrayList<String> blacklist = new ArrayList<String>(Arrays.asList(Settings.generalSettings.absorb_object_block_blacklist));
                if (blacklist.contains(world.func_180495_p(pos).func_177230_c().getRegistryName().toString())) {
                    return false;
                }
                if (!EntityUtils.canDamageBlocks((Entity)caster, (World)world)) {
                    return false;
                }
                boolean flag = false;
                IBlockState state1 = world.func_180495_p(pos);
                if (caster instanceof EntityPlayerMP && (flag = BlockUtils.canBreakBlock((Entity)caster, (World)world, (BlockPos)pos))) {
                    AbsorbObject.storeBlockAndTileEntity((EntityPlayer)caster, world, pos);
                    ((EntityPlayerMP)caster).func_184811_cZ().func_185145_a(caster.func_184614_ca().func_77973_b(), 5);
                }
                return flag;
            }
        } else {
            if (!caster.func_70093_af()) {
                pos = pos.func_177972_a(side);
            } else {
                for (int i = 0; i < 2; ++i) {
                    ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.FLASH).shaded(true).time(40).scale(1.9f).pos((double)((float)pos.func_177958_n() + 0.5f), (double)pos.func_177956_o() + 0.3 + (double)world.field_73012_v.nextFloat(), (double)((float)pos.func_177952_p() + 0.5f)).clr(Math.min(254, 40 + ticksInUse * 4), 10, 10).spin(0.5, (double)0.1f).spawn(world);
                }
            }
            if (hasStack && ticksInUse % 2 == 0) {
                for (int i = 0; i < 2; ++i) {
                    ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.FLASH).shaded(true).time(40).scale(1.9f).pos((double)((float)pos.func_177958_n() + 0.5f), (double)pos.func_177956_o() + 0.3 + (double)world.field_73012_v.nextFloat(), (double)((float)pos.func_177952_p() + 0.5f)).clr(Math.min(254, 40 + ticksInUse * 4), 10, 10).spin(0.5, (double)0.1f).spawn(world);
                }
            }
            if (ticksInUse == 39) {
                // empty if block
            }
        }
        return true;
    }

    public static void storeBlockAndTileEntity(EntityPlayer player, World world, BlockPos pos) {
        ItemStack heldItem = player.func_184614_ca();
        if (!heldItem.func_190926_b()) {
            NBTTagCompound nbt = heldItem.func_77942_o() ? heldItem.func_77978_p() : new NBTTagCompound();
            NBTTagCompound state = new NBTTagCompound();
            NBTTagCompound blockData = new NBTTagCompound();
            IBlockState state2 = world.func_180495_p(pos);
            NBTUtil.func_190009_a((NBTTagCompound)state, (IBlockState)world.func_180495_p(pos));
            if (world.func_175625_s(pos) != null) {
                NBTTagCompound tile = world.func_175625_s(pos).serializeNBT();
                blockData.func_74782_a("tile", (NBTBase)tile);
                world.func_175713_t(pos);
            }
            blockData.func_74782_a("state", (NBTBase)state);
            nbt.func_74782_a("SpellAbsorbObject", (NBTBase)blockData);
            player.func_184614_ca().func_77982_d(nbt);
            world.func_175698_g(pos);
            EntityTippedArrow a = new EntityTippedArrow(world);
            NBTTagCompound nbtTagCompound = a.serializeNBT();
            HashSet customPotionEffects = Sets.newHashSet();
            for (PotionEffect potioneffect : PotionUtils.func_185192_b((NBTTagCompound)nbtTagCompound)) {
                customPotionEffects.add(potioneffect);
            }
            if (!customPotionEffects.isEmpty()) {
                ItemStack stack = new ItemStack(Items.field_185167_i);
                PotionUtils.func_185184_a((ItemStack)stack, (Collection)customPotionEffects);
            }
        }
    }

    protected boolean onMiss(World world, EntityLivingBase caster, Vec3d origin, Vec3d direction, int ticksInUse, SpellModifiers modifiers) {
        return false;
    }

    protected void spawnParticleRay(World world, Vec3d origin, Vec3d direction, @Nullable EntityLivingBase caster, double distance) {
        if (caster == null) {
            return;
        }
        Vec3d velocity = direction.func_186678_a(this.particleVelocity);
        for (double d = this.particleSpacing; d <= distance; d += this.particleSpacing) {
            double x = origin.field_72450_a + d * direction.field_72450_a + this.particleJitter * (world.field_73012_v.nextDouble() * 2.0 - 1.0);
            double y = origin.field_72448_b + d * direction.field_72448_b + this.particleJitter * (world.field_73012_v.nextDouble() * 2.0 - 1.0);
            double z = origin.field_72449_c + d * direction.field_72449_c + this.particleJitter * (world.field_73012_v.nextDouble() * 2.0 - 1.0);
            this.spawnParticle(world, x, y, z, velocity.field_72450_a, velocity.field_72448_b, velocity.field_72449_c);
        }
        Vec3d endpoint = origin.func_178787_e(direction.func_186678_a(distance));
        if (caster.func_70093_af()) {
            ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.BEAM).clr(10684160).time(-1).shaded(true).pos(origin).target(endpoint).spawn(world);
        }
    }

    @Override
    public ItemWizardArmour.ArmourClass getArmourClass() {
        return ItemWizardArmour.ArmourClass.WARLOCK;
    }

    public boolean applicableForItem(Item item) {
        return item == ASItems.forbidden_tome;
    }

    public boolean canBeCastBy(EntityLiving npc, boolean override) {
        return false;
    }

    public boolean canBeCastBy(TileEntityDispenser dispenser) {
        return false;
    }
}

