/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.ancientspellcraft.spell;

import com.windanesz.ancientspellcraft.registry.ASItems;
import com.windanesz.ancientspellcraft.registry.ASSpells;
import com.windanesz.ancientspellcraft.spell.IClassSpell;
import com.windanesz.ancientspellcraft.spell.WarlockElementalSpellEffects;
import com.windanesz.ancientspellcraft.util.ASUtils;
import com.windanesz.ancientspellcraft.util.WizardArmourUtils;
import electroblob.wizardry.client.DrawingUtils;
import electroblob.wizardry.constants.Element;
import electroblob.wizardry.data.IStoredVariable;
import electroblob.wizardry.data.Persistence;
import electroblob.wizardry.data.WizardData;
import electroblob.wizardry.item.ItemWizardArmour;
import electroblob.wizardry.item.SpellActions;
import electroblob.wizardry.spell.Spell;
import electroblob.wizardry.util.AllyDesignationSystem;
import electroblob.wizardry.util.EntityUtils;
import electroblob.wizardry.util.ParticleBuilder;
import electroblob.wizardry.util.SpellModifiers;
import java.util.Optional;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemPotion;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.potion.PotionUtils;
import net.minecraft.tileentity.TileEntityDispenser;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public class AbsorbPotion
extends Spell
implements IClassSpell {
    public static final IStoredVariable<String> EFFECT = IStoredVariable.StoredVariable.ofString((String)"AbsorbPotionEffect", (Persistence)Persistence.ALWAYS).setSynced();
    public static final IStoredVariable<Integer> DURATION = IStoredVariable.StoredVariable.ofInt((String)"AbsorbPotionDuration", (Persistence)Persistence.ALWAYS).withTicker(AbsorbPotion::update);

    public AbsorbPotion() {
        super("ancientspellcraft", "absorb_potion", SpellActions.SUMMON, true);
        WizardData.registerStoredVariables((IStoredVariable[])new IStoredVariable[]{EFFECT});
        this.addProperties(new String[]{"effect_radius"});
    }

    public boolean cast(World world, EntityPlayer caster, EnumHand hand, int ticksInUse, SpellModifiers modifiers) {
        Optional<Element> elementOptional = WizardArmourUtils.getFullSetElementForClassOptional((EntityLivingBase)caster, ItemWizardArmour.ArmourClass.WARLOCK);
        ItemStack potion = caster.func_184592_cb();
        if (!(potion.func_77973_b() instanceof ItemPotion)) {
            ASUtils.sendMessage((Entity)caster, "You must hold a potion in your offhand", true, new Object[0]);
        }
        if (ticksInUse % 40 == 0) {
            this.playSound(world, (EntityLivingBase)caster, ticksInUse, -1, modifiers, new String[0]);
        }
        if (elementOptional.isPresent()) {
            Element element = elementOptional.get();
            Random rand = caster.field_70170_p.field_73012_v;
            double posX = caster.field_70165_t;
            double posY = caster.field_70163_u;
            double posZ = caster.field_70161_v;
            if (world.field_72995_K) {
                if (world.func_82737_E() % 3L == 0L) {
                    ParticleBuilder.create((ResourceLocation)WarlockElementalSpellEffects.getElementalParticle(element), (Random)rand, (double)(posX + rand.nextDouble() * 0.5 * (double)(rand.nextBoolean() ? 1 : -1)), (double)posY, (double)(posZ + rand.nextDouble() * 0.5 * (double)(rand.nextBoolean() ? 1 : -1)), (double)0.03, (boolean)true).vel(0.0, 0.3, 0.0).clr(WarlockElementalSpellEffects.PARTICLE_COLOURS.get(element)[0]).time(20 + rand.nextInt(50)).spawn(world);
                    ParticleBuilder.create((ResourceLocation)WarlockElementalSpellEffects.getElementalParticle(element), (Random)rand, (double)(posX + rand.nextDouble() * 0.5 * (double)(rand.nextBoolean() ? 1 : -1)), (double)posY, (double)(posZ + rand.nextDouble() * 0.5 * (double)(rand.nextBoolean() ? 1 : -1)), (double)0.03, (boolean)true).vel(0.0, 0.3, 0.0).clr(WarlockElementalSpellEffects.PARTICLE_COLOURS.get(element)[1]).time(20 + rand.nextInt(50)).spawn(world);
                    ParticleBuilder.create((ResourceLocation)WarlockElementalSpellEffects.getElementalParticle(element), (Random)rand, (double)(posX + rand.nextDouble() * 0.2 * (double)(rand.nextBoolean() ? 1 : -1)), (double)posY, (double)(posZ + rand.nextDouble() * 0.2 * (double)(rand.nextBoolean() ? 1 : -1)), (double)0.03, (boolean)true).spin(0.7, 0.05).vel(0.0, 0.3, 0.0).clr(WarlockElementalSpellEffects.PARTICLE_COLOURS.get(element)[2]).time(20 + rand.nextInt(50)).spawn(world);
                }
                ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.FLASH).pos(caster.field_70165_t, caster.field_70163_u + 0.101, caster.field_70161_v).face(EnumFacing.UP).clr(DrawingUtils.mix((int)WarlockElementalSpellEffects.PARTICLE_COLOURS.get(element)[1], (int)WarlockElementalSpellEffects.PARTICLE_COLOURS.get(element)[2], (float)0.5f)).collide(false).scale(2.3f).time(10).spawn(world);
            }
            if (ticksInUse == 60 && !world.field_72995_K) {
                WizardData data = WizardData.get((EntityPlayer)caster);
                for (PotionEffect potioneffect : PotionUtils.func_185189_a((ItemStack)caster.func_184592_cb())) {
                    if (potioneffect.func_188419_a().func_76403_b()) continue;
                    ASUtils.sendMessage((Entity)caster, "Absorbed " + caster.func_184592_cb().func_82833_r(), true, new Object[0]);
                    data.setVariable(EFFECT, (Object)potioneffect.func_188419_a().getRegistryName().toString());
                    data.setVariable(DURATION, (Object)((int)((float)potioneffect.func_76459_b() * 0.7f)));
                    caster.func_184592_cb().func_190918_g(1);
                    caster.func_184811_cZ().func_185145_a(caster.func_184614_ca().func_77973_b(), 20);
                    data.sync();
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public ItemWizardArmour.ArmourClass getArmourClass() {
        return ItemWizardArmour.ArmourClass.WARLOCK;
    }

    private static int update(EntityPlayer player, Integer duration) {
        Integer n;
        Integer n2;
        if (duration == null) {
            return 0;
        }
        if (duration > 0 && duration % 10 == 0 && !player.field_70170_p.field_72995_K) {
            WizardData data = WizardData.get((EntityPlayer)player);
            String potionName = (String)data.getVariable(EFFECT);
            if (potionName == null) {
                WizardData.get((EntityPlayer)player).setVariable(EFFECT, null);
                WizardData.get((EntityPlayer)player).sync();
                return 0;
            }
            Potion potion = (Potion)ForgeRegistries.POTIONS.getValue(new ResourceLocation(potionName));
            if (potion != null) {
                boolean isAllyEffect = !potion.func_76398_f();
                for (EntityLivingBase target : EntityUtils.getEntitiesWithinRadius((double)ASSpells.absorb_potion.getProperty("effect_radius").floatValue(), (double)player.field_70165_t, (double)player.field_70163_u, (double)player.field_70161_v, (World)player.field_70170_p, EntityLivingBase.class)) {
                    boolean isAllied = AllyDesignationSystem.isAllied((EntityLivingBase)player, (EntityLivingBase)target);
                    if ((target == player || isAllyEffect || isAllied) && (target.field_70173_aa <= 20 || !isAllyEffect || !isAllied)) continue;
                    target.func_70690_d(new PotionEffect(potion, 50, 0));
                }
            }
        }
        if (duration > 1) {
            n2 = duration;
            n = duration = Integer.valueOf(duration - 1);
        } else if (duration == 1) {
            n2 = duration;
            n = duration = Integer.valueOf(duration - 1);
            WizardData.get((EntityPlayer)player).setVariable(EFFECT, (Object)"none");
            WizardData.get((EntityPlayer)player).sync();
        }
        return duration;
    }

    public boolean applicableForItem(Item item) {
        return item == ASItems.forbidden_tome;
    }

    public boolean canBeCastBy(EntityLiving npc, boolean override) {
        return false;
    }

    public boolean canBeCastBy(TileEntityDispenser dispenser) {
        return false;
    }
}

