/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.ancientspellcraft.spell;

import com.windanesz.ancientspellcraft.registry.ASItems;
import com.windanesz.ancientspellcraft.spell.IClassSpell;
import com.windanesz.ancientspellcraft.spell.WarlockElementalSpellEffects;
import electroblob.wizardry.constants.Element;
import electroblob.wizardry.data.IStoredVariable;
import electroblob.wizardry.data.Persistence;
import electroblob.wizardry.data.WizardData;
import electroblob.wizardry.entity.EntityMeteor;
import electroblob.wizardry.entity.projectile.EntityMagicArrow;
import electroblob.wizardry.entity.projectile.EntityMagicProjectile;
import electroblob.wizardry.item.ItemWizardArmour;
import electroblob.wizardry.item.SpellActions;
import electroblob.wizardry.spell.Spell;
import electroblob.wizardry.util.EntityUtils;
import electroblob.wizardry.util.ParticleBuilder;
import electroblob.wizardry.util.SpellModifiers;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IProjectile;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.item.Item;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntityDispenser;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class AbsorbProjectile
extends Spell
implements IClassSpell {
    public static final IStoredVariable<NBTTagCompound> ABSORBED_PROJECTILES = IStoredVariable.StoredVariable.ofNBT((String)"AbsorbedProjectiles", (Persistence)Persistence.ALWAYS);
    public static final IStoredVariable<Integer> ABSORBED_PROJECTILES_TIMER = IStoredVariable.StoredVariable.ofInt((String)"AbsorbedProjectilesDuration", (Persistence)Persistence.ALWAYS).withTicker(AbsorbProjectile::update);

    public AbsorbProjectile() {
        super("ancientspellcraft", "absorb_projectile", SpellActions.SUMMON, true);
        this.soundValues(1.0f, 1.0f, 0.4f);
        WizardData.registerStoredVariables((IStoredVariable[])new IStoredVariable[]{ABSORBED_PROJECTILES, ABSORBED_PROJECTILES_TIMER});
    }

    public boolean cast(World world, EntityPlayer caster, EnumHand hand, int ticksInUse, SpellModifiers modifiers) {
        return this.doEffect(world, (EntityLivingBase)caster, hand, ticksInUse, null, modifiers);
    }

    public boolean cast(World world, EntityLiving caster, EnumHand hand, int ticksInUse, EntityLivingBase target, SpellModifiers modifiers) {
        return this.doEffect(world, (EntityLivingBase)caster, hand, ticksInUse, target, modifiers);
    }

    public boolean doEffect(World world, EntityLivingBase caster, EnumHand hand, int ticksInUse, @Nullable EntityLivingBase target, SpellModifiers modifiers) {
        if (caster instanceof EntityPlayer) {
            Object projs;
            EntityPlayer player = (EntityPlayer)caster;
            if (!world.field_72995_K && player.func_70093_af() && ticksInUse % 5 == 0) {
                NBTTagList tagList;
                WizardData data = WizardData.get((EntityPlayer)player);
                projs = (NBTTagCompound)data.getVariable(ABSORBED_PROJECTILES);
                if (projs != null && !projs.func_82582_d() && projs.func_74764_b("List") && !(tagList = projs.func_150295_c("List", 10)).func_82582_d()) {
                    boolean f = false;
                    NBTTagCompound projectileInNBT = (NBTTagCompound)tagList.func_179238_g(0);
                    if (!projectileInNBT.func_74764_b("meteor")) {
                        Entity projectile;
                        projectileInNBT.func_186854_a("UUID", MathHelper.func_180182_a((Random)world.field_73012_v));
                        projectileInNBT.func_74782_a("Pos", (NBTBase)this.newDoubleNBTList(caster.field_70165_t, caster.field_70163_u + 0.5, caster.field_70161_v));
                        if (projectileInNBT.func_74764_b("lifetime")) {
                            projectileInNBT.func_74768_a("lifetime", 60);
                        }
                        if ((projectile = EntityList.func_75615_a((NBTTagCompound)projectileInNBT, (World)world)) instanceof EntityMagicProjectile) {
                            ((EntityMagicProjectile)projectile).func_184538_a((Entity)caster, caster.field_70125_A, caster.field_70177_z, 0.0f, 2.0f, 1.0f);
                            ((EntityMagicProjectile)projectile).field_184539_c = caster;
                            world.func_72838_d(projectile);
                            f = true;
                        } else if (projectile instanceof EntityArrow) {
                            ((EntityArrow)projectile).func_184547_a((Entity)caster, caster.field_70125_A, caster.field_70177_z, 0.0f, 3.0f, 1.0f);
                            ((EntityArrow)projectile).field_70250_c = caster;
                            ((EntityArrow)projectile).field_70251_a = EntityArrow.PickupStatus.DISALLOWED;
                            world.func_72838_d(projectile);
                            f = true;
                        } else if (projectile instanceof EntityMagicArrow) {
                            ((EntityMagicArrow)projectile).aim(caster, this.calculateVelocity((EntityMagicArrow)projectile, caster.func_70047_e() - 0.1f));
                            world.func_72838_d(projectile);
                            f = true;
                        }
                    } else {
                        EntityMeteor meteor = new EntityMeteor(world, caster.field_70165_t, caster.field_70163_u + (double)caster.func_70047_e(), caster.field_70161_v, 1.0f, EntityUtils.canDamageBlocks((Entity)caster, (World)world));
                        Vec3d direction = caster.func_70040_Z().func_186678_a(2.0);
                        meteor.field_70159_w = direction.field_72450_a;
                        meteor.field_70181_x = direction.field_72448_b;
                        meteor.field_70179_y = direction.field_72449_c;
                        world.func_72838_d((Entity)meteor);
                        f = true;
                    }
                    if (f) {
                        tagList.func_74744_a(0);
                        projs.func_74782_a("List", (NBTBase)tagList);
                        data.setVariable(ABSORBED_PROJECTILES, projs);
                    }
                }
            } else if (!caster.func_70093_af()) {
                List projectiles = EntityUtils.getEntitiesWithinRadius((double)4.0, (double)caster.field_70165_t, (double)caster.field_70163_u, (double)caster.field_70161_v, (World)caster.field_70170_p, Entity.class);
                projs = projectiles.iterator();
                while (projs.hasNext()) {
                    Entity projectile = (Entity)projs.next();
                    if (this.isProjectileOnGround(projectile) || !(projectile instanceof IProjectile) && !(projectile instanceof EntityMeteor)) continue;
                    WizardData data = WizardData.get((EntityPlayer)player);
                    NBTTagCompound projs2 = (NBTTagCompound)data.getVariable(ABSORBED_PROJECTILES);
                    if (projs2 == null) {
                        projs2 = new NBTTagCompound();
                    }
                    NBTTagCompound absorbedProjectile = new NBTTagCompound();
                    if (projectile instanceof EntityMeteor) {
                        absorbedProjectile.func_74757_a("meteor", true);
                    } else {
                        absorbedProjectile = projectile.serializeNBT();
                    }
                    NBTTagList tagList = new NBTTagList();
                    if (projs2.func_74764_b("List")) {
                        tagList = projs2.func_150295_c("List", 10);
                    }
                    tagList.func_74742_a((NBTBase)absorbedProjectile);
                    projs2.func_74782_a("List", (NBTBase)tagList);
                    data.setVariable(ABSORBED_PROJECTILES, (Object)projs2);
                    world.func_72900_e(projectile);
                }
            }
        } else {
            List projectiles = EntityUtils.getEntitiesWithinRadius((double)4.0, (double)caster.field_70165_t, (double)caster.field_70163_u, (double)caster.field_70161_v, (World)caster.field_70170_p, Entity.class);
            for (Entity projectile : projectiles) {
                if (this.isProjectileOnGround(projectile) || !(projectile instanceof IProjectile) && !(projectile instanceof EntityMeteor)) continue;
                if (world.field_72995_K) {
                    Element element = this.getElementOrMagicElement(caster);
                    for (int i = 0; i < 10; ++i) {
                        ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.FLASH).pos(projectile.field_70165_t, projectile.field_70163_u, projectile.field_70161_v).scale(2.0f).clr(WarlockElementalSpellEffects.PARTICLE_COLOURS.get(element)[world.field_73012_v.nextInt(2)]).pos(0.0, 0.0, 0.0).time(40).spawn(world);
                    }
                }
                world.func_72900_e(projectile);
            }
        }
        if (world.field_72995_K && !caster.func_70093_af()) {
            Element element = this.getElementOrMagicElement(caster);
            for (int i = 0; i < 5; ++i) {
                ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.FLASH).entity((Entity)caster).spin(1.0, (double)0.006f).scale(Math.max(0.5f, world.field_73012_v.nextFloat())).clr(WarlockElementalSpellEffects.PARTICLE_COLOURS.get(element)[world.field_73012_v.nextInt(2)]).pos(0.0, (double)(world.field_73012_v.nextFloat() * 2.0f + 0.1f), 0.0).time(40).spawn(world);
            }
        }
        return true;
    }

    protected float calculateVelocity(EntityMagicArrow projectile, float launchHeight) {
        float range = 20.0f;
        if (!projectile.doGravity()) {
            if (projectile.getLifetime() <= 0) {
                return 2.0f;
            }
            return range / (float)projectile.getLifetime();
        }
        float g = 0.05f;
        return range / MathHelper.func_76129_c((float)(2.0f * launchHeight / g));
    }

    private boolean isProjectileOnGround(Entity projectile) {
        return projectile.field_70170_p.func_184143_b(projectile.func_174813_aQ().func_186662_g(0.05));
    }

    @Override
    public ItemWizardArmour.ArmourClass getArmourClass() {
        return ItemWizardArmour.ArmourClass.WARLOCK;
    }

    public boolean applicableForItem(Item item) {
        return item == ASItems.forbidden_tome;
    }

    private static int update(EntityPlayer player, Integer duration) {
        return duration != null ? duration : 0;
    }

    protected NBTTagList newDoubleNBTList(double ... numbers) {
        NBTTagList nbttaglist = new NBTTagList();
        for (double d0 : numbers) {
            nbttaglist.func_74742_a((NBTBase)new NBTTagDouble(d0));
        }
        return nbttaglist;
    }

    public boolean canBeCastBy(EntityLiving npc, boolean override) {
        return false;
    }

    public boolean canBeCastBy(TileEntityDispenser dispenser) {
        return false;
    }
}

