/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.ancientspellcraft.spell;

import com.windanesz.ancientspellcraft.client.ClientProxy;
import com.windanesz.ancientspellcraft.registry.ASBlocks;
import com.windanesz.ancientspellcraft.registry.ASItems;
import com.windanesz.ancientspellcraft.ritual.WarlockAttunement;
import com.windanesz.ancientspellcraft.spell.IClassSpell;
import com.windanesz.ancientspellcraft.spell.WarlockElementalSpellEffects;
import com.windanesz.ancientspellcraft.util.ASUtils;
import com.windanesz.ancientspellcraft.util.WizardArmourUtils;
import electroblob.wizardry.Wizardry;
import electroblob.wizardry.client.DrawingUtils;
import electroblob.wizardry.constants.Element;
import electroblob.wizardry.constants.Tier;
import electroblob.wizardry.data.IStoredVariable;
import electroblob.wizardry.data.Persistence;
import electroblob.wizardry.data.WizardData;
import electroblob.wizardry.item.ItemSpellBook;
import electroblob.wizardry.item.ItemWizardArmour;
import electroblob.wizardry.item.SpellActions;
import electroblob.wizardry.registry.Spells;
import electroblob.wizardry.registry.WizardryItems;
import electroblob.wizardry.spell.Spell;
import electroblob.wizardry.util.ParticleBuilder;
import electroblob.wizardry.util.SpellModifiers;
import java.util.Optional;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntityDispenser;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;

public class AbsorbSpell
extends Spell
implements IClassSpell {
    public static final IStoredVariable<String> SPELL = IStoredVariable.StoredVariable.ofString((String)"AbsorbSpell", (Persistence)Persistence.ALWAYS);
    public static final String TIER_LIMIT = "tier_limit";

    public AbsorbSpell() {
        super("ancientspellcraft", "absorb_spell", SpellActions.SUMMON, true);
        WizardData.registerStoredVariables((IStoredVariable[])new IStoredVariable[]{SPELL});
        this.addProperties(new String[]{TIER_LIMIT});
    }

    public boolean cast(World world, EntityPlayer caster, EnumHand hand, int ticksInUse, SpellModifiers modifiers) {
        Optional<Element> elementOptional = WizardArmourUtils.getFullSetElementForClassOptional((EntityLivingBase)caster, ItemWizardArmour.ArmourClass.WARLOCK);
        ItemStack book = caster.func_184592_cb();
        if (!(book.func_77973_b() instanceof ItemSpellBook) || Spell.byMetadata((int)book.func_77960_j()) instanceof IClassSpell) {
            ASUtils.sendMessage((Entity)caster, "You must hold a regular spell book in your offhand", true, new Object[0]);
            return false;
        }
        if (ticksInUse % 40 == 0) {
            this.playSound(world, (EntityLivingBase)caster, ticksInUse, -1, modifiers, new String[0]);
        }
        Spell spell = Spell.byMetadata((int)book.func_77960_j());
        String rarity = book.func_77973_b().getForgeRarity(book).getName();
        if (spell.getTier().ordinal() > this.getProperty(TIER_LIMIT).intValue()) {
            ASUtils.sendMessage((Entity)caster, "This spell is too powerful to be absorbed", true, new Object[0]);
            return false;
        }
        if (elementOptional.isPresent()) {
            Element element = elementOptional.get();
            Random rand = caster.field_70170_p.field_73012_v;
            double posX = caster.field_70165_t;
            double posY = caster.field_70163_u;
            double posZ = caster.field_70161_v;
            if (world.field_72995_K) {
                if (world.func_82737_E() % 3L == 0L) {
                    ParticleBuilder.create((ResourceLocation)WarlockElementalSpellEffects.getElementalParticle(element), (Random)rand, (double)(posX + rand.nextDouble() * 0.5 * (double)(rand.nextBoolean() ? 1 : -1)), (double)posY, (double)(posZ + rand.nextDouble() * 0.5 * (double)(rand.nextBoolean() ? 1 : -1)), (double)0.03, (boolean)true).vel(0.0, 0.3, 0.0).clr(WarlockElementalSpellEffects.PARTICLE_COLOURS.get(element)[0]).time(20 + rand.nextInt(50)).spawn(world);
                    ParticleBuilder.create((ResourceLocation)WarlockElementalSpellEffects.getElementalParticle(element), (Random)rand, (double)(posX + rand.nextDouble() * 0.5 * (double)(rand.nextBoolean() ? 1 : -1)), (double)posY, (double)(posZ + rand.nextDouble() * 0.5 * (double)(rand.nextBoolean() ? 1 : -1)), (double)0.03, (boolean)true).vel(0.0, 0.3, 0.0).clr(WarlockElementalSpellEffects.PARTICLE_COLOURS.get(element)[1]).time(20 + rand.nextInt(50)).spawn(world);
                    ParticleBuilder.create((ResourceLocation)WarlockElementalSpellEffects.getElementalParticle(element), (Random)rand, (double)(posX + rand.nextDouble() * 0.2 * (double)(rand.nextBoolean() ? 1 : -1)), (double)posY, (double)(posZ + rand.nextDouble() * 0.2 * (double)(rand.nextBoolean() ? 1 : -1)), (double)0.03, (boolean)true).spin(0.7, 0.05).vel(0.0, 0.3, 0.0).clr(WarlockElementalSpellEffects.PARTICLE_COLOURS.get(element)[2]).time(20 + rand.nextInt(50)).spawn(world);
                }
                ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.FLASH).pos(caster.field_70165_t, caster.field_70163_u + 0.101, caster.field_70161_v).face(EnumFacing.UP).clr(DrawingUtils.mix((int)WarlockElementalSpellEffects.PARTICLE_COLOURS.get(element)[1], (int)WarlockElementalSpellEffects.PARTICLE_COLOURS.get(element)[2], (float)0.5f)).collide(false).scale(2.3f).time(10).spawn(world);
            }
            if (ticksInUse == 60) {
                WizardData data = WizardData.get((EntityPlayer)caster);
                if (this.isSpellAllowed(spell)) {
                    data.setVariable(SPELL, (Object)spell.getRegistryName().toString());
                    Wizardry.proxy.shakeScreen(caster, 10.0f);
                    caster.func_184597_cx();
                    ASUtils.sendMessage((Entity)caster, "Absorbed " + caster.func_184592_cb().func_82833_r(), true, new Object[0]);
                    this.spawnParticleEffect(world, 5.0, (EntityLivingBase)caster, modifiers);
                    caster.func_184592_cb().func_190918_g(1);
                }
                return true;
            }
        }
        return false;
    }

    public static Optional<Spell> getSpell(WizardData data) {
        return data.getVariable(SPELL) == null ? Optional.empty() : Optional.of(Spell.get((String)((String)data.getVariable(SPELL))));
    }

    public static Optional<Spell> getSpell(EntityPlayer player) {
        WizardData data = WizardData.get((EntityPlayer)player);
        return data.getVariable(SPELL) == null ? Optional.empty() : Optional.of(Spell.get((String)((String)data.getVariable(SPELL))));
    }

    protected void spawnParticleEffect(World world, double radius, EntityLivingBase caster, SpellModifiers modifiers) {
        if (!world.field_72995_K) {
            return;
        }
        Vec3d origin = caster.func_174791_d();
        int i = 0;
        while ((float)i < 40.0f * modifiers.get(WizardryItems.blast_upgrade)) {
            double particleX = origin.field_72450_a - 1.0 + 2.0 * world.field_73012_v.nextDouble();
            double particleZ = origin.field_72449_c - 1.0 + 2.0 * world.field_73012_v.nextDouble();
            ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.DARK_MAGIC).pos(particleX, origin.field_72448_b, particleZ).vel(particleX - origin.field_72450_a, 0.0, particleZ - origin.field_72449_c).clr(0.1f, 0.0f, 0.0f).spawn(world);
            particleX = origin.field_72450_a - 1.0 + 2.0 * world.field_73012_v.nextDouble();
            particleZ = origin.field_72449_c - 1.0 + 2.0 * world.field_73012_v.nextDouble();
            ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.SPARKLE).pos(particleX, origin.field_72448_b, particleZ).vel(particleX - origin.field_72450_a, 0.0, particleZ - origin.field_72449_c).time(30).clr(0.1f, 0.0f, 0.05f).spawn(world);
            particleX = origin.field_72450_a - 1.0 + 2.0 * world.field_73012_v.nextDouble();
            particleZ = origin.field_72449_c - 1.0 + 2.0 * world.field_73012_v.nextDouble();
            IBlockState block = world.func_180495_p(new BlockPos(origin.field_72450_a, origin.field_72448_b - 0.5, origin.field_72449_c));
            if (block != null) {
                world.func_175688_a(EnumParticleTypes.BLOCK_DUST, particleX, origin.field_72448_b, particleZ, particleX - origin.field_72450_a, 0.0, particleZ - origin.field_72449_c, new int[]{Block.func_176210_f((IBlockState)block)});
            }
            ++i;
        }
        ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.SPHERE).pos(origin.func_72441_c(0.0, 0.1, 0.0)).scale((float)radius * 0.8f).clr(0.8f, 0.0f, 0.05f).spawn(world);
    }

    private boolean isSpellAllowed(Spell spell) {
        return Spells.satiety != spell && Spells.replenish_hunger != spell;
    }

    public static boolean canCast(EntityPlayer caster) {
        return !caster.func_184811_cZ().func_185141_a(ItemSpellBook.func_150898_a((Block)ASBlocks.DIMENSION_FOCUS)) && (WarlockAttunement.isWarlockAttuned(caster) || WizardArmourUtils.isWearingFullSet((EntityLivingBase)caster, null, ItemWizardArmour.ArmourClass.WARLOCK));
    }

    @SideOnly(value=Side.CLIENT)
    public String getDescription() {
        if (Minecraft.func_71410_x().field_71439_g != null) {
            String descTransKey = super.getDescriptionTranslationKey();
            return Wizardry.proxy.translate(descTransKey, new Object[]{Keyboard.getKeyName((int)ClientProxy.KEY_ACTIVATE_CHARM_BAUBLE.func_151463_i()), Tier.values()[this.getProperty(TIER_LIMIT).intValue()].getDisplayName()});
        }
        return super.getDescription();
    }

    @Override
    public ItemWizardArmour.ArmourClass getArmourClass() {
        return ItemWizardArmour.ArmourClass.WARLOCK;
    }

    public boolean applicableForItem(Item item) {
        return item == ASItems.forbidden_tome;
    }

    public boolean canBeCastBy(EntityLiving npc, boolean override) {
        return false;
    }

    public boolean canBeCastBy(TileEntityDispenser dispenser) {
        return false;
    }
}

