/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.ancientspellcraft.spell;

import com.windanesz.ancientspellcraft.AncientSpellcraft;
import com.windanesz.ancientspellcraft.Settings;
import com.windanesz.ancientspellcraft.registry.ASItems;
import com.windanesz.ancientspellcraft.spell.IClassSpell;
import electroblob.wizardry.item.ItemArtefact;
import electroblob.wizardry.item.ItemWizardArmour;
import electroblob.wizardry.item.SpellActions;
import electroblob.wizardry.potion.Curse;
import electroblob.wizardry.registry.WizardryPotions;
import electroblob.wizardry.spell.Spell;
import electroblob.wizardry.util.SpellModifiers;
import java.util.ArrayList;
import java.util.HashMap;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemLingeringPotion;
import net.minecraft.item.ItemPotion;
import net.minecraft.item.ItemSplashPotion;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.potion.PotionUtils;
import net.minecraft.tileentity.TileEntityDispenser;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public class AlterPotion
extends Spell
implements IClassSpell {
    public AlterPotion() {
        super("ancientspellcraft", "alter_potion", SpellActions.IMBUE, false);
    }

    @Override
    public ItemWizardArmour.ArmourClass getArmourClass() {
        return ItemWizardArmour.ArmourClass.WARLOCK;
    }

    public boolean applicableForItem(Item item) {
        return item == ASItems.forbidden_tome;
    }

    public boolean canBeCastBy(TileEntityDispenser dispenser) {
        return false;
    }

    public boolean cast(World world, EntityPlayer caster, EnumHand hand, int ticksInUse, SpellModifiers modifiers) {
        if (ItemArtefact.isArtefactActive((EntityPlayer)caster, (Item)ASItems.charm_potion_kit)) {
            if (caster.func_184592_cb().func_77973_b() == Items.field_151069_bo && !caster.func_70651_bq().isEmpty()) {
                PotionEffect firstEffect = (PotionEffect)caster.func_70651_bq().stream().findFirst().get();
                String effectName = AncientSpellcraft.proxy.translate(firstEffect.func_188419_a().func_76393_a(), new Object[0]);
                String potionTypePrefix = caster.func_70093_af() ? "Infused Lingering Potion of " : "Infused Splash Potion of ";
                ItemStack stack = new ItemStack((Item)(caster.func_70093_af() ? Items.field_185156_bI : Items.field_185155_bH));
                String displayName = potionTypePrefix + effectName;
                stack.func_151001_c(displayName);
                NBTTagCompound nbt = stack.func_77978_p();
                if (firstEffect.func_188419_a() == WizardryPotions.frost) {
                    nbt.func_74768_a("CustomPotionColor", 3726828);
                } else {
                    nbt.func_74768_a("CustomPotionColor", firstEffect.func_188419_a().func_76401_j());
                }
                stack.func_77982_d(nbt);
                ArrayList<PotionEffect> effectList = new ArrayList<PotionEffect>(PotionUtils.func_185189_a((ItemStack)caster.func_184592_cb()));
                if (caster.func_70093_af()) {
                    effectList.add(new PotionEffect(firstEffect.func_188419_a(), (int)((float)firstEffect.func_76459_b() * 0.1f)));
                } else {
                    effectList.add(firstEffect);
                }
                PotionUtils.func_185184_a((ItemStack)stack, effectList);
                caster.func_184611_a(EnumHand.OFF_HAND, stack);
                if (!(firstEffect.func_188419_a() instanceof Curse)) {
                    caster.func_184589_d(firstEffect.func_188419_a());
                }
            }
            return true;
        }
        if (caster.func_184592_cb().func_77973_b() instanceof ItemPotion) {
            ArrayList<PotionEffect> effectList = new ArrayList<PotionEffect>(PotionUtils.func_185189_a((ItemStack)caster.func_184592_cb()));
            HashMap<String, String> potionMapping = new HashMap<String, String>();
            boolean updated = false;
            for (String mapping : Settings.generalSettings.alter_potion_mapping) {
                String[] parts = mapping.split("\\|");
                potionMapping.put(parts[0], parts[1]);
                potionMapping.put(parts[1], parts[0]);
            }
            for (PotionEffect effect : PotionUtils.func_185189_a((ItemStack)caster.func_184592_cb())) {
                String counterpart;
                if (!potionMapping.containsKey(effect.func_188419_a().getRegistryName().toString()) || !ForgeRegistries.POTIONS.containsKey(new ResourceLocation(counterpart = (String)potionMapping.get(effect.func_188419_a().getRegistryName().toString())))) continue;
                Potion potion = (Potion)ForgeRegistries.POTIONS.getValue(new ResourceLocation(counterpart));
                effectList.remove(effect);
                effectList.add(new PotionEffect(potion, effect.func_76459_b(), effect.func_76458_c()));
                updated = true;
            }
            if (updated) {
                PotionEffect firstEffect = (PotionEffect)effectList.get(0);
                String effectName = AncientSpellcraft.proxy.translate(firstEffect.func_188419_a().func_76393_a(), new Object[0]);
                String potionTypePrefix = "";
                potionTypePrefix = caster.func_184592_cb().func_77973_b() instanceof ItemSplashPotion ? "Infused Splash Potion of " : (caster.func_184592_cb().func_77973_b() instanceof ItemLingeringPotion ? "Infused Lingering Potion of " : "Infused Potion of ");
                ItemStack stack = new ItemStack(caster.func_184592_cb().func_77973_b());
                String displayName = potionTypePrefix + effectName;
                stack.func_151001_c(displayName);
                NBTTagCompound nbt = stack.func_77978_p();
                nbt.func_74768_a("CustomPotionColor", firstEffect.func_188419_a().func_76401_j());
                stack.func_77982_d(nbt);
                PotionUtils.func_185184_a((ItemStack)stack, effectList);
                caster.func_184611_a(EnumHand.OFF_HAND, stack);
                return true;
            }
        }
        return false;
    }

    public boolean canBeCastBy(EntityLiving npc, boolean override) {
        return false;
    }
}

