/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.ancientspellcraft.spell;

import com.windanesz.ancientspellcraft.registry.ASItems;
import com.windanesz.ancientspellcraft.util.ASUtils;
import electroblob.wizardry.item.ItemArtefact;
import electroblob.wizardry.registry.WizardryItems;
import electroblob.wizardry.spell.Spell;
import electroblob.wizardry.util.ParticleBuilder;
import electroblob.wizardry.util.SpellModifiers;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntityDispenser;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ArcaneMagnetism
extends Spell {
    public ArcaneMagnetism() {
        super("ancientspellcraft", "arcane_magnetism", EnumAction.BOW, true);
        this.addProperties(new String[]{"effect_radius"});
    }

    public boolean canBeCastBy(EntityLiving npc, boolean override) {
        return false;
    }

    public boolean canBeCastBy(TileEntityDispenser dispenser) {
        return true;
    }

    protected SoundEvent[] createSounds() {
        return this.createContinuousSpellSounds();
    }

    protected void playSound(World world, EntityLivingBase entity, int ticksInUse, int duration, SpellModifiers modifiers, String ... sounds) {
        this.playSoundLoop(world, entity, ticksInUse);
    }

    protected void playSound(World world, double x, double y, double z, int ticksInUse, int duration, SpellModifiers modifiers, String ... sounds) {
        this.playSoundLoop(world, x, y, z, ticksInUse, duration);
    }

    public boolean cast(World world, EntityPlayer caster, EnumHand hand, int ticksInUse, SpellModifiers modifiers) {
        this.performEffect(world, caster.func_174824_e(0.0f).func_178786_a(0.0, 0.1, 0.0), (EntityLivingBase)caster, modifiers, ticksInUse);
        this.playSound(world, (EntityLivingBase)caster, ticksInUse, -1, modifiers, new String[0]);
        return true;
    }

    public boolean cast(World world, EntityLiving caster, EnumHand hand, int ticksInUse, EntityLivingBase target, SpellModifiers modifiers) {
        this.performEffect(world, caster.func_174824_e(0.0f).func_178786_a(0.0, 0.1, 0.0), (EntityLivingBase)caster, modifiers, ticksInUse);
        this.playSound(world, (EntityLivingBase)caster, ticksInUse, -1, modifiers, new String[0]);
        return true;
    }

    public boolean cast(World world, double x, double y, double z, EnumFacing direction, int ticksInUse, int duration, SpellModifiers modifiers) {
        this.performEffect(world, new Vec3d(x, y, z), null, modifiers, ticksInUse);
        this.playSound(world, x - (double)direction.func_82601_c(), y - (double)direction.func_96559_d(), z - (double)direction.func_82599_e(), ticksInUse, duration, modifiers, new String[0]);
        return true;
    }

    private void performEffect(World world, Vec3d centre, @Nullable EntityLivingBase caster, SpellModifiers modifiers, int ticksInUse) {
        double radius = this.getProperty("effect_radius").floatValue() * modifiers.get(WizardryItems.blast_upgrade);
        List<EntityItem> targets = ASUtils.getEntityItemsWithinRadius(radius, centre.field_72450_a, centre.field_72448_b, centre.field_72449_c, world);
        for (EntityItem entityItem : targets) {
            EntityPlayer player;
            if (caster instanceof EntityPlayer && ItemArtefact.isArtefactActive((EntityPlayer)(player = (EntityPlayer)caster), (Item)ASItems.ring_lodestone) && !player.func_184592_cb().func_190926_b()) {
                ItemStack stack = player.func_184592_cb();
                if (!ItemStack.func_185132_d((ItemStack)entityItem.func_92059_d(), (ItemStack)stack)) continue;
            }
            entityItem.field_70159_w = Math.abs((double)caster.func_180425_c().func_177958_n() - entityItem.field_70165_t) > 0.04 ? ((double)caster.func_180425_c().func_177958_n() - entityItem.field_70165_t) / 20.0 : ((double)caster.func_180425_c().func_177958_n() - entityItem.field_70165_t) / 10.0;
            entityItem.field_70181_x = Math.abs((double)caster.func_180425_c().func_177956_o() + 0.3 - entityItem.field_70163_u) > 0.02 ? ((double)caster.func_180425_c().func_177956_o() - entityItem.field_70163_u) / 20.0 : ((double)caster.func_180425_c().func_177956_o() - entityItem.field_70163_u) / 5.0;
            double d = entityItem.field_70179_y = Math.abs((double)caster.func_180425_c().func_177952_p() - entityItem.field_70161_v) > 0.04 ? ((double)caster.func_180425_c().func_177952_p() - entityItem.field_70161_v) / 20.0 : ((double)caster.func_180425_c().func_177952_p() - entityItem.field_70161_v) / 10.0;
            if (!world.field_72995_K || ticksInUse % 5 != 0) continue;
            ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.FLASH).entity((Entity)entityItem).pos(0.0, 0.3, 0.0).clr(137, 19, 235).scale(1.0f).spawn(world);
        }
        if (world.field_72995_K && ticksInUse % 5 == 0) {
            ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.FLASH).entity((Entity)caster).clr(137, 19, 235).scale(4.0f).pos(caster != null ? centre.func_178788_d(caster.func_174791_d()) : centre).spawn(world);
        }
    }

    public boolean applicableForItem(Item item) {
        return item == ASItems.ancient_spell_book || item == ASItems.ancient_spellcraft_scroll;
    }

    @SideOnly(value=Side.CLIENT)
    public String getDisplayNameWithFormatting() {
        return TextFormatting.GOLD + I18n.func_135052_a((String)this.getTranslationKey(), (Object[])new Object[0]);
    }
}

