/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.ancientspellcraft.spell;

import com.windanesz.ancientspellcraft.registry.ASItems;
import electroblob.wizardry.data.IStoredVariable;
import electroblob.wizardry.data.Persistence;
import electroblob.wizardry.data.WizardData;
import electroblob.wizardry.item.IManaStoringItem;
import electroblob.wizardry.item.ItemArtefact;
import electroblob.wizardry.spell.Spell;
import electroblob.wizardry.util.ParticleBuilder;
import electroblob.wizardry.util.SpellModifiers;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;

public class AttireAlteration
extends Spell {
    private static final IStoredVariable<ItemStack> HEAD_SLOT = IStoredVariable.StoredVariable.ofItemStack((String)"attire_head_slot", (Persistence)Persistence.ALWAYS).withTicker(AttireAlteration::update);
    private static final IStoredVariable<ItemStack> CHEST_SLOT = IStoredVariable.StoredVariable.ofItemStack((String)"attire_chest_slot", (Persistence)Persistence.ALWAYS).withTicker(AttireAlteration::update);
    private static final IStoredVariable<ItemStack> LEGS_SLOT = IStoredVariable.StoredVariable.ofItemStack((String)"attire_legs_slot", (Persistence)Persistence.ALWAYS).withTicker(AttireAlteration::update);
    private static final IStoredVariable<ItemStack> FEET_SLOT = IStoredVariable.StoredVariable.ofItemStack((String)"attire_feet_slot", (Persistence)Persistence.ALWAYS).withTicker(AttireAlteration::update);
    private static final IStoredVariable<NBTTagCompound> WARDROBE_SET_1 = IStoredVariable.StoredVariable.ofNBT((String)"wardrobe_set_1", (Persistence)Persistence.ALWAYS);
    private static final IStoredVariable<NBTTagCompound> WARDROBE_SET_2 = IStoredVariable.StoredVariable.ofNBT((String)"wardrobe_set_2", (Persistence)Persistence.ALWAYS);
    private static final IStoredVariable<NBTTagCompound> WARDROBE_SET_3 = IStoredVariable.StoredVariable.ofNBT((String)"wardrobe_set_3", (Persistence)Persistence.ALWAYS);
    private static final IStoredVariable<NBTTagCompound> WARDROBE_SET_4 = IStoredVariable.StoredVariable.ofNBT((String)"wardrobe_set_4", (Persistence)Persistence.ALWAYS);
    private static final IStoredVariable<NBTTagCompound> WARDROBE_SET_5 = IStoredVariable.StoredVariable.ofNBT((String)"wardrobe_set_5", (Persistence)Persistence.ALWAYS);
    private static final IStoredVariable<Integer> CURRENT_WARDROBE_SET = IStoredVariable.StoredVariable.ofInt((String)"current_wardrobe_set", (Persistence)Persistence.ALWAYS);

    public AttireAlteration() {
        super("ancientspellcraft", "attire_alteration", EnumAction.BLOCK, false);
        WizardData.registerStoredVariables((IStoredVariable[])new IStoredVariable[]{HEAD_SLOT, CHEST_SLOT, LEGS_SLOT, FEET_SLOT, WARDROBE_SET_1, WARDROBE_SET_2, WARDROBE_SET_3, WARDROBE_SET_4, WARDROBE_SET_5, CURRENT_WARDROBE_SET});
    }

    public boolean cast(World world, EntityPlayer player, EnumHand hand, int ticksInUse, SpellModifiers modifiers) {
        if (world.field_72995_K) {
            this.spawnParticles(world, (EntityLivingBase)player, modifiers);
            this.playSound(world, (EntityLivingBase)player, ticksInUse, -1, modifiers, new String[0]);
        }
        return AttireAlteration.swapArmour(player, world, modifiers, ticksInUse);
    }

    public static boolean swapArmour(EntityPlayer player, World world, SpellModifiers modifiers, int ticksInUse) {
        WizardData data = WizardData.get((EntityPlayer)player);
        if (data != null) {
            boolean hasWardrobe = ItemArtefact.isArtefactActive((EntityPlayer)player, (Item)ASItems.charm_wardrobe);
            if (hasWardrobe) {
                return AttireAlteration.swapWardrobeSet(player, data, world);
            }
            return AttireAlteration.swapSingleSet(player, data);
        }
        return true;
    }

    private static boolean swapWardrobeSet(EntityPlayer player, WizardData data, World world) {
        Integer currentSet = (Integer)data.getVariable(CURRENT_WARDROBE_SET);
        if (currentSet == null) {
            currentSet = 0;
        }
        int nextSet = (currentSet + 1) % 5;
        AttireAlteration.saveToWardrobeSet(data, currentSet, player);
        data.setVariable(CURRENT_WARDROBE_SET, (Object)nextSet);
        AttireAlteration.loadFromWardrobeSet(data, nextSet, player);
        return true;
    }

    private static boolean swapSingleSet(EntityPlayer player, WizardData data) {
        ItemStack storedHead = AttireAlteration.getStack(HEAD_SLOT, data);
        ItemStack storedChest = AttireAlteration.getStack(CHEST_SLOT, data);
        ItemStack storedLegs = AttireAlteration.getStack(LEGS_SLOT, data);
        ItemStack storedFeet = AttireAlteration.getStack(FEET_SLOT, data);
        data.setVariable(HEAD_SLOT, (Object)player.func_184582_a(EntityEquipmentSlot.HEAD));
        data.setVariable(CHEST_SLOT, (Object)player.func_184582_a(EntityEquipmentSlot.CHEST));
        data.setVariable(LEGS_SLOT, (Object)player.func_184582_a(EntityEquipmentSlot.LEGS));
        data.setVariable(FEET_SLOT, (Object)player.func_184582_a(EntityEquipmentSlot.FEET));
        player.func_184201_a(EntityEquipmentSlot.HEAD, storedHead);
        player.func_184201_a(EntityEquipmentSlot.CHEST, storedChest);
        player.func_184201_a(EntityEquipmentSlot.LEGS, storedLegs);
        player.func_184201_a(EntityEquipmentSlot.FEET, storedFeet);
        return true;
    }

    private static void saveToWardrobeSet(WizardData data, int setNumber, EntityPlayer player) {
        NBTTagCompound setData = new NBTTagCompound();
        ItemStack head = player.func_184582_a(EntityEquipmentSlot.HEAD);
        ItemStack chest = player.func_184582_a(EntityEquipmentSlot.CHEST);
        ItemStack legs = player.func_184582_a(EntityEquipmentSlot.LEGS);
        ItemStack feet = player.func_184582_a(EntityEquipmentSlot.FEET);
        NBTTagCompound headTag = new NBTTagCompound();
        head.func_77955_b(headTag);
        setData.func_74782_a("head", (NBTBase)headTag);
        NBTTagCompound chestTag = new NBTTagCompound();
        chest.func_77955_b(chestTag);
        setData.func_74782_a("chest", (NBTBase)chestTag);
        NBTTagCompound legsTag = new NBTTagCompound();
        legs.func_77955_b(legsTag);
        setData.func_74782_a("legs", (NBTBase)legsTag);
        NBTTagCompound feetTag = new NBTTagCompound();
        feet.func_77955_b(feetTag);
        setData.func_74782_a("feet", (NBTBase)feetTag);
        switch (setNumber) {
            case 0: {
                data.setVariable(WARDROBE_SET_1, (Object)setData);
                break;
            }
            case 1: {
                data.setVariable(WARDROBE_SET_2, (Object)setData);
                break;
            }
            case 2: {
                data.setVariable(WARDROBE_SET_3, (Object)setData);
                break;
            }
            case 3: {
                data.setVariable(WARDROBE_SET_4, (Object)setData);
                break;
            }
            case 4: {
                data.setVariable(WARDROBE_SET_5, (Object)setData);
            }
        }
    }

    private static void loadFromWardrobeSet(WizardData data, int setNumber, EntityPlayer player) {
        NBTTagCompound setData = null;
        switch (setNumber) {
            case 0: {
                setData = (NBTTagCompound)data.getVariable(WARDROBE_SET_1);
                break;
            }
            case 1: {
                setData = (NBTTagCompound)data.getVariable(WARDROBE_SET_2);
                break;
            }
            case 2: {
                setData = (NBTTagCompound)data.getVariable(WARDROBE_SET_3);
                break;
            }
            case 3: {
                setData = (NBTTagCompound)data.getVariable(WARDROBE_SET_4);
                break;
            }
            case 4: {
                setData = (NBTTagCompound)data.getVariable(WARDROBE_SET_5);
            }
        }
        if (setData != null) {
            if (setData.func_74764_b("head")) {
                ItemStack head = new ItemStack(setData.func_74775_l("head"));
                player.func_184201_a(EntityEquipmentSlot.HEAD, head);
            } else {
                player.func_184201_a(EntityEquipmentSlot.HEAD, ItemStack.field_190927_a);
            }
            if (setData.func_74764_b("chest")) {
                ItemStack chest = new ItemStack(setData.func_74775_l("chest"));
                player.func_184201_a(EntityEquipmentSlot.CHEST, chest);
            } else {
                player.func_184201_a(EntityEquipmentSlot.CHEST, ItemStack.field_190927_a);
            }
            if (setData.func_74764_b("legs")) {
                ItemStack legs = new ItemStack(setData.func_74775_l("legs"));
                player.func_184201_a(EntityEquipmentSlot.LEGS, legs);
            } else {
                player.func_184201_a(EntityEquipmentSlot.LEGS, ItemStack.field_190927_a);
            }
            if (setData.func_74764_b("feet")) {
                ItemStack feet = new ItemStack(setData.func_74775_l("feet"));
                player.func_184201_a(EntityEquipmentSlot.FEET, feet);
            } else {
                player.func_184201_a(EntityEquipmentSlot.FEET, ItemStack.field_190927_a);
            }
        } else {
            player.func_184201_a(EntityEquipmentSlot.HEAD, ItemStack.field_190927_a);
            player.func_184201_a(EntityEquipmentSlot.CHEST, ItemStack.field_190927_a);
            player.func_184201_a(EntityEquipmentSlot.LEGS, ItemStack.field_190927_a);
            player.func_184201_a(EntityEquipmentSlot.FEET, ItemStack.field_190927_a);
        }
    }

    private static ItemStack getStack(IStoredVariable<ItemStack> variable, WizardData data) {
        ItemStack stack = (ItemStack)data.getVariable(variable);
        return stack != null ? stack : ItemStack.field_190927_a;
    }

    private void spawnParticles(World world, EntityLivingBase caster, SpellModifiers modifiers) {
        ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.BUFF).entity((Entity)caster).clr(1, 72, 0).spawn(world);
    }

    private static ItemStack update(EntityPlayer player, ItemStack stack) {
        if (!player.field_70170_p.field_72995_K && player.field_70173_aa % 200 == 0 && ItemArtefact.isArtefactActive((EntityPlayer)player, (Item)ASItems.charm_enchanted_needle) && stack != null && stack != ItemStack.field_190927_a && stack.func_77973_b() instanceof IManaStoringItem) {
            ((IManaStoringItem)stack.func_77973_b()).rechargeMana(stack, 2);
        }
        return stack;
    }

    public boolean applicableForItem(Item item) {
        return item == ASItems.ancient_spellcraft_spell_book || item == ASItems.ancient_spellcraft_scroll;
    }
}

