/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.ancientspellcraft.spell;

import com.windanesz.ancientspellcraft.entity.living.EntityWolfMinion;
import com.windanesz.ancientspellcraft.registry.ASItems;
import electroblob.wizardry.item.SpellActions;
import electroblob.wizardry.registry.WizardryItems;
import electroblob.wizardry.spell.Spell;
import electroblob.wizardry.util.BlockUtils;
import electroblob.wizardry.util.SpellModifiers;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class CallOfThePack
extends Spell {
    public static final String MINION_LIFETIME = "minion_lifetime";
    public static final String MINION_COUNT = "minion_count";
    public static final String SUMMON_RADIUS = "summon_radius";
    public static final String HEALTH_MODIFIER = "minion_health";
    public static final String POTENCY_ATTRIBUTE_MODIFIER = "potency";

    public CallOfThePack() {
        super("ancientspellcraft", "call_of_the_pack", SpellActions.SUMMON, false);
        this.addProperties(new String[]{MINION_LIFETIME, MINION_COUNT, SUMMON_RADIUS});
    }

    protected void addMinionExtras(EntityWolfMinion minion, BlockPos pos, @Nullable EntityLivingBase caster, SpellModifiers modifiers, int alreadySpawned) {
        minion.func_180482_a(minion.field_70170_p.func_175649_E(pos), null);
    }

    public boolean applicableForItem(Item item) {
        return item == ASItems.ancient_spellcraft_spell_book || item == ASItems.ancient_spellcraft_scroll;
    }

    public boolean cast(World world, EntityPlayer caster, EnumHand hand, int ticksInUse, SpellModifiers modifiers) {
        if (!this.spawnMinions(world, (EntityLivingBase)caster, modifiers)) {
            return false;
        }
        this.playSound(world, (EntityLivingBase)caster, ticksInUse, -1, modifiers, new String[0]);
        return true;
    }

    protected boolean spawnMinions(World world, EntityLivingBase caster, SpellModifiers modifiers) {
        if (!world.field_72995_K) {
            for (int i = 0; i < this.getProperty(MINION_COUNT).intValue(); ++i) {
                int range = this.getProperty(SUMMON_RADIUS).intValue();
                BlockPos pos = BlockUtils.findNearbyFloorSpace((Entity)caster, (int)range, (int)(range * 2));
                if (pos == null) {
                    return false;
                }
                EntityWolfMinion minion = new EntityWolfMinion(world);
                minion.func_70107_b((double)pos.func_177958_n() + 0.5, pos.func_177956_o(), (double)pos.func_177952_p() + 0.5);
                minion.setOwner(caster);
                minion.setLifetime((int)(this.getProperty(MINION_LIFETIME).floatValue() * modifiers.get(WizardryItems.duration_upgrade)));
                IAttributeInstance attribute = minion.func_110148_a(SharedMonsterAttributes.field_111264_e);
                attribute.func_111121_a(new AttributeModifier(POTENCY_ATTRIBUTE_MODIFIER, (double)(modifiers.get(POTENCY_ATTRIBUTE_MODIFIER) - 1.0f), 2));
                minion.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111121_a(new AttributeModifier(HEALTH_MODIFIER, (double)(modifiers.get(HEALTH_MODIFIER) - 1.0f), 2));
                minion.func_70606_j(minion.func_110138_aP());
                this.addMinionExtras(minion, pos, caster, modifiers, i);
                world.func_72838_d((Entity)minion);
            }
        }
        return true;
    }
}

