/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.ancientspellcraft.spell;

import com.windanesz.ancientspellcraft.registry.ASItems;
import electroblob.wizardry.constants.SpellType;
import electroblob.wizardry.item.IManaStoringItem;
import electroblob.wizardry.item.ISpellCastingItem;
import electroblob.wizardry.item.ItemScroll;
import electroblob.wizardry.item.SpellActions;
import electroblob.wizardry.spell.Spell;
import electroblob.wizardry.spell.SpellBuff;
import electroblob.wizardry.spell.SpellRay;
import electroblob.wizardry.util.SpellModifiers;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ChannelEffects
extends SpellRay {
    public ChannelEffects() {
        super("ancientspellcraft", "channel_effect", SpellActions.POINT, false);
    }

    public boolean cast(World world, EntityPlayer player, EnumHand hand, int ticksInUse, SpellModifiers modifiers) {
        EnumHand otherHand;
        EnumHand enumHand = otherHand = hand == EnumHand.MAIN_HAND ? EnumHand.OFF_HAND : EnumHand.MAIN_HAND;
        if (!player.func_184586_b(otherHand).func_190926_b()) {
            ItemStack stack = player.func_184586_b(otherHand);
            if (stack.func_77973_b() instanceof ISpellCastingItem) {
                Spell spell = ((ISpellCastingItem)stack.func_77973_b()).getCurrentSpell(stack);
                if (ChannelEffects.isValidSpell().test(spell)) {
                    if (stack.func_77973_b() instanceof ItemScroll) {
                        boolean status = super.cast(world, player, hand, ticksInUse, modifiers);
                        if (status && !world.field_72995_K) {
                            stack.func_190918_g(1);
                        }
                        return status;
                    }
                    if (stack.func_77973_b() instanceof ISpellCastingItem && stack.func_77973_b() instanceof IManaStoringItem) {
                        int spellCost = (int)modifiers.get("cost");
                        if (((IManaStoringItem)stack.func_77973_b()).getMana(stack) >= spellCost) {
                            boolean status = super.cast(world, player, hand, ticksInUse, modifiers);
                            if (status && !world.field_72995_K) {
                                ((IManaStoringItem)stack.func_77973_b()).consumeMana(stack, spellCost, (EntityLivingBase)player);
                            }
                            return status;
                        }
                        if (!world.field_72995_K) {
                            player.func_146105_b((ITextComponent)new TextComponentTranslation("spell." + this.getUnlocalisedName() + ".not_enough_mana", new Object[0]), true);
                        }
                    } else if (!world.field_72995_K) {
                        player.func_146105_b((ITextComponent)new TextComponentTranslation("spell." + this.getUnlocalisedName() + ".missing_required_item", new Object[0]), true);
                    }
                } else if (!world.field_72995_K) {
                    player.func_146105_b((ITextComponent)new TextComponentTranslation("spell." + this.getUnlocalisedName() + ".invalid_spell", new Object[0]), true);
                }
            } else if (!world.field_72995_K) {
                player.func_146105_b((ITextComponent)new TextComponentTranslation("spell." + this.getUnlocalisedName() + ".missing_required_item", new Object[0]), true);
            }
        } else if (!world.field_72995_K) {
            player.func_146105_b((ITextComponent)new TextComponentTranslation("spell." + this.getUnlocalisedName() + ".missing_required_item", new Object[0]), true);
        }
        return false;
    }

    protected boolean onEntityHit(World world, Entity target, Vec3d hit, @Nullable EntityLivingBase caster, Vec3d origin, int ticksInUse, SpellModifiers modifiers) {
        if (caster == null) {
            return false;
        }
        if (!caster.func_184592_cb().func_190926_b() && caster.func_184592_cb().func_77973_b() instanceof ISpellCastingItem) {
            return this.attemptCastingForTarget(world, target, caster, modifiers, EnumHand.OFF_HAND);
        }
        if (!caster.func_184614_ca().func_190926_b() && caster.func_184614_ca().func_77973_b() instanceof ISpellCastingItem) {
            return this.attemptCastingForTarget(world, target, caster, modifiers, EnumHand.MAIN_HAND);
        }
        return false;
    }

    private boolean attemptCastingForTarget(World world, Entity target, EntityLivingBase caster, SpellModifiers modifiers, EnumHand hand) {
        ItemStack stack = caster.func_184586_b(hand);
        ISpellCastingItem item = (ISpellCastingItem)stack.func_77973_b();
        Spell spell = item.getCurrentSpell(stack);
        if (ChannelEffects.isValidSpell().test(spell)) {
            if (target instanceof EntityPlayer) {
                return spell.cast(world, (EntityPlayer)target, EnumHand.MAIN_HAND, 0, modifiers);
            }
            if (target instanceof EntityLiving) {
                EntityLiving npc = (EntityLiving)target;
                return spell.cast(world, npc, EnumHand.MAIN_HAND, 0, (EntityLivingBase)((EntityLiving)target), modifiers);
            }
        }
        return false;
    }

    protected boolean onBlockHit(World world, BlockPos pos, EnumFacing side, Vec3d hit, @Nullable EntityLivingBase caster, Vec3d origin, int ticksInUse, SpellModifiers modifiers) {
        return false;
    }

    protected boolean onMiss(World world, @Nullable EntityLivingBase caster, Vec3d origin, Vec3d direction, int ticksInUse, SpellModifiers modifiers) {
        return false;
    }

    private static Predicate<Spell> isValidSpell() {
        return spell -> spell != null && spell.getType() == SpellType.BUFF || spell instanceof SpellBuff;
    }

    public boolean applicableForItem(Item item) {
        return item == ASItems.ancient_spell_book || item == ASItems.ancient_spellcraft_scroll;
    }

    @SideOnly(value=Side.CLIENT)
    public String getDisplayNameWithFormatting() {
        return TextFormatting.GOLD + I18n.func_135052_a((String)this.getTranslationKey(), (Object[])new Object[0]);
    }
}

