/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.ancientspellcraft.spell;

import com.windanesz.ancientspellcraft.registry.ASItems;
import com.windanesz.ancientspellcraft.registry.ASSounds;
import com.windanesz.ancientspellcraft.spell.IClassSpell;
import com.windanesz.ancientspellcraft.spell.WarlockElementalSpellEffects;
import electroblob.wizardry.Wizardry;
import electroblob.wizardry.constants.Element;
import electroblob.wizardry.entity.ICustomHitbox;
import electroblob.wizardry.item.ItemArtefact;
import electroblob.wizardry.item.ItemWizardArmour;
import electroblob.wizardry.item.SpellActions;
import electroblob.wizardry.registry.WizardrySounds;
import electroblob.wizardry.spell.SpellRay;
import electroblob.wizardry.util.EntityUtils;
import electroblob.wizardry.util.MagicDamage;
import electroblob.wizardry.util.ParticleBuilder;
import electroblob.wizardry.util.RayTracer;
import electroblob.wizardry.util.SpellModifiers;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.tileentity.TileEntityDispenser;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ChaosBlast
extends SpellRay
implements IClassSpell {
    public static final String CHARGING_TIME = "charging_time";

    public ChaosBlast() {
        super("ancientspellcraft", "chaos_blast", SpellActions.POINT, true);
        this.ignoreUncollidables = false;
        this.soundValues(1.0f, 1.0f, 0.4f);
        this.addProperties(new String[]{"damage", CHARGING_TIME});
    }

    public boolean cast(World world, EntityLiving caster, EnumHand hand, int ticksInUse, EntityLivingBase target, SpellModifiers modifiers) {
        return this.doSpellTick(world, (EntityLivingBase)caster, hand, ticksInUse, target, modifiers);
    }

    protected boolean onEntityHit(World world, Entity target, Vec3d hit, @Nullable EntityLivingBase caster, Vec3d origin, int ticksInUse, SpellModifiers modifiers) {
        return false;
    }

    public boolean cast(World world, EntityPlayer caster, EnumHand hand, int ticksInUse, SpellModifiers modifiers) {
        return this.doSpellTick(world, (EntityLivingBase)caster, hand, ticksInUse, null, modifiers);
    }

    private boolean doSpellTick(World world, EntityLivingBase caster, EnumHand hand, int ticksInUse, @Nullable EntityLivingBase target, SpellModifiers modifiers) {
        int chargeup = this.getProperty(CHARGING_TIME).intValue();
        Element element = this.getElementOrMagicElement(caster);
        if (ticksInUse == 0) {
            world.func_184133_a(null, caster.func_180425_c(), ASSounds.spell_chaos_blast_charge, WizardrySounds.SPELLS, this.volume, this.pitch + this.pitchVariation * (world.field_73012_v.nextFloat() - 0.5f));
        }
        if (ticksInUse < chargeup) {
            if (world.field_72995_K && caster.field_70173_aa % 1 == 0) {
                for (int i = 0; i < 10; ++i) {
                    ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.FLASH).entity((Entity)caster).spin(Math.min(3.0, 1.0 / ((0.1 + (double)ticksInUse) * (double)0.05f)), (double)0.006f).scale(Math.min(1.0f, 2.0f / (Math.max(1.2f, (float)ticksInUse * 0.2f) * 0.7f))).clr(WarlockElementalSpellEffects.PARTICLE_COLOURS.get(element)[world.field_73012_v.nextInt(2)]).pos(0.0, (double)(world.field_73012_v.nextFloat() + 0.2f), 0.0).time(40).spawn(world);
                }
            }
        } else if (ticksInUse == chargeup + 1) {
            Vec3d look = caster.func_70040_Z();
            Vec3d origin = new Vec3d(caster.field_70165_t, caster.field_70163_u + (double)caster.func_70047_e() - 0.25, caster.field_70161_v);
            if (!this.isContinuous && world.field_72995_K && !Wizardry.proxy.isFirstPerson((Entity)caster)) {
                origin = origin.func_178787_e(look.func_186678_a(1.2));
            }
            if (!this.shootSpell(world, origin, look, caster, ticksInUse, modifiers, element)) {
                return false;
            }
            if (this.casterSwingsArm(world, caster, hand, ticksInUse, modifiers)) {
                caster.func_184609_a(hand);
            }
            this.playSound(world, caster, ticksInUse, -1, modifiers, new String[0]);
        }
        return true;
    }

    protected boolean shootSpell(World world, Vec3d origin, Vec3d direction, @Nullable EntityLivingBase caster, int ticksInUse, SpellModifiers modifiers, Element element) {
        boolean flag;
        double range = this.getRange(world, origin, direction, caster, ticksInUse, modifiers);
        Vec3d endpoint = origin.func_178787_e(direction.func_186678_a(range));
        List<RayTraceResult> rayTraces = this.rayTraceMultiple(world, origin, endpoint, 1.0f, this.hitLiquids, this.ignoreUncollidables, false, false, Entity.class, this.ignoreLivingEntities ? EntityUtils::isLiving : RayTracer.ignoreEntityFilter((Entity)caster));
        Collections.reverse(rayTraces);
        if (!rayTraces.isEmpty()) {
            int i = 1;
            for (RayTraceResult rayTrace : rayTraces) {
                if (rayTrace.field_72313_a == RayTraceResult.Type.ENTITY) {
                    if (i != 1 && (!(caster instanceof EntityPlayer) || !ItemArtefact.isArtefactActive((EntityPlayer)((EntityPlayer)caster), (Item)ASItems.ring_chaos_blast_multitarget))) continue;
                    if (i == 2) {
                        modifiers.set("potency", modifiers.get("potency") * 0.6f, false);
                    }
                    if (flag = this.onEntityHit(world, rayTrace.field_72308_g, rayTrace.field_72307_f, caster, origin, ticksInUse, modifiers, element)) {
                        range = origin.func_72438_d(rayTrace.field_72307_f);
                    }
                    ++i;
                    continue;
                }
                if (rayTrace.field_72313_a != RayTraceResult.Type.BLOCK) continue;
                flag = this.onBlockHit(world, rayTrace.func_178782_a(), rayTrace.field_178784_b, rayTrace.field_72307_f, caster, origin, ticksInUse, modifiers, element);
                range = origin.func_72438_d(rayTrace.field_72307_f);
            }
        }
        RayTraceResult rayTrace = RayTracer.rayTrace((World)world, (Vec3d)origin, (Vec3d)endpoint, (float)this.aimAssist, (boolean)this.hitLiquids, (boolean)this.ignoreUncollidables, (boolean)false, Entity.class, (Predicate)(this.ignoreLivingEntities ? EntityUtils::isLiving : RayTracer.ignoreEntityFilter((Entity)caster)));
        flag = false;
        if (rayTrace != null && rayTrace.field_72313_a == RayTraceResult.Type.BLOCK) {
            flag = this.onBlockHit(world, rayTrace.func_178782_a(), rayTrace.field_178784_b, rayTrace.field_72307_f, caster, origin, ticksInUse, modifiers, element);
            range = origin.func_72438_d(rayTrace.field_72307_f);
        }
        if (!flag && !this.onMiss(world, caster, origin, direction, ticksInUse, modifiers)) {
            return false;
        }
        if (world.field_72995_K) {
            this.spawnParticleRay(world, origin, direction, caster, range, element);
        }
        return true;
    }

    protected boolean onEntityHit(World world, Entity target, Vec3d hit, EntityLivingBase caster, Vec3d origin, int ticksInUse, SpellModifiers modifiers, Element element) {
        if (target instanceof EntityLivingBase) {
            EntityUtils.attackEntityWithoutKnockback((Entity)target, (DamageSource)(caster == null ? DamageSource.field_76376_m : MagicDamage.causeDirectMagicDamage((Entity)caster, (MagicDamage.DamageType)MagicDamage.DamageType.MAGIC)), (float)(this.getProperty("damage").floatValue() * modifiers.get("potency")));
            WarlockElementalSpellEffects.affectEntity((EntityLivingBase)target, element, caster, modifiers, true);
        }
        return true;
    }

    protected boolean onBlockHit(World world, BlockPos pos, EnumFacing side, Vec3d hit, @Nullable EntityLivingBase caster, Vec3d origin, int ticksInUse, SpellModifiers modifiers) {
        return false;
    }

    protected boolean onBlockHit(World world, BlockPos pos, EnumFacing side, Vec3d hit, EntityLivingBase caster, Vec3d origin, int ticksInUse, SpellModifiers modifiers, Element element) {
        if (world.field_72995_K) {
            for (int i = 0; i < 8; ++i) {
                world.func_175688_a(EnumParticleTypes.LAVA, hit.field_72450_a, hit.field_72448_b, hit.field_72449_c, 0.0, 0.0, 0.0, new int[0]);
            }
            if (world.func_180495_p(pos).func_185904_a().func_76220_a()) {
                Vec3d vec = hit.func_178787_e(new Vec3d(side.func_176730_m()).func_186678_a(0.005));
                ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.SCORCH).scale(3.0f).pos(vec).face(side).clr(WarlockElementalSpellEffects.PARTICLE_COLOURS.get(element)[0]).spawn(world);
            }
        }
        return true;
    }

    protected boolean onMiss(World world, EntityLivingBase caster, Vec3d origin, Vec3d direction, int ticksInUse, SpellModifiers modifiers) {
        return true;
    }

    @Override
    public ItemWizardArmour.ArmourClass getArmourClass() {
        return ItemWizardArmour.ArmourClass.WARLOCK;
    }

    public boolean applicableForItem(Item item) {
        return item == ASItems.forbidden_tome;
    }

    protected void spawnParticleRay(World world, Vec3d origin, Vec3d direction, @Nullable EntityLivingBase caster, double distance, Element element) {
        if (!world.field_72995_K) {
            return;
        }
        Vec3d velocity = direction.func_186678_a(this.particleVelocity);
        Vec3d endpoint = origin.func_178787_e(direction.func_186678_a(distance));
        ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.BEAM).scale(7.0f).clr(WarlockElementalSpellEffects.PARTICLE_COLOURS.get(element)[0]).fade(WarlockElementalSpellEffects.PARTICLE_COLOURS.get(element)[world.field_73012_v.nextInt(2)]).time(4).pos(origin).target(endpoint).spawn(world);
        for (double d = this.particleSpacing / 2.0; d <= distance; d += this.particleSpacing / 2.0) {
            double x = origin.field_72450_a + d * direction.field_72450_a + this.particleJitter * (world.field_73012_v.nextDouble() * 2.0 - 1.0);
            double y = origin.field_72448_b + d * direction.field_72448_b + this.particleJitter * (world.field_73012_v.nextDouble() * 2.0 - 1.0);
            double z = origin.field_72449_c + d * direction.field_72449_c + this.particleJitter * (world.field_73012_v.nextDouble() * 2.0 - 1.0);
            this.spawnParticle(world, x, y, z, velocity.field_72450_a, velocity.field_72448_b, velocity.field_72449_c, element);
        }
    }

    protected void spawnParticle(World world, double x, double y, double z, double vx, double vy, double vz, Element element) {
        if (!world.field_72995_K) {
            return;
        }
        ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.FLASH).scale(7.0f).clr(WarlockElementalSpellEffects.PARTICLE_COLOURS.get(element)[1]).time(20).pos(x, y, z).vel(vx, vy, vz).collide(true).spawn(world);
        ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.FLASH).clr(WarlockElementalSpellEffects.PARTICLE_COLOURS.get(element)[1]).time(20).pos(x, y, z).vel(vx, vy, vz).collide(true).spawn(world);
        ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.FLASH).clr(WarlockElementalSpellEffects.PARTICLE_COLOURS.get(element)[0]).time(10).pos(x, y, z).vel(vx, vy, vz).collide(true).spawn(world);
    }

    public List<RayTraceResult> rayTraceMultiple(World world, Vec3d origin, Vec3d endpoint, float aimAssist, boolean hitLiquids, boolean ignoreUncollidables, boolean returnLastUncollidable, boolean penetratesBlocks, Class<? extends Entity> entityType, Predicate<? super Entity> filter) {
        float borderSize = 1.0f + aimAssist;
        AxisAlignedBB searchVolume = new AxisAlignedBB(origin.field_72450_a, origin.field_72448_b, origin.field_72449_c, endpoint.field_72450_a, endpoint.field_72448_b, endpoint.field_72449_c).func_72314_b((double)borderSize, (double)borderSize, (double)borderSize);
        List entities = world.func_72872_a(entityType, searchVolume);
        entities.removeIf(filter);
        entities.removeIf(e -> !(e instanceof EntityLivingBase));
        ArrayList<RayTraceResult> result = new ArrayList<RayTraceResult>();
        RayTraceResult rayTraceResult = world.func_147447_a(origin, endpoint, hitLiquids, ignoreUncollidables, returnLastUncollidable);
        if (rayTraceResult != null && !penetratesBlocks) {
            endpoint = rayTraceResult.field_72307_f;
        }
        Vec3d intercept = null;
        for (Entity entity : entities) {
            float closestHitDistance;
            float currentHitDistance;
            float fuzziness;
            float f = fuzziness = EntityUtils.isLiving((Entity)entity) ? aimAssist : 0.0f;
            if (entity instanceof ICustomHitbox) {
                intercept = ((ICustomHitbox)entity).calculateIntercept(origin, endpoint, fuzziness);
            } else {
                RayTraceResult hit;
                AxisAlignedBB entityBounds = entity.func_174813_aQ();
                currentHitDistance = entity.func_70111_Y();
                if (currentHitDistance != 0.0f) {
                    entityBounds = entityBounds.func_72314_b((double)currentHitDistance, (double)currentHitDistance, (double)currentHitDistance);
                }
                if (fuzziness != 0.0f) {
                    entityBounds = entityBounds.func_72314_b((double)fuzziness, (double)fuzziness, (double)fuzziness);
                }
                if ((hit = entityBounds.func_72327_a(origin, endpoint)) != null) {
                    intercept = hit.field_72307_f;
                }
            }
            if (intercept == null || !((currentHitDistance = (float)intercept.func_72438_d(origin)) < (closestHitDistance = (float)endpoint.func_72438_d(origin)))) continue;
            RayTraceResult entityResult = new RayTraceResult(entity, intercept);
            result.add(entityResult);
        }
        return result;
    }

    @SideOnly(value=Side.CLIENT)
    public String getDescription() {
        if (Minecraft.func_71410_x().field_71439_g != null) {
            EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
            return Wizardry.proxy.translate(this.getDescriptionTranslationKey(), new Object[]{Float.valueOf(this.getProperty(CHARGING_TIME).floatValue() / 20.0f)});
        }
        return super.getDescription();
    }

    public boolean canBeCastBy(TileEntityDispenser dispenser) {
        return false;
    }

    public boolean canBeCastBy(EntityLiving npc, boolean override) {
        return this.canBeCastByClassNPC((EntityLivingBase)npc);
    }
}

