/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.ancientspellcraft.spell;

import com.windanesz.ancientspellcraft.entity.EntityChaosOrb;
import com.windanesz.ancientspellcraft.registry.ASItems;
import com.windanesz.ancientspellcraft.spell.IClassSpell;
import electroblob.wizardry.constants.Constants;
import electroblob.wizardry.entity.projectile.EntityMagicProjectile;
import electroblob.wizardry.item.ItemWizardArmour;
import electroblob.wizardry.spell.SpellProjectile;
import electroblob.wizardry.util.SpellModifiers;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.tileentity.TileEntityDispenser;
import net.minecraft.world.World;

public class ChaosOrb<T extends EntityMagicProjectile>
extends SpellProjectile<T>
implements IClassSpell {
    public static final String MAX_SPLIT_GENERATIONS = "max_split_generations";

    public ChaosOrb(String modID, String name, Function<World, T> projectileFactory) {
        super(modID, name, projectileFactory);
        this.soundValues(0.8f, 0.9f, 0.2f);
        this.addProperties(new String[]{"damage", MAX_SPLIT_GENERATIONS});
    }

    protected void addProjectileExtras(T projectile, @Nullable EntityLivingBase caster, SpellModifiers modifiers) {
        super.addProjectileExtras(projectile, caster, modifiers);
        int gen = Math.min(this.getProperty(MAX_SPLIT_GENERATIONS).intValue(), (int)((modifiers.get("potency") - 1.0f) / Constants.POTENCY_INCREASE_PER_TIER + 0.01f) - 1);
        ((EntityChaosOrb)((Object)projectile)).setGeneration(gen);
        ((EntityChaosOrb)((Object)projectile)).setElement(this.getElementOrMagicElement(caster));
    }

    @Override
    public ItemWizardArmour.ArmourClass getArmourClass() {
        return ItemWizardArmour.ArmourClass.WARLOCK;
    }

    public boolean applicableForItem(Item item) {
        return item == ASItems.forbidden_tome;
    }

    public boolean canBeCastBy(TileEntityDispenser dispenser) {
        return false;
    }

    public boolean canBeCastBy(EntityLiving npc, boolean override) {
        return this.canBeCastByClassNPC((EntityLivingBase)npc);
    }
}

