/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.ancientspellcraft.spell;

import com.windanesz.ancientspellcraft.registry.ASItems;
import com.windanesz.ancientspellcraft.spell.IClassSpell;
import com.windanesz.ancientspellcraft.spell.WarlockElementalSpellEffects;
import electroblob.wizardry.constants.Element;
import electroblob.wizardry.item.ItemWizardArmour;
import electroblob.wizardry.item.SpellActions;
import electroblob.wizardry.registry.WizardryItems;
import electroblob.wizardry.registry.WizardrySounds;
import electroblob.wizardry.spell.Spell;
import electroblob.wizardry.util.AllyDesignationSystem;
import electroblob.wizardry.util.EntityUtils;
import electroblob.wizardry.util.ParticleBuilder;
import electroblob.wizardry.util.SpellModifiers;
import java.util.Comparator;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.tileentity.TileEntityDispenser;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class ChaosVortex
extends Spell
implements IClassSpell {
    public ChaosVortex() {
        super("ancientspellcraft", "chaos_vortex", SpellActions.POINT, true);
        this.soundValues(1.0f, 1.0f, 0.4f);
        this.addProperties(new String[]{"damage", "effect_radius"});
    }

    public boolean cast(World world, EntityLiving caster, EnumHand hand, int ticksInUse, EntityLivingBase target, SpellModifiers modifiers) {
        return this.doSpellTick(world, (EntityLivingBase)caster, hand, ticksInUse, modifiers);
    }

    public boolean cast(World world, EntityPlayer caster, EnumHand hand, int ticksInUse, SpellModifiers modifiers) {
        return this.doSpellTick(world, (EntityLivingBase)caster, hand, ticksInUse, modifiers);
    }

    private boolean doSpellTick(World world, EntityLivingBase caster, EnumHand hand, int ticksInUse, SpellModifiers modifiers) {
        Element element = this.getElementOrMagicElement(caster);
        float radius = Math.min(5.0f, (float)ticksInUse * 0.2f) * 2.0f * modifiers.get(WizardryItems.blast_upgrade);
        if (ticksInUse % 40 == 0) {
            world.func_184148_a(null, caster.field_70165_t, caster.field_70163_u, caster.field_70161_v, new SoundEvent(new ResourceLocation("ebwizardry:spell.lightning_ray.loop")), WizardrySounds.SPELLS, this.volume, this.pitch);
        }
        if (world.field_72995_K) {
            for (int i = 0; i < 10; ++i) {
                ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.FLASH).entity((Entity)caster).spin((double)(radius * world.field_73012_v.nextFloat() + 1.0f), (double)0.006f).scale(2.0f).clr(WarlockElementalSpellEffects.PARTICLE_COLOURS.get(element)[world.field_73012_v.nextInt(2)]).pos(0.0, (double)((float)world.field_73012_v.nextInt(10) + 0.5f), 0.0).time(40).spawn(world);
                ParticleBuilder.create((ResourceLocation)WarlockElementalSpellEffects.getElementalParticle(element)).entity((Entity)caster).spin((double)(radius * world.field_73012_v.nextFloat() + 1.0f), (double)0.026f).scale(world.field_73012_v.nextFloat() * 2.0f).clr(WarlockElementalSpellEffects.PARTICLE_COLOURS.get(element)[element == Element.LIGHTNING ? 3 : world.field_73012_v.nextInt(2)]).pos(0.0, (double)((float)world.field_73012_v.nextInt(10) + 0.5f), 0.0).time(40).spawn(world);
            }
        }
        if (caster.field_70173_aa % 10 == 0) {
            radius = this.getProperty("effect_radius").floatValue() * modifiers.get(WizardryItems.blast_upgrade);
            List targets = EntityUtils.getLivingWithinRadius((double)(radius * 0.5f), (double)caster.field_70165_t, (double)caster.field_70163_u, (double)caster.field_70161_v, (World)world);
            targets.removeIf(target -> !AllyDesignationSystem.isValidTarget((Entity)caster, (Entity)target));
            Vec3d origin = new Vec3d(caster.field_70165_t, caster.field_70163_u, caster.field_70161_v);
            targets.sort(Comparator.comparingDouble(e -> e.func_70092_e(origin.field_72450_a, origin.field_72448_b, origin.field_72449_c)));
            for (EntityLivingBase target2 : targets) {
                this.affectEntity(caster, target2, modifiers, element);
            }
        }
        return true;
    }

    boolean affectEntity(@Nullable EntityLivingBase caster, EntityLivingBase target, SpellModifiers modifiers, Element element) {
        WarlockElementalSpellEffects.affectEntity(target, element, caster, modifiers, true);
        return true;
    }

    @Override
    public ItemWizardArmour.ArmourClass getArmourClass() {
        return ItemWizardArmour.ArmourClass.WARLOCK;
    }

    public boolean applicableForItem(Item item) {
        return item == ASItems.forbidden_tome;
    }

    public boolean canBeCastBy(TileEntityDispenser dispenser) {
        return false;
    }

    public boolean canBeCastBy(EntityLiving npc, boolean override) {
        return this.canBeCastByClassNPC((EntityLivingBase)npc);
    }
}

