/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.ancientspellcraft.spell;

import com.windanesz.ancientspellcraft.registry.ASItems;
import com.windanesz.ancientspellcraft.spell.IClassSpell;
import electroblob.wizardry.entity.living.ISummonedCreature;
import electroblob.wizardry.item.ItemWizardArmour;
import electroblob.wizardry.item.SpellActions;
import electroblob.wizardry.spell.SpellAreaEffect;
import electroblob.wizardry.util.SpellModifiers;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.MobEffects;
import net.minecraft.item.Item;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class ChaoticEmpowerment
extends SpellAreaEffect
implements IClassSpell {
    public static final String EXPLOSION_STRENGTH = "explosion_strength";
    public static final String BREAK_BLOCKS = "break_blocks";
    public static final String EXPLOSION_CHANCE = "explosion_chance";

    public ChaoticEmpowerment() {
        super("ancientspellcraft", "chaotic_empowerment", SpellActions.POINT_UP, false);
        this.soundValues(0.7f, 1.2f, 0.4f);
        this.targetAllies(true);
        this.addProperties(new String[]{EXPLOSION_STRENGTH, BREAK_BLOCKS, EXPLOSION_CHANCE, "effect_duration"});
    }

    protected boolean affectEntity(World world, Vec3d origin, @Nullable EntityLivingBase caster, EntityLivingBase target, int targetCount, int ticksInUse, SpellModifiers modifiers) {
        if (target instanceof ISummonedCreature && ((ISummonedCreature)target).getCaster() == caster) {
            if (world.field_73012_v.nextFloat() < this.getProperty(EXPLOSION_CHANCE).floatValue()) {
                if (!world.field_72995_K) {
                    target.func_70106_y();
                }
                world.func_72876_a((Entity)target, target.field_70165_t, target.field_70163_u, target.field_70161_v, this.getProperty(EXPLOSION_STRENGTH).floatValue(), this.causeBlockDamage());
            } else if (!world.field_72995_K) {
                target.func_70690_d(new PotionEffect(MobEffects.field_76420_g, this.getProperty("effect_duration").intValue(), 0));
                target.func_70690_d(new PotionEffect(MobEffects.field_76424_c, this.getProperty("effect_duration").intValue(), 1));
            }
        }
        return false;
    }

    protected void spawnParticleEffect(World world, Vec3d origin, double radius, @Nullable EntityLivingBase caster, SpellModifiers modifiers) {
    }

    @Override
    public ItemWizardArmour.ArmourClass getArmourClass() {
        return ItemWizardArmour.ArmourClass.WARLOCK;
    }

    public boolean causeBlockDamage() {
        return this.getProperty(BREAK_BLOCKS).intValue() == 1;
    }

    public boolean applicableForItem(Item item) {
        return item == ASItems.forbidden_tome;
    }

    public boolean canBeCastBy(EntityLiving npc, boolean override) {
        return this.canBeCastByClassNPC((EntityLivingBase)npc);
    }
}

