/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.ancientspellcraft.spell;

import com.windanesz.ancientspellcraft.integration.baubles.ASBaublesIntegration;
import com.windanesz.ancientspellcraft.item.ItemMonsterCharm;
import com.windanesz.ancientspellcraft.registry.ASItems;
import com.windanesz.ancientspellcraft.spell.IOverrideSpell;
import electroblob.wizardry.data.IStoredVariable;
import electroblob.wizardry.data.Persistence;
import electroblob.wizardry.data.WizardData;
import electroblob.wizardry.item.ISpellCastingItem;
import electroblob.wizardry.item.ItemArtefact;
import electroblob.wizardry.item.SpellActions;
import electroblob.wizardry.misc.WizardryPathFinder;
import electroblob.wizardry.packet.PacketClairvoyance;
import electroblob.wizardry.packet.WizardryPacketHandler;
import electroblob.wizardry.registry.Spells;
import electroblob.wizardry.registry.WizardryItems;
import electroblob.wizardry.spell.Spell;
import electroblob.wizardry.util.ParticleBuilder;
import electroblob.wizardry.util.SpellModifiers;
import java.util.Comparator;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.pathfinding.Path;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.pathfinding.PathPoint;
import net.minecraft.tileentity.TileEntityDispenser;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

@Mod.EventBusSubscriber
public class ClairvoyanceAS
extends Spell
implements IOverrideSpell {
    public static final int PARTICLE_MOVEMENT_INTERVAL = 45;
    public static final IStoredVariable<BlockPos> LOCATION_KEY = IStoredVariable.StoredVariable.ofBlockPos((String)"clairvoyancePos", (Persistence)Persistence.ALWAYS);
    public static final IStoredVariable<Integer> DIMENSION_KEY = IStoredVariable.StoredVariable.ofInt((String)"clairvoyanceDimension", (Persistence)Persistence.ALWAYS);

    public ClairvoyanceAS() {
        super("ebwizardry", "clairvoyance", SpellActions.POINT_UP, false);
        this.addProperties(new String[]{"range", "duration"});
        WizardData.registerStoredVariables((IStoredVariable[])new IStoredVariable[]{LOCATION_KEY, DIMENSION_KEY});
        this.handleNetworkIDChange(this, 119);
    }

    public boolean canBeCastBy(EntityLiving npc, boolean override) {
        return false;
    }

    public boolean canBeCastBy(TileEntityDispenser dispenser) {
        return false;
    }

    public boolean cast(World world, EntityPlayer caster, EnumHand hand, int ticksInUse, SpellModifiers modifiers) {
        WizardData data;
        String mobId;
        List<ItemStack> charm;
        if (ItemArtefact.isArtefactActive((EntityPlayer)caster, (Item)ASItems.charm_monster_charm) && !(charm = ASBaublesIntegration.getEquippedArtefactStacks(caster, ItemArtefact.Type.CHARM)).isEmpty() && charm.get(0).func_77973_b() == ASItems.charm_monster_charm && (mobId = ItemMonsterCharm.getAttunedMob(charm.get(0))) != null) {
            ResourceLocation mobRes = new ResourceLocation(mobId);
            double radius = (double)this.getProperty("range").floatValue() * 0.25 * (double)modifiers.get(WizardryItems.range_upgrade);
            EntityLivingBase closest = world.func_72872_a(EntityLivingBase.class, caster.func_174813_aQ().func_186662_g(radius)).stream().filter(e -> EntityList.func_191306_a(e.getClass()) != null && EntityList.func_191306_a(e.getClass()).equals((Object)mobRes)).min(Comparator.comparingDouble(e -> e.func_70032_d((Entity)caster))).orElse(null);
            if (closest != null) {
                BlockPos targetPos = closest.func_180425_c();
                WizardData data2 = WizardData.get((EntityPlayer)caster);
                if (data2 != null) {
                    data2.setVariable(LOCATION_KEY, (Object)targetPos);
                    data2.setVariable(DIMENSION_KEY, (Object)caster.field_71093_bK);
                    if (!world.field_72995_K) {
                        caster.func_146105_b((ITextComponent)new TextComponentTranslation("item.ancientspellcraft:monster_charm.found", new Object[]{closest.func_145748_c_()}), true);
                    }
                }
            } else {
                if (!world.field_72995_K) {
                    caster.func_146105_b((ITextComponent)new TextComponentTranslation("item.ancientspellcraft:monster_charm.not_found", new Object[0]), true);
                }
                return false;
            }
        }
        if ((data = WizardData.get((EntityPlayer)caster)) != null && !caster.func_70093_af()) {
            Integer dimension = (Integer)data.getVariable(DIMENSION_KEY);
            BlockPos location = (BlockPos)data.getVariable(LOCATION_KEY);
            if (dimension != null && caster.field_71093_bK == dimension) {
                if (location != null) {
                    if (!world.field_72995_K) {
                        caster.func_146105_b((ITextComponent)new TextComponentTranslation("spell." + this.getUnlocalisedName() + ".searching", new Object[0]), true);
                    }
                    EntityZombie arbitraryZombie = new EntityZombie(world){

                        public float func_180484_a(BlockPos pos) {
                            return 0.0f;
                        }
                    };
                    arbitraryZombie.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(this.getProperty("range").doubleValue() * (double)modifiers.get(WizardryItems.range_upgrade));
                    arbitraryZombie.func_70107_b(caster.field_70165_t, caster.field_70163_u, caster.field_70161_v);
                    arbitraryZombie.func_184644_a(PathNodeType.WATER, 0.0f);
                    arbitraryZombie.field_70122_E = true;
                    WizardryPathFinder pathfinder = new WizardryPathFinder(arbitraryZombie.func_70661_as().func_189566_q());
                    Path path = pathfinder.findPath((IBlockAccess)world, (EntityLiving)arbitraryZombie, location, this.getProperty("range").floatValue() * modifiers.get(WizardryItems.range_upgrade));
                    if (path != null && path.func_75870_c() != null) {
                        int x = path.func_75870_c().field_75839_a;
                        int y = path.func_75870_c().field_75837_b;
                        int z = path.func_75870_c().field_75838_c;
                        if (x == location.func_177958_n() && y == location.func_177956_o() && z == location.func_177952_p()) {
                            this.playSound(world, (EntityLivingBase)caster, ticksInUse, -1, modifiers, new String[0]);
                            if (!world.field_72995_K && caster instanceof EntityPlayerMP) {
                                WizardryPacketHandler.net.sendTo((IMessage)new PacketClairvoyance.Message(path, modifiers.get(WizardryItems.duration_upgrade)), (EntityPlayerMP)caster);
                            }
                            return true;
                        }
                    }
                    if (!world.field_72995_K) {
                        caster.func_146105_b((ITextComponent)new TextComponentTranslation("spell." + this.getUnlocalisedName() + ".outofrange", new Object[0]), true);
                    }
                } else if (!world.field_72995_K) {
                    caster.func_146105_b((ITextComponent)new TextComponentTranslation("spell." + this.getUnlocalisedName() + ".undefined", new Object[0]), true);
                }
            } else if (!world.field_72995_K) {
                caster.func_146105_b((ITextComponent)new TextComponentTranslation("spell." + this.getUnlocalisedName() + ".wrongdimension", new Object[0]), true);
            }
        }
        if (world.field_72995_K) {
            this.playSound(world, (EntityLivingBase)caster, ticksInUse, -1, modifiers, new String[0]);
        }
        return false;
    }

    public static void spawnPathPaticles(World world, Path path, float durationMultiplier) {
        PathPoint point;
        float duration = Spells.clairvoyance.getProperty("duration").floatValue();
        while (!path.func_75879_b() && (point = path.func_75877_a(path.func_75873_e())) != path.func_75870_c()) {
            PathPoint nextPoint = path.func_75874_d() - path.func_75873_e() <= 2 ? path.func_75870_c() : path.func_75877_a(path.func_75873_e() + 2);
            ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.PATH).pos((double)point.field_75839_a + 0.5, (double)point.field_75837_b + 0.5, (double)point.field_75838_c + 0.5).vel((double)((float)(nextPoint.field_75839_a - point.field_75839_a) / 45.0f), (double)((float)(nextPoint.field_75837_b - point.field_75837_b) / 45.0f), (double)((float)(nextPoint.field_75838_c - point.field_75838_c) / 45.0f)).time((int)(duration * durationMultiplier)).clr(0.0f, 1.0f, 0.3f).spawn(world);
            path.func_75875_a();
            path.func_75875_a();
        }
        point = path.func_75870_c();
        ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.PATH).pos((double)point.field_75839_a + 0.5, (double)point.field_75837_b + 0.5, (double)point.field_75838_c + 0.5).time((int)(duration * durationMultiplier)).clr(1.0f, 1.0f, 1.0f).spawn(world);
    }

    @SubscribeEvent
    public static void onRightClickBlockEvent(PlayerInteractEvent.RightClickBlock event) {
        WizardData data;
        ItemStack stack;
        if (event.getEntityPlayer().func_70093_af() && (stack = event.getItemStack()).func_77973_b() instanceof ISpellCastingItem && ((ISpellCastingItem)stack.func_77973_b()).getCurrentSpell(stack) instanceof ClairvoyanceAS && (data = WizardData.get((EntityPlayer)event.getEntityPlayer())) != null) {
            BlockPos pos = event.getPos().func_177972_a(event.getFace());
            data.setVariable(LOCATION_KEY, (Object)pos);
            data.setVariable(DIMENSION_KEY, (Object)event.getWorld().field_73011_w.getDimension());
            if (!event.getWorld().field_72995_K) {
                event.getEntityPlayer().func_146105_b((ITextComponent)new TextComponentTranslation("spell." + Spells.clairvoyance.getUnlocalisedName() + ".confirm", new Object[]{Spells.clairvoyance.getNameForTranslationFormatted()}), true);
            }
            event.setCanceled(true);
        }
    }
}

