/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.ancientspellcraft.spell;

import com.windanesz.ancientspellcraft.item.ItemWhisperingVeil;
import com.windanesz.ancientspellcraft.registry.ASItems;
import com.windanesz.ancientspellcraft.spell.SpellRayAS;
import electroblob.wizardry.data.IStoredVariable;
import electroblob.wizardry.data.Persistence;
import electroblob.wizardry.data.WizardData;
import electroblob.wizardry.entity.living.EntityWizard;
import electroblob.wizardry.item.ItemArtefact;
import electroblob.wizardry.item.SpellActions;
import electroblob.wizardry.registry.WizardryItems;
import electroblob.wizardry.registry.WizardryPotions;
import electroblob.wizardry.util.EntityUtils;
import electroblob.wizardry.util.ParticleBuilder;
import electroblob.wizardry.util.SpellModifiers;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.village.MerchantRecipe;
import net.minecraft.village.MerchantRecipeList;
import net.minecraft.world.World;

public class Compulsion
extends SpellRayAS {
    public static final IStoredVariable<UUID> CONTROLLED_ENTITY = IStoredVariable.StoredVariable.ofUUID((String)"controlled_entity", (Persistence)Persistence.ALWAYS);

    public Compulsion() {
        super("compulsion", SpellActions.POINT, false);
        WizardData.registerStoredVariables((IStoredVariable[])new IStoredVariable[]{CONTROLLED_ENTITY});
    }

    protected boolean onEntityHit(World world, Entity target, Vec3d hit, EntityLivingBase caster, Vec3d origin, int ticksInUse, SpellModifiers modifiers) {
        if (!(caster instanceof EntityPlayer)) {
            return false;
        }
        EntityPlayer player = (EntityPlayer)caster;
        WizardData data = WizardData.get((EntityPlayer)player);
        if (data == null) {
            return false;
        }
        UUID controlledEntityUUID = (UUID)data.getVariable(CONTROLLED_ENTITY);
        boolean hasBlackTongueAmulet = ItemArtefact.isArtefactActive((EntityPlayer)player, (Item)ASItems.amulet_black_tongue);
        boolean hasWhisperingVeil = ItemArtefact.isArtefactActive((EntityPlayer)player, (Item)ASItems.head_whispering_veil);
        boolean isSneaking = player.func_70093_af();
        if (isSneaking) {
            if (target instanceof EntityLiving) {
                EntityLiving livingEntity = (EntityLiving)target;
                data.setVariable(CONTROLLED_ENTITY, (Object)target.func_110124_au());
                livingEntity.func_70604_c(null);
                livingEntity.func_70624_b(null);
                ((EntityLivingBase)target).func_70690_d(new PotionEffect(WizardryPotions.mind_trick, 200, 0));
                if (hasWhisperingVeil) {
                    player.func_146105_b((ITextComponent)new TextComponentTranslation("spell.ancientspellcraft:compulsion.target_selected_whispering_veil", new Object[]{target.func_70005_c_()}), true);
                } else {
                    player.func_146105_b((ITextComponent)new TextComponentTranslation("spell.ancientspellcraft:compulsion.target_selected", new Object[]{target.func_70005_c_()}), true);
                }
                return true;
            }
            return false;
        }
        if (controlledEntityUUID == null) {
            player.func_146105_b((ITextComponent)new TextComponentTranslation("spell.ancientspellcraft:compulsion.no_controlled_entity", new Object[0]), true);
            return false;
        }
        if (hasWhisperingVeil && target instanceof EntityVillager) {
            EntityVillager villager = (EntityVillager)target;
            if (ItemWhisperingVeil.hasUsedVillagerToday(player, villager.func_110124_au())) {
                player.func_146105_b((ITextComponent)new TextComponentTranslation("spell.ancientspellcraft:compulsion.villager_already_used_today", new Object[0]), true);
                return false;
            }
            villager.func_70932_a_(player);
            MerchantRecipeList recipes = villager.func_70934_b(player);
            if (recipes != null && !recipes.isEmpty()) {
                MerchantRecipe randomRecipe = (MerchantRecipe)recipes.get(world.field_73012_v.nextInt(recipes.size()));
                ItemStack freeItem = randomRecipe.func_77397_d().func_77946_l();
                if (!freeItem.func_190926_b()) {
                    if (!player.func_191521_c(freeItem)) {
                        player.func_71019_a(freeItem, false);
                    }
                    ItemWhisperingVeil.markVillagerAsUsedToday(player, villager.func_110124_au());
                    player.func_146105_b((ITextComponent)new TextComponentTranslation("spell.ancientspellcraft:compulsion.villager_forced_trade", new Object[]{villager.func_70005_c_(), freeItem.func_82833_r()}), true);
                    return true;
                }
                player.func_146105_b((ITextComponent)new TextComponentTranslation("spell.ancientspellcraft:compulsion.villager_no_valid_trades", new Object[0]), true);
                return false;
            }
            player.func_146105_b((ITextComponent)new TextComponentTranslation("spell.ancientspellcraft:compulsion.villager_no_trades", new Object[0]), true);
            return false;
        }
        if (hasWhisperingVeil && target instanceof EntityWizard) {
            EntityWizard wizard = (EntityWizard)target;
            if (ItemWhisperingVeil.hasUsedWizardToday(player, wizard.func_110124_au())) {
                player.func_146105_b((ITextComponent)new TextComponentTranslation("spell.ancientspellcraft:compulsion.wizard_already_used_today", new Object[0]), true);
                return false;
            }
            wizard.func_70932_a_(player);
            MerchantRecipeList recipes = wizard.func_70934_b(player);
            if (recipes != null && !recipes.isEmpty()) {
                MerchantRecipe randomRecipe = (MerchantRecipe)recipes.get(world.field_73012_v.nextInt(recipes.size()));
                ItemStack freeItem = randomRecipe.func_77397_d().func_77946_l();
                if (!freeItem.func_190926_b()) {
                    if (!player.func_191521_c(freeItem)) {
                        player.func_71019_a(freeItem, false);
                    }
                    ItemWhisperingVeil.markWizardAsUsedToday(player, wizard.func_110124_au());
                    player.func_146105_b((ITextComponent)new TextComponentTranslation("spell.ancientspellcraft:compulsion.wizard_forced_trade", new Object[]{wizard.func_70005_c_(), freeItem.func_82833_r()}), true);
                    return true;
                }
                player.func_146105_b((ITextComponent)new TextComponentTranslation("spell.ancientspellcraft:compulsion.wizard_no_valid_trades", new Object[0]), true);
                return false;
            }
            player.func_146105_b((ITextComponent)new TextComponentTranslation("spell.ancientspellcraft:compulsion.wizard_no_trades", new Object[0]), true);
            return false;
        }
        Entity controlledEntity = EntityUtils.getEntityByUUID((World)world, (UUID)controlledEntityUUID);
        if (controlledEntity == null) {
            player.func_146105_b((ITextComponent)new TextComponentTranslation("spell.ancientspellcraft:compulsion.target_lost", new Object[0]), true);
            data.setVariable(CONTROLLED_ENTITY, null);
            return false;
        }
        if (controlledEntity.func_70032_d((Entity)player) > this.getProperty("range").floatValue() * modifiers.get(WizardryItems.range_upgrade)) {
            player.func_146105_b((ITextComponent)new TextComponentTranslation("spell.ancientspellcraft:compulsion.target_too_far", new Object[0]), true);
            return false;
        }
        if (hasBlackTongueAmulet && !world.field_72995_K) {
            if (controlledEntity instanceof EntityLivingBase && target instanceof EntityLivingBase) {
                if (controlledEntity instanceof EntityLiving) {
                    EntityLiving livingEntity = (EntityLiving)controlledEntity;
                    livingEntity.func_70604_c(null);
                    livingEntity.func_70624_b(null);
                    livingEntity.func_70624_b((EntityLivingBase)target);
                    livingEntity.func_70604_c((EntityLivingBase)target);
                    livingEntity.func_70671_ap().func_75651_a((Entity)((EntityLivingBase)target), 30.0f, 30.0f);
                    livingEntity.func_70661_as().func_75499_g();
                    double distance = livingEntity.func_70032_d((Entity)((EntityLivingBase)target));
                    if (distance > 2.0) {
                        livingEntity.func_70661_as().func_75497_a((Entity)((EntityLivingBase)target), 1.0);
                    } else {
                        livingEntity.func_70652_k((Entity)((EntityLivingBase)target));
                        livingEntity.func_184609_a(EnumHand.MAIN_HAND);
                    }
                    player.func_146105_b((ITextComponent)new TextComponentTranslation("spell.ancientspellcraft:compulsion.debug_targets", new Object[]{livingEntity.func_70638_az() != null ? livingEntity.func_70638_az().func_70005_c_() : "null", livingEntity.func_70643_av() != null ? livingEntity.func_70643_av().func_70005_c_() : "null"}), true);
                }
                player.func_146105_b((ITextComponent)new TextComponentTranslation("spell.ancientspellcraft:compulsion.target_attacking", new Object[]{controlledEntity.func_70005_c_(), target.func_70005_c_()}), true);
                return true;
            }
        } else if (controlledEntity instanceof EntityLiving) {
            EntityLiving livingEntity = (EntityLiving)controlledEntity;
            livingEntity.func_70604_c(null);
            livingEntity.func_70624_b(null);
            if (livingEntity instanceof EntityLiving) {
                livingEntity.func_70661_as().func_75499_g();
                livingEntity.func_70661_as().func_75492_a(target.field_70165_t, target.field_70163_u, target.field_70161_v, 1.0);
            }
            if (world.field_72995_K) {
                this.spawnDirectionalLine(world, (EntityLivingBase)livingEntity, new BlockPos(target.field_70165_t, target.field_70163_u, target.field_70161_v));
            }
            player.func_146105_b((ITextComponent)new TextComponentTranslation("spell.ancientspellcraft:compulsion.target_moved", new Object[]{controlledEntity.func_70005_c_()}), true);
            return true;
        }
        return false;
    }

    protected boolean onBlockHit(World world, BlockPos pos, EnumFacing side, Vec3d hit, EntityLivingBase caster, Vec3d origin, int ticksInUse, SpellModifiers modifiers) {
        if (!(caster instanceof EntityPlayer)) {
            return false;
        }
        EntityPlayer player = (EntityPlayer)caster;
        WizardData data = WizardData.get((EntityPlayer)player);
        if (data == null) {
            return false;
        }
        UUID controlledEntityUUID = (UUID)data.getVariable(CONTROLLED_ENTITY);
        boolean hasBlackTongueAmulet = ItemArtefact.isArtefactActive((EntityPlayer)player, (Item)ASItems.amulet_black_tongue);
        boolean hasWhisperingVeil = ItemArtefact.isArtefactActive((EntityPlayer)player, (Item)ASItems.head_whispering_veil);
        boolean isSneaking = player.func_70093_af();
        if (isSneaking) {
            if (!world.field_72995_K) {
                player.func_146105_b((ITextComponent)new TextComponentTranslation("spell.ancientspellcraft:compulsion.select_entity_to_control", new Object[0]), true);
            }
            return false;
        }
        if (controlledEntityUUID == null) {
            if (!world.field_72995_K) {
                player.func_146105_b((ITextComponent)new TextComponentTranslation("spell.ancientspellcraft:compulsion.no_controlled_entity", new Object[0]), true);
            }
            return false;
        }
        Entity controlledEntity = EntityUtils.getEntityByUUID((World)world, (UUID)controlledEntityUUID);
        if (controlledEntity == null) {
            player.func_146105_b((ITextComponent)new TextComponentTranslation("spell.ancientspellcraft:compulsion.target_lost", new Object[0]), true);
            data.setVariable(CONTROLLED_ENTITY, null);
            return false;
        }
        if (controlledEntity.func_70032_d((Entity)player) > this.getProperty("range").floatValue() * modifiers.get(WizardryItems.range_upgrade)) {
            player.func_146105_b((ITextComponent)new TextComponentTranslation("spell.ancientspellcraft:compulsion.target_too_far", new Object[0]), true);
            return false;
        }
        if (controlledEntity instanceof EntityLivingBase) {
            EntityLivingBase livingEntity = (EntityLivingBase)controlledEntity;
            if (livingEntity instanceof EntityLiving) {
                ((EntityLiving)livingEntity).func_70661_as().func_75499_g();
                ((EntityLiving)livingEntity).func_70661_as().func_75492_a((double)pos.func_177958_n() + 0.5, (double)(pos.func_177956_o() + 1), (double)pos.func_177952_p() + 0.5, 1.0);
            }
            if (world.field_72995_K) {
                this.spawnDirectionalLine(world, livingEntity, pos);
            }
            player.func_146105_b((ITextComponent)new TextComponentTranslation("spell.ancientspellcraft:compulsion.target_moved", new Object[]{controlledEntity.func_70005_c_()}), true);
            return true;
        }
        return false;
    }

    protected boolean onMiss(World world, EntityLivingBase caster, Vec3d origin, Vec3d direction, int ticksInUse, SpellModifiers modifiers) {
        if (!(caster instanceof EntityPlayer)) {
            return false;
        }
        EntityPlayer player = (EntityPlayer)caster;
        WizardData data = WizardData.get((EntityPlayer)player);
        if (data == null) {
            return false;
        }
        UUID controlledEntityUUID = (UUID)data.getVariable(CONTROLLED_ENTITY);
        boolean hasBlackTongueAmulet = ItemArtefact.isArtefactActive((EntityPlayer)player, (Item)ASItems.amulet_black_tongue);
        boolean hasWhisperingVeil = ItemArtefact.isArtefactActive((EntityPlayer)player, (Item)ASItems.head_whispering_veil);
        boolean isSneaking = player.func_70093_af();
        if (isSneaking) {
            if (!world.field_72995_K) {
                player.func_146105_b((ITextComponent)new TextComponentTranslation("spell.ancientspellcraft:compulsion.select_entity_to_control", new Object[0]), true);
            }
            return false;
        }
        if (controlledEntityUUID == null) {
            if (!world.field_72995_K) {
                player.func_146105_b((ITextComponent)new TextComponentTranslation("spell.ancientspellcraft:compulsion.no_controlled_entity", new Object[0]), true);
            }
        } else if (!world.field_72995_K) {
            if (hasBlackTongueAmulet) {
                player.func_146105_b((ITextComponent)new TextComponentTranslation("spell.ancientspellcraft:compulsion.select_target_entity", new Object[0]), true);
            } else {
                player.func_146105_b((ITextComponent)new TextComponentTranslation("spell.ancientspellcraft:compulsion.select_target_location", new Object[0]), true);
            }
        }
        return false;
    }

    protected void spawnParticle(World world, double x, double y, double z, double vx, double vy, double vz) {
        ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.MAGIC_FIRE).pos(x, y, z).vel(vx * 0.1, vy * 0.1, vz * 0.1).clr(0.8f, 0.2f, 0.8f).time(15 + world.field_73012_v.nextInt(10)).scale(1.2f + world.field_73012_v.nextFloat() * 0.6f).spawn(world);
        ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.SPARKLE).pos(x, y, z).vel(vx * 0.05, vy * 0.05, vz * 0.05).clr(0.9f, 0.3f, 0.9f).time(12 + world.field_73012_v.nextInt(8)).scale(0.8f).spawn(world);
        if (world.field_73012_v.nextInt(2) == 0) {
            ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.MAGIC_FIRE).pos(x, y + 0.1, z).vel(0.0, 0.02, 0.0).clr(0.7f, 0.1f, 0.7f).time(20 + world.field_73012_v.nextInt(15)).scale(0.6f + world.field_73012_v.nextFloat() * 0.4f).spawn(world);
        }
    }

    private void spawnDirectionalLine(World world, EntityLivingBase controlledEntity, BlockPos targetPos) {
        if (controlledEntity == null || targetPos == null) {
            return;
        }
        Vec3d start = controlledEntity.func_174791_d().func_72441_c(0.0, 0.1, 0.0);
        Vec3d end = new Vec3d((double)targetPos.func_177958_n() + 0.5, (double)targetPos.func_177956_o() + 0.1, (double)targetPos.func_177952_p() + 0.5);
        Vec3d direction = end.func_178788_d(start).func_72432_b();
        double distance = start.func_72438_d(end);
        int particleCount = (int)(distance * 4.0);
        for (int i = 0; i < particleCount; ++i) {
            double progress = (double)i / (double)particleCount;
            Vec3d pos = start.func_178787_e(direction.func_186678_a(distance * progress));
            ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.MAGIC_FIRE).pos(pos.field_72450_a, pos.field_72448_b, pos.field_72449_c).vel(0.0, 0.01, 0.0).clr(0.6f, 0.1f, 0.8f).time(30 + world.field_73012_v.nextInt(20)).scale(0.8f + world.field_73012_v.nextFloat() * 0.4f).spawn(world);
            if (world.field_73012_v.nextInt(3) != 0) continue;
            ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.SPARKLE).pos(pos.field_72450_a, pos.field_72448_b + 0.1, pos.field_72449_c).vel(0.0, 0.02, 0.0).clr(0.8f, 0.3f, 1.0f).time(20 + world.field_73012_v.nextInt(10)).scale(0.6f).spawn(world);
        }
    }
}

