/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.ancientspellcraft.spell;

import com.windanesz.ancientspellcraft.registry.ASItems;
import com.windanesz.ancientspellcraft.registry.ASSounds;
import com.windanesz.ancientspellcraft.registry.ASSpells;
import com.windanesz.ancientspellcraft.util.SpellcastUtils;
import electroblob.wizardry.constants.SpellType;
import electroblob.wizardry.data.IStoredVariable;
import electroblob.wizardry.data.Persistence;
import electroblob.wizardry.data.WizardData;
import electroblob.wizardry.event.SpellCastEvent;
import electroblob.wizardry.item.ItemArtefact;
import electroblob.wizardry.registry.WizardrySounds;
import electroblob.wizardry.spell.Spell;
import electroblob.wizardry.util.ParticleBuilder;
import electroblob.wizardry.util.SpellModifiers;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntityDispenser;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class Contingency
extends Spell {
    public static final String ACTIVE_LISTENER_TAG = "active_listener";
    public static final String CONTINGENCY_CASTER_TAG = "contingency_caster";
    public static final IStoredVariable<NBTTagCompound> ACTIVE_CONTINGENCIES = IStoredVariable.StoredVariable.ofNBT((String)"active_contingencies", (Persistence)Persistence.ALWAYS).setSynced();
    public static final IStoredVariable<NBTTagCompound> ACTIVE_CONTINGENCY_LISTENER = IStoredVariable.StoredVariable.ofNBT((String)"active_contingency_listener", (Persistence)Persistence.ALWAYS).setSynced();
    protected float particleCount = 10.0f;
    private float r;
    private float g;
    private float b;

    public Contingency(String name, EnumAction action, float r, float g, float b) {
        super("ancientspellcraft", name, action, false);
        WizardData.registerStoredVariables((IStoredVariable[])new IStoredVariable[]{ACTIVE_CONTINGENCIES, ACTIVE_CONTINGENCY_LISTENER});
        this.r = r;
        this.g = g;
        this.b = b;
    }

    public static boolean tryCastContingencySpell(EntityPlayer player, WizardData data, Type contingency) {
        if (data == null || player.func_184811_cZ().func_185141_a(ASItems.ring_eternal_contingency)) {
            return false;
        }
        data.setVariable(ACTIVE_CONTINGENCY_LISTENER, null);
        data.sync();
        NBTTagCompound activeContingencies = (NBTTagCompound)data.getVariable(ACTIVE_CONTINGENCIES);
        if (activeContingencies == null || !activeContingencies.func_74764_b(contingency.spellName)) {
            return false;
        }
        String spellNameToTrigger = activeContingencies.func_74779_i(contingency.spellName);
        Spell spellToTrigger = (Spell)Spell.registry.getValue(new ResourceLocation(spellNameToTrigger));
        if (spellToTrigger == null) {
            return false;
        }
        if (SpellcastUtils.tryCastSpellAsPlayer(player, spellToTrigger, EnumHand.MAIN_HAND, SpellCastEvent.Source.WAND, new SpellModifiers(), 120)) {
            if (player.func_184811_cZ().func_185141_a(ASItems.ring_eternal_contingency) || !ItemArtefact.isArtefactActive((EntityPlayer)player, (Item)ASItems.ring_eternal_contingency)) {
                activeContingencies.func_82580_o(contingency.spellName);
            } else {
                player.func_184811_cZ().func_185145_a(ASItems.ring_eternal_contingency, spellToTrigger.getCooldown() * 10 + (spellToTrigger.getTier().ordinal() + 1) * 500);
            }
            data.setVariable(ACTIVE_CONTINGENCIES, (Object)activeContingencies);
            data.sync();
            player.field_70170_p.func_184134_a(player.field_70165_t, player.field_70163_u, player.field_70161_v, ASSounds.CONTINGENCY_ACTIVATE, WizardrySounds.SPELLS, 1.0f, 1.0f, false);
            return true;
        }
        activeContingencies.func_82580_o(contingency.spellName);
        data.setVariable(ACTIVE_CONTINGENCIES, (Object)activeContingencies);
        data.sync();
        return false;
    }

    public static boolean tryCastContingencySpellAsMob(EntityLivingBase entityLivingBase, Type contingency) {
        if (entityLivingBase instanceof EntityPlayer) {
            return Contingency.tryCastContingencySpell((EntityPlayer)entityLivingBase, WizardData.get((EntityPlayer)((EntityPlayer)entityLivingBase)), contingency);
        }
        if (entityLivingBase instanceof EntityLiving) {
            NBTTagCompound compound;
            boolean test;
            EntityLiving entityLiving = (EntityLiving)entityLivingBase;
            NBTTagCompound entityData = entityLiving.getEntityData();
            if (!entityData.func_74764_b(ACTIVE_LISTENER_TAG) || !entityData.func_74775_l(ACTIVE_LISTENER_TAG).func_74764_b(contingency.spellName)) {
                return false;
            }
            Spell spellToTrigger = (Spell)Spell.registry.getValue(new ResourceLocation(entityData.func_74775_l(ACTIVE_LISTENER_TAG).func_74779_i(contingency.spellName)));
            if (spellToTrigger == null) {
                return false;
            }
            EntityLiving target = entityLiving;
            if (spellToTrigger.getType() != SpellType.BUFF && spellToTrigger.getType() != SpellType.DEFENCE && spellToTrigger.getType() != SpellType.CONSTRUCT) {
                Object object = target = entityLiving.func_70643_av() != null ? entityLiving.func_70643_av() : target;
            }
            if ((test = SpellcastUtils.tryCastSpellAsMob(entityLiving, spellToTrigger, (EntityLivingBase)target)) && (compound = entityLiving.getEntityData().func_74775_l(ACTIVE_LISTENER_TAG)).func_74764_b(contingency.spellName)) {
                compound.func_82580_o(contingency.spellName);
                entityLiving.getEntityData().func_82580_o(ACTIVE_LISTENER_TAG);
                entityLiving.getEntityData().func_74782_a(ACTIVE_LISTENER_TAG, (NBTBase)compound);
            }
            return true;
        }
        return false;
    }

    public static void setContingencyTag(EntityLivingBase entity, EntityLivingBase caster, Type contingency, Spell spellToStore) {
        NBTTagCompound compound = new NBTTagCompound();
        if (entity.getEntityData().func_74764_b(ACTIVE_LISTENER_TAG)) {
            compound = entity.getEntityData().func_74775_l(ACTIVE_LISTENER_TAG);
        }
        compound.func_74778_a(contingency.spellName, spellToStore.getRegistryName().toString());
        compound.func_74768_a(CONTINGENCY_CASTER_TAG, caster.func_145782_y());
        entity.getEntityData().func_74782_a(ACTIVE_LISTENER_TAG, (NBTBase)compound);
    }

    public static boolean isFireDamageSource(DamageSource source) {
        return source == DamageSource.field_76372_a || source == DamageSource.field_76370_b || source == DamageSource.field_76371_c || source == DamageSource.field_190095_e;
    }

    public static void spawnParticles(World world, EntityLivingBase caster, Type type) {
        Spell spell = (Spell)Spell.registry.getValue(new ResourceLocation(type.spellName));
        if (!(spell instanceof Contingency)) {
            return;
        }
        Contingency contingency = (Contingency)spell;
        int i = 0;
        while ((float)i < contingency.particleCount) {
            double x = caster.field_70165_t + world.field_73012_v.nextDouble() * 2.0 - 1.0;
            double y = caster.field_70163_u + (double)caster.func_70047_e() - 0.5 + world.field_73012_v.nextDouble();
            double z = caster.field_70161_v + world.field_73012_v.nextDouble() * 2.0 - 1.0;
            ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.SPARKLE).pos(x, y, z).vel(0.0, 0.1, 0.0).clr(contingency.r, contingency.g, contingency.b).spawn(world);
            ++i;
        }
        ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.BUFF).entity((Entity)caster).clr(contingency.r, contingency.g, contingency.b).spawn(world);
    }

    public static void playSound(World world, BlockPos pos) {
        world.func_184134_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), ASSounds.CONTINGENCY, SoundCategory.BLOCKS, 1.0f, 1.0f, false);
    }

    public boolean cast(World world, EntityPlayer caster, EnumHand hand, int ticksInUse, SpellModifiers modifiers) {
        if (WizardData.get((EntityPlayer)caster) != null) {
            WizardData data = WizardData.get((EntityPlayer)caster);
            if (world.field_72995_K) {
                this.playSound(world, (EntityLivingBase)caster, ticksInUse, -1, modifiers, new String[0]);
            }
            NBTTagCompound listener = new NBTTagCompound();
            listener.func_74778_a(ACTIVE_LISTENER_TAG, this.getRegistryName().toString());
            data.setVariable(ACTIVE_CONTINGENCY_LISTENER, (Object)listener);
            if (!world.field_72995_K) {
                data.sync();
            }
            if (world.field_72995_K) {
                this.spawnParticles(world, (EntityLivingBase)caster, modifiers);
            }
            this.playSound(world, (EntityLivingBase)caster, ticksInUse, -1, modifiers, new String[0]);
            return true;
        }
        return false;
    }

    public boolean canBeCastBy(EntityLiving npc, boolean override) {
        return false;
    }

    public boolean canBeCastBy(TileEntityDispenser dispenser) {
        return false;
    }

    public boolean applicableForItem(Item item) {
        return item == ASItems.ancient_spell_book || item == ASItems.ancient_spellcraft_scroll;
    }

    public void spawnParticles(World world, EntityLivingBase caster, SpellModifiers modifiers) {
        int i = 0;
        while ((float)i < this.particleCount) {
            double x = caster.field_70165_t + world.field_73012_v.nextDouble() * 2.0 - 1.0;
            double y = caster.field_70163_u + (double)caster.func_70047_e() - 0.5 + world.field_73012_v.nextDouble();
            double z = caster.field_70161_v + world.field_73012_v.nextDouble() * 2.0 - 1.0;
            ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.SPARKLE).pos(x, y, z).vel(0.0, 0.1, 0.0).clr(this.r, this.g, this.b).spawn(world);
            ++i;
        }
        ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.BUFF).entity((Entity)caster).clr(this.r, this.g, this.b).spawn(world);
    }

    @SideOnly(value=Side.CLIENT)
    public String getDisplayNameWithFormatting() {
        return TextFormatting.GOLD + I18n.func_135052_a((String)this.getTranslationKey(), (Object[])new Object[0]);
    }

    public static enum Type {
        FIRE(ASSpells.contingency_fire, "ancientspellcraft:contingency_fire"),
        FALL(ASSpells.contingency_fall, "ancientspellcraft:contingency_fall"),
        DAMAGE(ASSpells.contingency_damage, "ancientspellcraft:contingency_damage"),
        CRITICAL_HEALTH(ASSpells.contingency_critical_health, "ancientspellcraft:contingency_critical_health"),
        DEATH(ASSpells.contingency_death, "ancientspellcraft:contingency_death"),
        DROWNING(ASSpells.contingency_drowning, "ancientspellcraft:contingency_drowning"),
        HOSTILE_SPELLCAST(ASSpells.contingency_hostile_spellcast, "ancientspellcraft:contingency_hostile_spellcast"),
        IMMOBILITY(ASSpells.contingency_paralysis, "ancientspellcraft:contingency_immobility");

        public Spell spell;
        public String spellName;

        private Type(Spell spell, String spellName) {
            this.spell = spell;
            this.spellName = spellName;
        }

        public static Type fromName(String name) {
            for (Type type : Type.values()) {
                if (!type.spellName.equals(name)) continue;
                return type;
            }
            throw new IllegalArgumentException("No such type with unlocalised name: " + name);
        }
    }
}

