/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.ancientspellcraft.spell;

import com.windanesz.ancientspellcraft.registry.ASItems;
import com.windanesz.ancientspellcraft.registry.ASPotions;
import electroblob.wizardry.item.SpellActions;
import electroblob.wizardry.spell.Spell;
import electroblob.wizardry.spell.SpellRay;
import electroblob.wizardry.util.EntityUtils;
import electroblob.wizardry.util.ParticleBuilder;
import electroblob.wizardry.util.SpellModifiers;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.EntityTravelToDimensionEvent;
import net.minecraftforge.event.entity.living.EnderTeleportEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@Mod.EventBusSubscriber
public class DimensionalAnchor
extends SpellRay {
    public static List<String> teleportationSpellList = Arrays.asList("ebwizardry:phase_step", "ebwizardry:blink", "ebwizardry:transportation", "ebwizardry:transience", "ancientspellcraft:transportation_portal", "ancientspellcraft:pocket_dimension", "ancientspellcraft:hellgate");

    public DimensionalAnchor() {
        super("ancientspellcraft", "dimensional_anchor", SpellActions.POINT, false);
        this.soundValues(1.0f, 1.1f, 0.2f);
        this.addProperties(new String[]{"effect_duration"});
    }

    protected boolean onEntityHit(World world, Entity target, Vec3d hit, EntityLivingBase caster, Vec3d origin, int ticksInUse, SpellModifiers modifiers) {
        if (EntityUtils.isLiving((Entity)target)) {
            ((EntityLivingBase)target).func_70690_d(new PotionEffect(ASPotions.dimensional_anchor, this.getProperty("effect_duration").intValue(), 0));
        }
        return true;
    }

    protected boolean onBlockHit(World world, BlockPos pos, EnumFacing side, Vec3d hit, EntityLivingBase caster, Vec3d origin, int ticksInUse, SpellModifiers modifiers) {
        return true;
    }

    protected boolean onMiss(World world, EntityLivingBase caster, Vec3d origin, Vec3d direction, int ticksInUse, SpellModifiers modifiers) {
        return true;
    }

    protected void spawnParticle(World world, double x, double y, double z, double vx, double vy, double vz) {
        ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.DARK_MAGIC).pos(x, y, z).clr(1235712).spawn(world);
        ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.DARK_MAGIC).pos(x, y, z).clr(544002).spawn(world);
        ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.SPARKLE).pos(x, y, z).time(12 + world.field_73012_v.nextInt(8)).clr(740160).spawn(world);
    }

    public static boolean shouldPreventSpell(EntityLivingBase entity, World world, Spell spell) {
        boolean preventCast = false;
        if (entity != null && world != null && entity.func_70644_a(ASPotions.dimensional_anchor) && (preventCast = teleportationSpellList.contains(spell.getRegistryName().toString())) && entity instanceof EntityPlayer && !world.field_72995_K) {
            ((EntityPlayer)entity).func_146105_b((ITextComponent)new TextComponentTranslation("spell.ancientspellcraft:dimensional_anchor.prevent_spell", new Object[0]), false);
        }
        return preventCast;
    }

    @SubscribeEvent
    public static void onEnderTeleportEvent(EnderTeleportEvent event) {
        if (event.getEntityLiving().func_70644_a(ASPotions.dimensional_anchor) && event.isCancelable()) {
            if (event.getEntityLiving() instanceof EntityPlayer && !event.getEntityLiving().field_70170_p.field_72995_K) {
                ((EntityPlayer)event.getEntityLiving()).func_146105_b((ITextComponent)new TextComponentTranslation("spell.ancientspellcraft:dimensional_anchor.prevent_ender_pearl", new Object[0]), false);
            }
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onEntityTravelToDimension(EntityTravelToDimensionEvent event) {
        if (event.getEntity() instanceof EntityLivingBase && ((EntityLivingBase)event.getEntity()).func_70644_a(ASPotions.dimensional_anchor)) {
            if (event.getEntity() instanceof EntityPlayer && !event.getEntity().field_70170_p.field_72995_K) {
                ((EntityPlayer)event.getEntity()).func_146105_b((ITextComponent)new TextComponentTranslation("spell.ancientspellcraft:dimensional_anchor.prevent_ender_pearl", new Object[0]), false);
            }
            event.setCanceled(true);
        }
    }

    public boolean applicableForItem(Item item) {
        return item == ASItems.ancient_spell_book || item == ASItems.ancient_spellcraft_scroll;
    }

    @SideOnly(value=Side.CLIENT)
    public String getDisplayNameWithFormatting() {
        return TextFormatting.GOLD + I18n.func_135052_a((String)this.getTranslationKey(), (Object[])new Object[0]);
    }
}

