/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.ancientspellcraft.spell;

import com.windanesz.ancientspellcraft.registry.ASBlocks;
import com.windanesz.ancientspellcraft.spell.SpellRayAS;
import com.windanesz.ancientspellcraft.tileentity.TileEntityTeleportationFlame;
import com.windanesz.ancientspellcraft.util.ASUtils;
import electroblob.wizardry.data.IStoredVariable;
import electroblob.wizardry.data.Persistence;
import electroblob.wizardry.data.WizardData;
import electroblob.wizardry.item.SpellActions;
import electroblob.wizardry.util.BlockUtils;
import electroblob.wizardry.util.Location;
import electroblob.wizardry.util.SpellModifiers;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class EnchantFireplace
extends SpellRayAS {
    public static final IStoredVariable<BlockPos> LAST_FIRE = IStoredVariable.StoredVariable.ofBlockPos((String)"lastEnchantedFireLocation", (Persistence)Persistence.ALWAYS).setSynced();
    private static final float RAY_TRACE_RANGE = 5.0f;
    private static final int MIN_FIREPLACE_SIDES = 3;
    private static final String CANNOT_LINK_TO_ITSELF_KEY = "spell.ancientspellcraft:teleportation_flame.cannot_link_to_itself";
    private static final String LINK_SUCCESS_KEY = "spell.ancientspellcraft:teleportation_flame.link_success";
    private static final String FLAME_STORED_KEY = "spell.ancientspellcraft:teleportation_flame.stored";
    private static final String NOT_LOOKING_AT_FLAME_KEY = "spell.ancientspellcraft:teleportation_flame.not_looking_at_flame";
    private static final String NO_FIREPLACE_KEY = "spell.ancientspellcraft:teleportation_flame.no_fireplace";

    public EnchantFireplace() {
        super("enchant_fireplace", SpellActions.SUMMON, false);
        this.soundValues(1.0f, 1.2f, 0.4f);
        this.addProperties(new String[]{"duration"});
        WizardData.registerStoredVariables((IStoredVariable[])new IStoredVariable[]{LAST_FIRE});
    }

    public boolean cast(World world, EntityPlayer caster, EnumHand hand, int ticksInUse, SpellModifiers modifiers) {
        BlockPos pos;
        RayTraceResult rayTrace = this.performRayTrace(world, caster);
        if (rayTrace != null && rayTrace.field_72313_a == RayTraceResult.Type.BLOCK && world.func_180495_p(pos = rayTrace.func_178782_a()).func_177230_c() == ASBlocks.TELEPORTATION_FLAME) {
            if (caster.func_70093_af()) {
                return this.handleStoreFlameLocation(world, caster, pos);
            }
            return this.handleSetFlameTarget(world, caster, pos);
        }
        return super.cast(world, caster, hand, ticksInUse, modifiers);
    }

    private boolean handleStoreFlameLocation(World world, EntityPlayer caster, BlockPos pos) {
        if (world.field_72995_K) {
            return false;
        }
        WizardData data = WizardData.get((EntityPlayer)caster);
        if (data == null) {
            return false;
        }
        data.setVariable(LAST_FIRE, (Object)pos);
        ASUtils.sendMessage((Entity)caster, FLAME_STORED_KEY, true, new Object[0]);
        return true;
    }

    private boolean handleSetFlameTarget(World world, EntityPlayer caster, BlockPos pos) {
        if (world.field_72995_K) {
            return false;
        }
        TileEntity tileEntity = world.func_175625_s(pos);
        if (!(tileEntity instanceof TileEntityTeleportationFlame)) {
            return false;
        }
        TileEntityTeleportationFlame flame = (TileEntityTeleportationFlame)tileEntity;
        WizardData data = WizardData.get((EntityPlayer)caster);
        if (data == null) {
            return false;
        }
        BlockPos storedLocation = (BlockPos)data.getVariable(LAST_FIRE);
        if (storedLocation == null) {
            ASUtils.sendMessage((Entity)caster, "spell.ancientspellcraft:teleportation_flame.no_stored_location", true, new Object[0]);
            return false;
        }
        if (this.isSamePosition(pos, storedLocation) && caster.field_71093_bK == world.field_73011_w.getDimension()) {
            ASUtils.sendMessage((Entity)caster, CANNOT_LINK_TO_ITSELF_KEY, true, new Object[0]);
            return false;
        }
        flame.setTargetLocation(new Location(storedLocation, world.field_73011_w.getDimension()));
        ASUtils.sendMessage((Entity)caster, LINK_SUCCESS_KEY, true, new Object[0]);
        return true;
    }

    private boolean isSamePosition(BlockPos pos1, BlockPos pos2) {
        return pos1.func_177958_n() == pos2.func_177958_n() && pos1.func_177956_o() == pos2.func_177956_o() && pos1.func_177952_p() == pos2.func_177952_p();
    }

    private RayTraceResult performRayTrace(World world, EntityPlayer caster) {
        Vec3d look = caster.func_70040_Z();
        Vec3d start = new Vec3d(caster.field_70165_t, caster.field_70163_u + (double)caster.func_70047_e(), caster.field_70161_v);
        Vec3d end = start.func_72441_c(look.field_72450_a * 5.0, look.field_72448_b * 5.0, look.field_72449_c * 5.0);
        return world.func_72901_a(start, end, false);
    }

    protected boolean onEntityHit(World world, Entity target, Vec3d hit, @Nullable EntityLivingBase caster, Vec3d origin, int ticksInUse, SpellModifiers modifiers) {
        return false;
    }

    protected boolean onBlockHit(World world, BlockPos pos, EnumFacing side, Vec3d hit, @Nullable EntityLivingBase caster, Vec3d origin, int ticksInUse, SpellModifiers modifiers) {
        if (world.field_72995_K) {
            return false;
        }
        BlockPos placePos = pos.func_177972_a(side);
        if (BlockUtils.canBlockBeReplaced((World)world, (BlockPos)placePos)) {
            if (!EnchantFireplace.isValidFireplaceLocation(world, placePos) && caster instanceof EntityPlayer) {
                ASUtils.sendMessage((Entity)caster, NO_FIREPLACE_KEY, true, new Object[0]);
                return false;
            }
            if (world.func_175656_a(placePos, ASBlocks.TELEPORTATION_FLAME.func_176223_P())) {
                this.configureFlameBlock(world, placePos, caster, this.getProperty("duration").intValue());
                return true;
            }
        }
        return false;
    }

    private void configureFlameBlock(World world, BlockPos pos, @Nullable EntityLivingBase caster, int duration) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof TileEntityTeleportationFlame) {
            TileEntityTeleportationFlame teleportationFlame = (TileEntityTeleportationFlame)tileEntity;
            teleportationFlame.setLifetime(duration);
            if (caster != null) {
                teleportationFlame.setCaster(caster);
            }
        }
    }

    protected boolean onMiss(World world, @Nullable EntityLivingBase caster, Vec3d origin, Vec3d direction, int ticksInUse, SpellModifiers modifiers) {
        return false;
    }

    public static boolean isValidFireplaceLocation(World world, BlockPos pos) {
        Block[] validBlocks = EnchantFireplace.getValidFireplaceBlocks();
        BlockPos belowPos = pos.func_177977_b();
        if (!EnchantFireplace.isValidStructureBlock(world.func_180495_p(belowPos).func_177230_c(), validBlocks)) {
            return false;
        }
        int validSides = EnchantFireplace.countValidFireplaceSides(world, pos, validBlocks);
        return validSides >= 3;
    }

    private static Block[] getValidFireplaceBlocks() {
        return new Block[]{Blocks.field_150336_V, Blocks.field_150417_aV, Blocks.field_150385_bj};
    }

    private static int countValidFireplaceSides(World world, BlockPos pos, Block[] validBlocks) {
        int validSides = 0;
        for (EnumFacing facing : EnumFacing.field_176754_o) {
            BlockPos sidePos = pos.func_177972_a(facing);
            if (!EnchantFireplace.isValidStructureBlock(world.func_180495_p(sidePos).func_177230_c(), validBlocks)) continue;
            ++validSides;
        }
        return validSides;
    }

    private static boolean isValidStructureBlock(Block block, Block[] validBlocks) {
        for (Block validBlock : validBlocks) {
            if (block != validBlock) continue;
            return true;
        }
        return false;
    }
}

