/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.ancientspellcraft.spell;

import com.windanesz.ancientspellcraft.block.BlockSageLectern;
import com.windanesz.ancientspellcraft.spell.IClassSpell;
import com.windanesz.ancientspellcraft.spell.SpellLecternInteract;
import com.windanesz.ancientspellcraft.tileentity.TileSageLectern;
import com.windanesz.ancientspellcraft.util.ASUtils;
import electroblob.wizardry.block.BlockReceptacle;
import electroblob.wizardry.data.WizardData;
import electroblob.wizardry.event.DiscoverSpellEvent;
import electroblob.wizardry.item.ItemSpellBook;
import electroblob.wizardry.item.SpellActions;
import electroblob.wizardry.registry.WizardrySounds;
import electroblob.wizardry.spell.Spell;
import electroblob.wizardry.util.ParticleBuilder;
import electroblob.wizardry.util.SpellModifiers;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;

public class EnchantLectern
extends SpellLecternInteract {
    public EnchantLectern() {
        super("enchant_lectern", SpellActions.POINT, true);
    }

    protected boolean onBlockHit(World world, BlockPos pos, EnumFacing side, Vec3d hit, @Nullable EntityLivingBase caster, Vec3d origin, int ticksInUse, SpellModifiers modifiers) {
        if (caster instanceof EntityPlayer) {
            if (!EnchantLectern.isLecternBlock(world, pos)) {
                return false;
            }
            int minTicks = 100;
            this.spawnLecternParticles(world, ticksInUse, pos, minTicks);
            if (ticksInUse < minTicks) {
                return true;
            }
            EntityPlayer player = (EntityPlayer)caster;
            if (EnchantLectern.isLecternBlock(world, pos)) {
                ItemStack stack = BlockSageLectern.getItemOnLectern(world, pos);
                if (stack.func_77973_b() instanceof ItemSpellBook && !(stack.func_77973_b() instanceof IClassSpell)) {
                    Spell spell = Spell.byMetadata((int)stack.func_77960_j());
                    WizardData data = WizardData.get((EntityPlayer)player);
                    int[] colours = (int[])BlockReceptacle.PARTICLE_COLOURS.get(spell.getElement());
                    if (world.field_72995_K) {
                        for (int i = 0; i < 2; ++i) {
                            ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.DUST).pos((double)((float)pos.func_177958_n() + world.field_73012_v.nextFloat()), (double)(pos.func_177956_o() + 1), (double)((float)pos.func_177952_p() + world.field_73012_v.nextFloat())).vel(0.0, 0.05 + (double)world.field_73012_v.nextFloat() * 0.1, 0.0).clr(colours[1]).fade(colours[2]).time(40).shaded(false).spawn(world);
                        }
                    }
                    if (!data.hasSpellBeenDiscovered(spell)) {
                        if (!world.field_72995_K) {
                            player.func_146105_b((ITextComponent)new TextComponentTranslation("spell." + this.getUnlocalisedName() + ".unknown_spell", new Object[0]), true);
                        }
                        return true;
                    }
                    if (!world.field_72995_K && !(spell instanceof IClassSpell)) {
                        TileEntity lectern = world.func_175625_s(pos);
                        if (lectern instanceof TileSageLectern) {
                            ((TileSageLectern)lectern).addSpellEffect(this);
                        }
                        player.func_146105_b((ITextComponent)new TextComponentTranslation("spell." + this.getUnlocalisedName() + ".blessing_done", new Object[]{spell.getNameForTranslationFormatted()}), false);
                        return false;
                    }
                    return false;
                }
                if (!world.field_72995_K) {
                    player.func_146105_b((ITextComponent)new TextComponentTranslation("spell." + this.getUnlocalisedName() + ".no_valid_book", new Object[0]), true);
                }
                return false;
            }
            ASUtils.sendMessage((Entity)player, "generic.ancientspellcraft:spell_lectern_interact.no_lectern", true, new Object[0]);
        }
        return true;
    }

    @Override
    public void persistentEffectOnLecternClick(TileSageLectern lectern, EntityPlayer player) {
        Spell spell;
        if (lectern.getBookSlotItem().func_77973_b() instanceof ItemSpellBook && !((spell = Spell.byMetadata((int)lectern.getBookSlotItem().func_77960_j())) instanceof IClassSpell) && !WizardData.get((EntityPlayer)player).hasSpellBeenDiscovered(spell) && !MinecraftForge.EVENT_BUS.post((Event)new DiscoverSpellEvent(player, spell, DiscoverSpellEvent.Source.IDENTIFICATION_SCROLL))) {
            WizardData.get((EntityPlayer)player).discoverSpell(spell);
            player.func_184185_a(WizardrySounds.MISC_DISCOVER_SPELL, 1.25f, 1.0f);
            if (!player.field_70170_p.field_72995_K) {
                player.func_145747_a((ITextComponent)new TextComponentTranslation("spell.discover", new Object[]{spell.getNameForTranslationFormatted()}));
            }
        }
    }
}

