/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.ancientspellcraft.spell;

import com.windanesz.ancientspellcraft.Settings;
import com.windanesz.ancientspellcraft.misc.WeightedRandom;
import com.windanesz.ancientspellcraft.registry.ASItems;
import com.windanesz.ancientspellcraft.registry.ASSpells;
import com.windanesz.ancientspellcraft.spell.IClassSpell;
import com.windanesz.ancientspellcraft.util.ASUtils;
import electroblob.wizardry.Wizardry;
import electroblob.wizardry.block.BlockReceptacle;
import electroblob.wizardry.constants.Element;
import electroblob.wizardry.constants.Tier;
import electroblob.wizardry.data.IStoredVariable;
import electroblob.wizardry.data.Persistence;
import electroblob.wizardry.data.WizardData;
import electroblob.wizardry.item.ItemArtefact;
import electroblob.wizardry.item.ItemWizardArmour;
import electroblob.wizardry.item.SpellActions;
import electroblob.wizardry.misc.Forfeit;
import electroblob.wizardry.potion.Curse;
import electroblob.wizardry.registry.WizardryItems;
import electroblob.wizardry.spell.Spell;
import electroblob.wizardry.util.NBTExtras;
import electroblob.wizardry.util.ParticleBuilder;
import electroblob.wizardry.util.SpellModifiers;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class Experiment
extends Spell
implements IClassSpell {
    public static final String EXPERIMENTED_SPELLS = "experimented_spells";
    public static final String BASE_SUCCESS_CHANCE = "base_success_chance";
    public static final String FIRST_CAST = "first_cast";
    public static final String THEORY_POINT_COUNT = "theory_point_count";
    public static final String FORFEIT_WEIGHT = "forfeit_weight";
    public static final String BUFF_WEIGHT = "buff_weight";
    public static final String DEBUFF_WEIGHT = "debuff_weight";
    public static final String NO_EFFECT_WEIGHT = "no_effect_weight";
    public static final String LAST_EFFECT = "last_effect";
    private static final IStoredVariable<NBTTagCompound> EXPERIMENT_DATA_NBT = IStoredVariable.StoredVariable.ofNBT((String)"experimentData", (Persistence)Persistence.ALWAYS).setSynced();

    public Experiment() {
        super("ancientspellcraft", "experiment", SpellActions.SUMMON, false);
        WizardData.registerStoredVariables((IStoredVariable[])new IStoredVariable[]{EXPERIMENT_DATA_NBT});
        this.addProperties(new String[]{BASE_SUCCESS_CHANCE, FORFEIT_WEIGHT, BUFF_WEIGHT, DEBUFF_WEIGHT, NO_EFFECT_WEIGHT});
    }

    public static float getSuccessChance(EntityPlayer player) {
        float chance = ASSpells.experiment.getProperty(BASE_SUCCESS_CHANCE).floatValue();
        ArrayList usableSpells = new ArrayList(WizardData.get((EntityPlayer)player).spellsDiscovered);
        List experimentedSpells = (List)NBTExtras.NBTToList((NBTTagList)Experiment.getData(player).func_150295_c(EXPERIMENTED_SPELLS, 8), tag -> Spell.get((String)tag.func_150285_a_()));
        usableSpells.removeAll(experimentedSpells);
        if (!usableSpells.isEmpty()) {
            List distinctElements = usableSpells.stream().map(Spell::getElement).collect(Collectors.toList());
            chance = (float)((double)chance + Math.pow(distinctElements.size(), 2.0));
        }
        return Math.min(chance, 100.0f);
    }

    public static List<Element> getResearchedElements(EntityPlayer player) {
        ArrayList usableSpells = new ArrayList(WizardData.get((EntityPlayer)player).spellsDiscovered);
        List experimentedSpells = (List)NBTExtras.NBTToList((NBTTagList)Experiment.getData(player).func_150295_c(EXPERIMENTED_SPELLS, 8), tag -> Spell.get((String)tag.func_150285_a_()));
        usableSpells.removeAll(experimentedSpells);
        if (!usableSpells.isEmpty()) {
            return usableSpells.stream().map(Spell::getElement).collect(Collectors.toList());
        }
        return new ArrayList<Element>();
    }

    public static boolean isFirstCast(NBTTagCompound experimentData) {
        return !experimentData.func_74764_b(FIRST_CAST) || experimentData.func_74764_b(FIRST_CAST) && experimentData.func_74767_n(FIRST_CAST);
    }

    public static int getDiscoveredSpellCount(EntityPlayer player) {
        WizardData data = WizardData.get((EntityPlayer)player);
        return data != null ? data.spellsDiscovered.size() : 0;
    }

    public static NBTTagCompound getData(EntityPlayer player) {
        NBTTagCompound experimentData;
        WizardData data = WizardData.get((EntityPlayer)player);
        if (data != null && (experimentData = (NBTTagCompound)data.getVariable(EXPERIMENT_DATA_NBT)) != null) {
            return experimentData;
        }
        return new NBTTagCompound();
    }

    public static int getTheoryPoints(EntityPlayer player) {
        NBTTagCompound data = Experiment.getData(player);
        if (data != null && data.func_74764_b(THEORY_POINT_COUNT)) {
            return data.func_74762_e(THEORY_POINT_COUNT);
        }
        return 0;
    }

    public static void addTheoryPoint(EntityPlayer player, int amount) {
        NBTTagCompound experimentData = Experiment.getData(player);
        experimentData = Experiment.addTheoryPoint(experimentData, amount);
        WizardData data = WizardData.get((EntityPlayer)player);
        if (data != null) {
            data.setVariable(EXPERIMENT_DATA_NBT, (Object)experimentData);
            data.sync();
        }
    }

    public static void consumeTheoryPoint(EntityPlayer player, int amount) {
        NBTTagCompound experimentData = Experiment.getData(player);
        experimentData = Experiment.consumeTheoryPoint(experimentData, amount);
        WizardData data = WizardData.get((EntityPlayer)player);
        if (data != null) {
            data.setVariable(EXPERIMENT_DATA_NBT, (Object)experimentData);
            data.sync();
        }
    }

    private static NBTTagCompound addTheoryPoint(NBTTagCompound experimentData, int amount) {
        int points = amount;
        if (experimentData.func_74764_b(THEORY_POINT_COUNT)) {
            points += experimentData.func_74762_e(THEORY_POINT_COUNT);
        }
        experimentData.func_74768_a(THEORY_POINT_COUNT, points);
        return experimentData;
    }

    private static NBTTagCompound consumeTheoryPoint(NBTTagCompound experimentData, int amount) {
        int points = 0;
        if (experimentData.func_74764_b(THEORY_POINT_COUNT)) {
            points = experimentData.func_74762_e(THEORY_POINT_COUNT) - amount;
        }
        experimentData.func_74768_a(THEORY_POINT_COUNT, points);
        return experimentData;
    }

    public static int getMinKnownSpellAmount() {
        return Math.round((float)(3.0 * Math.sqrt(Spell.registry.getKeys().size())));
    }

    public boolean cast(World world, EntityPlayer caster, EnumHand hand, int ticksInUse, SpellModifiers modifiers) {
        NBTTagCompound experimentData = Experiment.getData(caster);
        WizardData data = WizardData.get((EntityPlayer)caster);
        float chance = this.getProperty(BASE_SUCCESS_CHANCE).floatValue();
        if (ItemArtefact.isArtefactActive((EntityPlayer)caster, (Item)ASItems.amulet_inspiration)) {
            chance += 0.02f;
        }
        if (data != null) {
            if (!Experiment.isFirstCast(experimentData)) {
                boolean success;
                List distinctElements;
                ArrayList discoveredSpells = new ArrayList(data.spellsDiscovered);
                if (!experimentData.func_74764_b(EXPERIMENTED_SPELLS)) {
                    NBTExtras.storeTagSafely((NBTTagCompound)experimentData, (String)EXPERIMENTED_SPELLS, (NBTBase)NBTExtras.listToNBT(discoveredSpells, spell -> new NBTTagString(spell.getRegistryName().toString())));
                }
                List experimentedSpells = (List)NBTExtras.NBTToList((NBTTagList)experimentData.func_150295_c(EXPERIMENTED_SPELLS, 8), tag -> Spell.get((String)tag.func_150285_a_()));
                ArrayList usableSpells = new ArrayList(discoveredSpells);
                usableSpells.removeAll(experimentedSpells);
                if (!usableSpells.isEmpty()) {
                    // empty if block
                }
                if (!(distinctElements = usableSpells.stream().map(Spell::getElement).distinct().collect(Collectors.toList())).isEmpty()) {
                    chance = (float)((double)chance + Math.pow(distinctElements.size(), 2.0) * (double)0.01f);
                }
                boolean bl = success = data.synchronisedRandom.nextFloat() <= chance;
                if (success) {
                    if (!world.field_72995_K) {
                        experimentedSpells.addAll(usableSpells);
                        NBTExtras.storeTagSafely((NBTTagCompound)experimentData, (String)EXPERIMENTED_SPELLS, (NBTBase)NBTExtras.listToNBT((Collection)experimentedSpells, spell -> new NBTTagString(spell.getRegistryName().toString())));
                        Experiment.addTheoryPoint(experimentData, 1);
                        data.setVariable(EXPERIMENT_DATA_NBT, (Object)experimentData);
                        data.sync();
                        ASUtils.sendMessage((Entity)caster, "spell." + this.getUnlocalisedName() + ".received_point", true, 1);
                    }
                    if (world.field_72995_K) {
                        this.spawnParticles(world, (EntityLivingBase)caster, new SpellModifiers(), data.synchronisedRandom);
                    }
                    return true;
                }
                WeightedRandom<String> effects = new WeightedRandom<String>(data.synchronisedRandom);
                effects.addEntry(FORFEIT_WEIGHT, this.getProperty(FORFEIT_WEIGHT).floatValue());
                effects.addEntry(NO_EFFECT_WEIGHT, this.getProperty(NO_EFFECT_WEIGHT).floatValue());
                effects.addEntry(BUFF_WEIGHT, this.getProperty(BUFF_WEIGHT).floatValue());
                effects.addEntry(DEBUFF_WEIGHT, this.getProperty(DEBUFF_WEIGHT).floatValue());
                String effectType = (String)effects.getRandom();
                String effect = "";
                block7 : switch (effectType) {
                    case "forfeit_weight": {
                        int tier = data.synchronisedRandom.nextInt(Math.max(0, Math.round(3.0f - (float)distinctElements.size() / 3.0f)));
                        Element element = Element.values()[Math.max(1, data.synchronisedRandom.nextInt(Element.values().length))];
                        Forfeit forfeit = Forfeit.getRandomForfeit((Random)data.synchronisedRandom, (Tier)Tier.values()[tier], (Element)element);
                        if (forfeit == null || world.field_72995_K) break;
                        forfeit.apply(world, caster);
                        effect = forfeit.getMessageForScroll().func_150260_c();
                        try {
                            Field field = null;
                            field = ASUtils.ReflectionUtil.getField(forfeit.getClass(), "name");
                            ASUtils.ReflectionUtil.makeAccessible(field);
                            effect = ((ResourceLocation)field.get(forfeit)).toString();
                        }
                        catch (Exception field) {
                            // empty catch block
                        }
                        caster.func_145747_a(forfeit.getMessage((ITextComponent)new TextComponentTranslation("item.ancientspellcraft:tome.generic", new Object[0])));
                        break;
                    }
                    case "no_effect_weight": {
                        break;
                    }
                    case "buff_weight": {
                        List potions = ForgeRegistries.POTIONS.getValuesCollection().stream().filter(p -> !p.func_76398_f()).collect(Collectors.toList());
                        for (int i = 0; i < 10; ++i) {
                            Potion randomPotion = (Potion)potions.get(data.synchronisedRandom.nextInt(potions.size()));
                            if (Arrays.asList(Settings.generalSettings.experiment_buff_blacklist).contains(randomPotion.getRegistryName().toString())) continue;
                            int duration = data.synchronisedRandom.nextInt(1000);
                            effect = randomPotion.getRegistryName().toString() + "," + duration;
                            if (!world.field_72995_K) {
                                caster.func_70690_d(new PotionEffect(randomPotion, duration));
                            }
                            ASUtils.sendMessage((Entity)caster, "spell." + this.getUnlocalisedName() + ".buff_effect", false, new TextComponentTranslation(randomPotion.func_76393_a(), new Object[0]));
                            break block7;
                        }
                        break;
                    }
                    case "debuff_weight": {
                        List potions = ForgeRegistries.POTIONS.getValuesCollection().stream().filter(p -> !(p instanceof Curse) && p.func_76398_f()).collect(Collectors.toList());
                        for (int i = 0; i < 10; ++i) {
                            Potion randomPotion = (Potion)potions.get(data.synchronisedRandom.nextInt(potions.size()));
                            if (Arrays.asList(Settings.generalSettings.experiment_buff_blacklist).contains(randomPotion.getRegistryName().toString())) continue;
                            int duration = data.synchronisedRandom.nextInt(1000);
                            effect = randomPotion.getRegistryName().toString() + "," + duration;
                            if (!world.field_72995_K) {
                                caster.func_70690_d(new PotionEffect(randomPotion, duration));
                            }
                            ASUtils.sendMessage((Entity)caster, "spell." + this.getUnlocalisedName() + ".buff_effect", false, new TextComponentTranslation(randomPotion.func_76393_a(), new Object[0]));
                            break block7;
                        }
                        break;
                    }
                }
                if (world.field_72995_K) {
                    this.spawnParticles(world, (EntityLivingBase)caster, new SpellModifiers(), data.synchronisedRandom);
                }
                if (!effect.isEmpty()) {
                    NBTTagCompound nbt = new NBTTagCompound();
                    nbt.func_74778_a("effectType", effectType);
                    nbt.func_74778_a("effect", effect);
                    this.storeLastEffect(caster, nbt);
                }
                return true;
            }
            int knownSpellAmount = Experiment.getDiscoveredSpellCount(caster);
            int minimumKnownSpellAmount = Experiment.getMinKnownSpellAmount();
            if (ItemArtefact.isArtefactActive((EntityPlayer)caster, (Item)ASItems.charm_sage_diary)) {
                minimumKnownSpellAmount = (int)((float)minimumKnownSpellAmount * 0.6f);
            }
            if (knownSpellAmount < minimumKnownSpellAmount) {
                if (!world.field_72995_K) {
                    caster.func_146105_b((ITextComponent)new TextComponentTranslation("spell." + this.getUnlocalisedName() + ".not_enough_known_spells", new Object[]{knownSpellAmount, minimumKnownSpellAmount, minimumKnownSpellAmount - knownSpellAmount}), false);
                }
                return false;
            }
            int theoryPoints = 0;
            int extraKnowledge = minimumKnownSpellAmount - knownSpellAmount;
            if (extraKnowledge > 0) {
                int rolls = extraKnowledge / 8;
                for (int i = 0; i < rolls; ++i) {
                    if (!(data.synchronisedRandom.nextFloat() < 0.4f)) continue;
                    ++theoryPoints;
                }
                ASUtils.sendMessage((Entity)caster, "spell." + this.getUnlocalisedName() + ".first_cast_with_bonus", false, theoryPoints);
                ASUtils.sendMessage((Entity)caster, "spell." + this.getUnlocalisedName() + ".current_amount_of_theory_points", false, Experiment.getTheoryPoints(caster));
            }
            Experiment.addTheoryPoint(experimentData, theoryPoints);
            experimentData.func_74757_a(FIRST_CAST, false);
            data.setVariable(EXPERIMENT_DATA_NBT, (Object)experimentData);
            data.sync();
            if (world.field_72995_K) {
                this.spawnParticles(world, (EntityLivingBase)caster, new SpellModifiers(), data.synchronisedRandom);
            }
            return true;
        }
        if (world.field_72995_K) {
            this.spawnParticles(world, (EntityLivingBase)caster, new SpellModifiers(), data.synchronisedRandom);
        }
        return true;
    }

    public boolean cast(World world, EntityLiving caster, EnumHand hand, int ticksInUse, EntityLivingBase target, SpellModifiers modifiers) {
        return false;
    }

    @Override
    public ItemWizardArmour.ArmourClass getArmourClass() {
        return ItemWizardArmour.ArmourClass.SAGE;
    }

    public void spawnParticle() {
    }

    public boolean applicableForItem(Item item) {
        return item == ASItems.mystic_spell_book;
    }

    public static void spawnParticle(World world, EntityLivingBase caster, SpellModifiers modifiers, Random rand) {
        int effect = rand.nextInt(13);
        float r = world.field_73012_v.nextFloat();
        float g = world.field_73012_v.nextFloat();
        float b = world.field_73012_v.nextFloat();
        switch (effect) {
            case 0: {
                for (int i = 0; i < 10; ++i) {
                    double x = caster.field_70165_t + world.field_73012_v.nextDouble() * 2.0 - 1.0;
                    double y = caster.field_70163_u + (double)caster.func_70047_e() - 0.5 + world.field_73012_v.nextDouble();
                    double z = caster.field_70161_v + world.field_73012_v.nextDouble() * 2.0 - 1.0;
                    ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.SPARKLE).pos(x, y, z).vel(0.0, 0.1, 0.0).clr(r, g, b).spawn(world);
                }
                break;
            }
            case 1: {
                ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.BUFF).entity((Entity)caster).clr(r, g, b).spawn(world);
                for (int i = 0; i < 20; ++i) {
                    double x = caster.field_70165_t + world.field_73012_v.nextDouble() * 2.0 - 1.0;
                    double y = caster.field_70163_u + (double)caster.func_70047_e() - 0.5 + world.field_73012_v.nextDouble();
                    double z = caster.field_70161_v + world.field_73012_v.nextDouble() * 2.0 - 1.0;
                    ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.SPARKLE).pos(x, y, z).vel(0.0, 0.14, 0.0).clr(r, g, b).time(20 + world.field_73012_v.nextInt(12)).spawn(world);
                    ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.DARK_MAGIC).pos(x, y, z).clr(r, g, b).spawn(world);
                }
                break;
            }
            case 2: {
                int i = 0;
                while ((float)i < 40.0f * modifiers.get(WizardryItems.blast_upgrade)) {
                    double particleX = caster.func_174791_d().field_72450_a - 1.0 + 2.0 * world.field_73012_v.nextDouble();
                    double particleZ = caster.func_174791_d().field_72449_c - 1.0 + 2.0 * world.field_73012_v.nextDouble();
                    ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.DARK_MAGIC).pos(particleX, caster.func_174791_d().field_72448_b, particleZ).vel(particleX - caster.func_174791_d().field_72450_a, 0.0, particleZ - caster.func_174791_d().field_72449_c).clr(r, g, b).spawn(world);
                    particleX = caster.func_174791_d().field_72450_a - 1.0 + 2.0 * world.field_73012_v.nextDouble();
                    particleZ = caster.func_174791_d().field_72449_c - 1.0 + 2.0 * world.field_73012_v.nextDouble();
                    ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.SPARKLE).pos(particleX, caster.func_174791_d().field_72448_b, particleZ).vel(particleX - caster.func_174791_d().field_72450_a, 0.0, particleZ - caster.func_174791_d().field_72449_c).time(30).clr(r, g, b).spawn(world);
                    particleX = caster.func_174791_d().field_72450_a - 1.0 + 2.0 * world.field_73012_v.nextDouble();
                    particleZ = caster.func_174791_d().field_72449_c - 1.0 + 2.0 * world.field_73012_v.nextDouble();
                    IBlockState block = world.func_180495_p(new BlockPos(caster.func_174791_d().field_72450_a, caster.func_174791_d().field_72448_b - 0.5, caster.func_174791_d().field_72449_c));
                    if (block != null) {
                        world.func_175688_a(EnumParticleTypes.BLOCK_DUST, particleX, caster.func_174791_d().field_72448_b, particleZ, particleX - caster.func_174791_d().field_72450_a, 0.0, particleZ - caster.func_174791_d().field_72449_c, new int[]{Block.func_176210_f((IBlockState)block)});
                    }
                    ++i;
                }
                break;
            }
            case 3: {
                ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.SPHERE).pos(caster.func_174791_d().func_72441_c(0.0, 0.5, 0.0)).scale(2.0f * ((float)rand.nextInt(2) + 1.0f)).clr(r, g, b).spawn(world);
                break;
            }
            case 4: {
                for (int i = 0; i < 2 * rand.nextInt(5); ++i) {
                    ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.CLOUD, (Entity)caster).pos((double)rand.nextFloat(), (double)rand.nextFloat(), (double)rand.nextFloat()).clr(r, g, b).shaded(true).spawn(world);
                }
                break;
            }
            case 5: {
                for (int i = 0; i < 5; ++i) {
                    world.func_175688_a(EnumParticleTypes.SMOKE_LARGE, caster.field_70165_t + (world.field_73012_v.nextDouble() - 0.5) * (double)caster.field_70130_N, caster.field_70163_u + world.field_73012_v.nextDouble() * (double)caster.field_70131_O + (double)0.3f, caster.field_70161_v + (world.field_73012_v.nextDouble() - 0.5) * (double)caster.field_70130_N, 0.0, 0.0, 0.0, new int[0]);
                }
                break;
            }
            case 6: {
                for (int i = 0; i < 20 + rand.nextInt(20); ++i) {
                    double dx = world.field_73012_v.nextDouble() * (double)(world.field_73012_v.nextBoolean() ? 1 : -1) * 0.1;
                    double dy = world.field_73012_v.nextDouble() * (double)(world.field_73012_v.nextBoolean() ? 1 : -1) * 0.1;
                    double dz = world.field_73012_v.nextDouble() * (double)(world.field_73012_v.nextBoolean() ? 1 : -1) * 0.1;
                    ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.SPARKLE).entity((Entity)caster).clr(r, g, b).pos(0.0, (double)(caster.field_70131_O / 2.0f), 0.0).vel(dx, dy, dz).spawn(world);
                }
                break;
            }
            case 7: {
                for (int i = 0; i < 20 + rand.nextInt(20); ++i) {
                    ParticleBuilder.create((ResourceLocation)(rand.nextBoolean() ? ParticleBuilder.Type.SPARKLE : ParticleBuilder.Type.DUST)).fade(0, 0, 0).spin(1.2, (double)(rand.nextFloat() * 0.1f)).time(rand.nextInt(20) * 3).entity((Entity)caster).pos(0.0, 1.0, 0.0).scale(1.2f).spawn(world);
                }
                break;
            }
            case 8: {
                for (int i = 0; i < 20 + rand.nextInt(20); ++i) {
                    ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.SPARKLE).pos((double)r, (double)g, (double)b).vel(0.0, 0.03, 0.0).time(50).clr(r, g, b).spawn(world);
                }
                break;
            }
            case 9: {
                ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.FLASH).face(EnumFacing.UP).entity((Entity)caster).vel(0.0, 0.1, 0.0).time(60).clr(r, g, b).scale(5.0f).spawn(world);
                break;
            }
            case 10: {
                List<ResourceLocation> list = Arrays.asList(ParticleBuilder.Type.MAGIC_FIRE, ParticleBuilder.Type.DARK_MAGIC, ParticleBuilder.Type.SNOW, ParticleBuilder.Type.LEAF, ParticleBuilder.Type.LIGHTNING);
                ResourceLocation type = list.get(rand.nextInt(list.size()));
                for (int i = 0; i < 10 + rand.nextInt(20); ++i) {
                    ParticleBuilder.create((ResourceLocation)type).vel(0.0, 0.1, 0.0).spin((double)0.8f, (double)(0.03f + rand.nextFloat() / 2.0f)).time(40).entity((Entity)caster).scale(1.2f).spawn(world);
                }
                break;
            }
            case 11: {
                int i;
                int[] colours = (int[])BlockReceptacle.PARTICLE_COLOURS.get(Element.values()[rand.nextInt(Element.values().length)]);
                for (i = 0; i < 60 + rand.nextInt(20); ++i) {
                    ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.DUST).entity((Entity)caster).pos(world.field_73012_v.nextBoolean() ? (double)world.field_73012_v.nextFloat() : (double)(-world.field_73012_v.nextFloat()), 0.3, world.field_73012_v.nextBoolean() ? (double)world.field_73012_v.nextFloat() : (double)(-world.field_73012_v.nextFloat())).vel(0.0, 0.05 + (double)world.field_73012_v.nextFloat() * 0.1, 0.0).clr(colours[1]).fade(colours[2]).time(40).shaded(false).spawn(world);
                }
                for (i = 0; i < 60 + rand.nextInt(20); ++i) {
                    ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.DUST).entity((Entity)caster).pos(world.field_73012_v.nextBoolean() ? (double)world.field_73012_v.nextFloat() : (double)(-world.field_73012_v.nextFloat()), 0.3, world.field_73012_v.nextBoolean() ? (double)world.field_73012_v.nextFloat() : (double)(-world.field_73012_v.nextFloat())).spin((double)world.field_73012_v.nextFloat(), (double)world.field_73012_v.nextFloat() * 0.1).vel(0.0, 0.05 + (double)world.field_73012_v.nextFloat() * 0.1, 0.0).clr(colours[1]).fade(colours[2]).time(40).shaded(false).spawn(world);
                }
                break;
            }
            case 12: {
                float radius = 2.0f + rand.nextFloat() * 5.0f;
                int particleCount = (int)Math.round(2.0106192533566243 * (double)radius * (double)radius);
                for (int i = 0; i < particleCount; ++i) {
                    double m = 1.0 + world.field_73012_v.nextDouble() * (double)(radius - 1.0f);
                    float angle = world.field_73012_v.nextFloat() * (float)Math.PI * 2.0f;
                    ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.SPARKLE).vel(0.0, 0.1, 0.0).clr(r, g, b).pos(caster.field_70165_t + m * (double)MathHelper.func_76134_b((float)angle), caster.field_70163_u + (double)0.1f, caster.field_70161_v + m * (double)MathHelper.func_76126_a((float)angle)).time(40).spawn(world);
                }
                break;
            }
        }
    }

    protected void spawnParticles(World world, EntityLivingBase caster, SpellModifiers modifiers, Random rand) {
        Experiment.spawnParticle(world, caster, modifiers, rand);
    }

    @SideOnly(value=Side.CLIENT)
    public String getDescription() {
        if (Minecraft.func_71410_x().field_71439_g != null) {
            EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
            NBTTagCompound nbt = Experiment.getData((EntityPlayer)player);
            if (Experiment.isFirstCast(nbt)) {
                int minKnownSpells = Experiment.getMinKnownSpellAmount();
                int knownSpells = Experiment.getDiscoveredSpellCount((EntityPlayer)player);
                String descTransKey = "spell." + this.getUnlocalisedName() + ".desc_before_first_cast";
                return Wizardry.proxy.translate(descTransKey, new Object[]{minKnownSpells, knownSpells});
            }
            List<Element> list = Experiment.getResearchedElements((EntityPlayer)player);
            List test = list.stream().map(e -> e.getDisplayName() + " ").map(f -> f.equals("None ") ? "Ancient" : f).distinct().collect(Collectors.toList());
            return Wizardry.proxy.translate(this.getDescriptionTranslationKey(), new Object[]{Float.valueOf(Experiment.getSuccessChance((EntityPlayer)player)), Experiment.getTheoryPoints((EntityPlayer)player), test});
        }
        return super.getDescription();
    }

    private void storeLastEffect(EntityPlayer player, NBTTagCompound nbt) {
        NBTTagCompound experimentData = Experiment.getData(player);
        experimentData.func_74782_a("lastExperiment", (NBTBase)nbt);
        this.saveData(player, experimentData);
    }

    private void saveData(EntityPlayer player, NBTTagCompound experimentData) {
        WizardData data = WizardData.get((EntityPlayer)player);
        data.setVariable(EXPERIMENT_DATA_NBT, (Object)experimentData);
        data.sync();
    }

    public static NBTTagCompound getLastExperiment(EntityPlayer player) {
        NBTTagCompound nbt = Experiment.getData(player);
        if (nbt.func_74764_b("lastExperiment")) {
            return nbt.func_74775_l("lastExperiment");
        }
        return new NBTTagCompound();
    }
}

