/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.ancientspellcraft.spell;

import com.windanesz.ancientspellcraft.registry.ASItems;
import electroblob.wizardry.item.ItemArtefact;
import electroblob.wizardry.registry.WizardryItems;
import electroblob.wizardry.spell.Spell;
import electroblob.wizardry.util.BlockUtils;
import electroblob.wizardry.util.SpellModifiers;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.IGrowable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.IPlantable;

public class Harvest
extends Spell {
    private static final float DEFAULT_RADIUS = 5.0f;

    public Harvest() {
        super("ancientspellcraft", "harvest", EnumAction.NONE, false);
        this.addProperties(new String[]{"effect_radius"});
        this.soundValues(0.7f, 1.2f, 0.2f);
    }

    public boolean requiresPacket() {
        return false;
    }

    public boolean canBeCastBy(EntityLiving npc, boolean override) {
        return false;
    }

    public boolean cast(World world, EntityPlayer caster, EnumHand hand, int ticksInUse, SpellModifiers modifiers) {
        boolean hasActionOccurred = false;
        float radius = this.getProperty("effect_radius").floatValue() * modifiers.get(WizardryItems.blast_upgrade);
        List sphere = BlockUtils.getBlockSphere((BlockPos)caster.func_180425_c(), (double)radius);
        HashMap<BlockPos, Block> replantList = new HashMap<BlockPos, Block>();
        for (BlockPos pos : sphere) {
            IBlockState state = world.func_180495_p(pos);
            Block block = state.func_177230_c();
            if (block instanceof IGrowable && !((IGrowable)block).func_176473_a(world, pos, state, world.field_72995_K)) {
                this.handleHarvest(world, pos, replantList);
                hasActionOccurred = true;
                continue;
            }
            if (!(block instanceof IPlantable) || !this.isPlantableBlock(state, world, pos)) continue;
            this.handleHarvest(world, pos, replantList);
            hasActionOccurred = true;
        }
        if (hasActionOccurred && !replantList.isEmpty() && ItemArtefact.isArtefactActive((EntityPlayer)caster, (Item)ASItems.charm_seed_bag)) {
            this.replantCrops(world, caster, replantList);
        }
        if (hasActionOccurred) {
            this.playSound(world, (EntityLivingBase)caster, ticksInUse, -1, modifiers, new String[0]);
        }
        return hasActionOccurred;
    }

    private void handleHarvest(World world, BlockPos pos, Map<BlockPos, Block> replantList) {
        if (!world.field_72995_K) {
            replantList.put(pos, world.func_180495_p(pos).func_177230_c());
            world.func_175655_b(pos, true);
        }
    }

    private boolean isPlantableBlock(IBlockState state, World world, BlockPos pos) {
        return world.func_180495_p(pos.func_177972_a(EnumFacing.DOWN)).func_177230_c() == state.func_177230_c();
    }

    private void replantCrops(World world, EntityPlayer caster, Map<BlockPos, Block> replantList) {
        block0: for (Map.Entry<BlockPos, Block> entry : replantList.entrySet()) {
            Item seedItem = this.getSeedItem(entry.getValue());
            if (seedItem == null) continue;
            for (int i = 0; i < caster.field_71071_by.func_70302_i_(); ++i) {
                ItemStack itemStack = caster.field_71071_by.func_70301_a(i);
                if (itemStack.func_77973_b() != seedItem) continue;
                world.func_175656_a(entry.getKey(), entry.getValue().func_176223_P());
                caster.field_71071_by.func_70298_a(i, 1);
                continue block0;
            }
        }
    }

    private Item getSeedItem(Block crop) {
        if (crop == Blocks.field_150464_aj) {
            return Items.field_151014_N;
        }
        if (crop == Blocks.field_150459_bM) {
            return Items.field_151172_bF;
        }
        if (crop == Blocks.field_185773_cZ) {
            return Items.field_185163_cU;
        }
        if (crop == Blocks.field_150440_ba) {
            return Items.field_151081_bc;
        }
        if (crop == Blocks.field_150469_bN) {
            return Items.field_151174_bG;
        }
        if (crop == Blocks.field_150423_aK) {
            return Items.field_151080_bb;
        }
        if (crop == Blocks.field_150436_aH) {
            return Items.field_151120_aE;
        }
        if (crop == Blocks.field_150388_bm) {
            return Items.field_151075_bm;
        }
        return null;
    }

    public boolean applicableForItem(Item item) {
        return item == ASItems.ancient_spellcraft_spell_book || item == ASItems.ancient_spellcraft_scroll;
    }
}

