/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.ancientspellcraft.spell;

import electroblob.wizardry.item.SpellActions;
import electroblob.wizardry.spell.SpellRay;
import electroblob.wizardry.util.ParticleBuilder;
import electroblob.wizardry.util.SpellModifiers;
import net.minecraft.block.BlockFurnace;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class HeatFurnace
extends SpellRay {
    public static final String BURN_TICKS_INCREASE = "burn_ticks_increase";

    public HeatFurnace() {
        super("ancientspellcraft", "heat_furnace", SpellActions.POINT, true);
        this.particleVelocity(1.0);
        this.particleSpacing(0.5);
        this.addProperties(new String[]{BURN_TICKS_INCREASE});
        this.soundValues(2.5f, 1.0f, 0.0f);
    }

    protected SoundEvent[] createSounds() {
        return this.createContinuousSpellSounds();
    }

    protected void playSound(World world, EntityLivingBase entity, int ticksInUse, int duration, SpellModifiers modifiers, String ... sounds) {
        this.playSoundLoop(world, entity, ticksInUse);
    }

    protected void playSound(World world, double x, double y, double z, int ticksInUse, int duration, SpellModifiers modifiers, String ... sounds) {
        this.playSoundLoop(world, x, y, z, ticksInUse, duration);
    }

    protected boolean onEntityHit(World world, Entity target, Vec3d hit, EntityLivingBase caster, Vec3d origin, int ticksInUse, SpellModifiers modifiers) {
        return false;
    }

    protected boolean onBlockHit(World world, BlockPos pos, EnumFacing side, Vec3d hit, EntityLivingBase caster, Vec3d origin, int ticksInUse, SpellModifiers modifiers) {
        TileEntityFurnace furnace;
        int furnaceBurnTime;
        TileEntity te;
        if (world.func_180495_p(pos).func_177230_c() instanceof BlockFurnace && (te = world.func_175625_s(pos)) instanceof TileEntityFurnace && (furnaceBurnTime = (furnace = (TileEntityFurnace)te).func_174887_a_(0)) < 20000) {
            furnace.func_174885_b(0, furnaceBurnTime + this.getProperty(BURN_TICKS_INCREASE).intValue());
            return true;
        }
        return false;
    }

    protected boolean onMiss(World world, EntityLivingBase caster, Vec3d origin, Vec3d direction, int ticksInUse, SpellModifiers modifiers) {
        return true;
    }

    protected void spawnParticle(World world, double x, double y, double z, double vx, double vy, double vz) {
        ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.MAGIC_FIRE).pos(x, y, z).vel(vx, vy, vz).collide(true).spawn(world);
    }
}

