/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.ancientspellcraft.spell;

import com.windanesz.ancientspellcraft.entity.living.EntityAnimatedItem;
import com.windanesz.ancientspellcraft.entity.living.IArmourClassWizard;
import com.windanesz.ancientspellcraft.item.ItemBattlemageSword;
import com.windanesz.ancientspellcraft.item.ItemSageTome;
import com.windanesz.ancientspellcraft.item.ItemWarlockOrb;
import com.windanesz.ancientspellcraft.registry.ASItems;
import com.windanesz.ancientspellcraft.ritual.WarlockAttunement;
import com.windanesz.ancientspellcraft.spell.IRunicHammerSpell;
import com.windanesz.ancientspellcraft.util.ASUtils;
import com.windanesz.ancientspellcraft.util.WizardArmourUtils;
import electroblob.wizardry.constants.Element;
import electroblob.wizardry.event.SpellCastEvent;
import electroblob.wizardry.item.ItemArtefact;
import electroblob.wizardry.item.ItemWizardArmour;
import java.util.Optional;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Mod.EventBusSubscriber
public interface IClassSpell {
    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onSpellCastPreEvent(SpellCastEvent.Pre event) {
        if (!(event.getSpell() instanceof IClassSpell)) {
            return;
        }
        IClassSpell spell = (IClassSpell)event.getSpell();
        EntityLivingBase caster = event.getCaster();
        if (caster instanceof EntityPlayer) {
            boolean allowedSource;
            ItemWizardArmour.ArmourClass armourClass = spell.getArmourClass();
            if (armourClass != ItemWizardArmour.ArmourClass.WARLOCK && WarlockAttunement.isWarlockAttuned((EntityPlayer)caster)) {
                ASUtils.sendMessage((Entity)caster, "message.ancientspellcraft:warlock_attunement_prevents_spell_cast", true, new Object[0]);
                event.setCanceled(true);
                return;
            }
            if (!WizardArmourUtils.isWearingFullSet(caster, null, armourClass)) {
                ASUtils.sendMessage((Entity)caster, "message.ancientspellcraft:must_have_full_matching_set", false, new TextComponentTranslation("wizard_armour_class." + armourClass.name().toLowerCase(), new Object[0]));
                event.setCanceled(true);
                return;
            }
            SpellCastEvent.Source source = event.getSource();
            boolean bl = allowedSource = source.name().equals(armourClass.name().toUpperCase() + "_ITEM") || source == SpellCastEvent.Source.SCROLL && armourClass == ItemWizardArmour.ArmourClass.SAGE;
            if (source != SpellCastEvent.Source.COMMAND && source != SpellCastEvent.Source.NPC && !allowedSource && !(spell instanceof IRunicHammerSpell)) {
                ASUtils.sendMessage((Entity)caster, "message.ancientspellcraft:must_use_class_item", false, new TextComponentTranslation("wizard_armour_class." + armourClass.name().toLowerCase(), new Object[0]));
                event.setCanceled(true);
            }
        } else if (caster instanceof EntityAnimatedItem) {
            Item item = event.getCaster().func_184614_ca().func_77973_b();
            switch (spell.getArmourClass()) {
                case SAGE: {
                    if (!(item instanceof ItemSageTome)) {
                        event.setCanceled(true);
                        return;
                    }
                }
                case BATTLEMAGE: {
                    if (!(item instanceof ItemBattlemageSword)) {
                        event.setCanceled(true);
                        return;
                    }
                }
                case WARLOCK: {
                    if (item instanceof ItemWarlockOrb) break;
                    event.setCanceled(true);
                }
            }
        }
    }

    public ItemWizardArmour.ArmourClass getArmourClass();

    default public Element getElementOrMagicElement(EntityLivingBase caster) {
        if (caster instanceof EntityPlayer && ItemArtefact.isArtefactActive((EntityPlayer)((EntityPlayer)caster), (Item)ASItems.head_chaos_magic)) {
            return Element.MAGIC;
        }
        Optional<Element> e = WizardArmourUtils.getFullSetElementForClassOptional(caster, this.getArmourClass());
        return e.orElse(Element.MAGIC);
    }

    default public boolean canBeCastByClassNPC(EntityLivingBase npc) {
        return npc instanceof IArmourClassWizard && ((IArmourClassWizard)npc).getArmourClass() == this.getArmourClass();
    }
}

