/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.ancientspellcraft.spell;

import com.windanesz.ancientspellcraft.registry.ASItems;
import electroblob.wizardry.item.SpellActions;
import electroblob.wizardry.spell.Spell;
import electroblob.wizardry.util.AllyDesignationSystem;
import electroblob.wizardry.util.EntityUtils;
import electroblob.wizardry.util.MagicDamage;
import electroblob.wizardry.util.ParticleBuilder;
import electroblob.wizardry.util.SpellModifiers;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityTNTPrimed;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class MassPyrokinesis
extends Spell {
    public static String SLOW_DURATION = "slow_duration";

    public MassPyrokinesis() {
        super("ancientspellcraft", "mass_pyrokinesis", SpellActions.SUMMON, true);
        this.addProperties(new String[]{"effect_radius", "damage", "burn_duration", SLOW_DURATION});
        this.soundValues(0.8f, 1.0f, 0.2f);
    }

    public boolean canBeCastBy(EntityLiving npc, boolean override) {
        return true;
    }

    protected void playSound(World world, EntityLivingBase entity, int ticksInUse, int duration, SpellModifiers modifiers, String ... sounds) {
        this.playSoundLoop(world, entity, ticksInUse);
    }

    protected void playSound(World world, double x, double y, double z, int ticksInUse, int duration, SpellModifiers modifiers, String ... sounds) {
        this.playSoundLoop(world, x, y, z, ticksInUse, duration);
    }

    public boolean cast(World world, EntityPlayer caster, EnumHand hand, int ticksInUse, SpellModifiers modifiers) {
        return this.pyrokinesis(world, (EntityLivingBase)caster, hand, ticksInUse, modifiers);
    }

    public boolean cast(World world, EntityLiving caster, EnumHand hand, int ticksInUse, EntityLivingBase target, SpellModifiers modifiers) {
        return this.pyrokinesis(world, (EntityLivingBase)caster, hand, ticksInUse, modifiers);
    }

    public boolean pyrokinesis(World world, EntityLivingBase caster, EnumHand hand, int ticksInUse, SpellModifiers modifiers) {
        boolean affected = false;
        for (EntityLivingBase entity : EntityUtils.getEntitiesWithinRadius((double)this.getProperty("effect_radius").floatValue(), (double)caster.field_70165_t, (double)caster.field_70163_u, (double)caster.field_70161_v, (World)world, EntityLivingBase.class)) {
            if (AllyDesignationSystem.isAllied((EntityLivingBase)caster, (EntityLivingBase)entity)) continue;
            if (!MagicDamage.isEntityImmune((MagicDamage.DamageType)MagicDamage.DamageType.FIRE, (Entity)entity) && entity != caster && ticksInUse % entity.field_70771_an == 1) {
                entity.func_70015_d((int)this.getProperty("burn_duration").floatValue());
                EntityUtils.attackEntityWithoutKnockback((Entity)entity, (DamageSource)MagicDamage.causeDirectMagicDamage((Entity)caster, (MagicDamage.DamageType)MagicDamage.DamageType.FIRE), (float)(this.getProperty("damage").floatValue() * modifiers.get("potency")));
                entity.func_70690_d(new PotionEffect(MobEffects.field_76421_d, (int)this.getProperty(SLOW_DURATION).floatValue(), 1));
            }
            if (world.field_72995_K) {
                for (int i = 0; i < 10; ++i) {
                    double dx = world.field_73012_v.nextDouble() * (double)(world.field_73012_v.nextBoolean() ? 1 : -1) * 0.1;
                    double dy = world.field_73012_v.nextDouble() * (double)(world.field_73012_v.nextBoolean() ? 1 : -1) * 0.1;
                    double dz = world.field_73012_v.nextDouble() * (double)(world.field_73012_v.nextBoolean() ? 1 : -1) * 0.1;
                    ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.MAGIC_FIRE).entity((Entity)entity).pos(0.0, (double)(entity.field_70131_O / 2.0f), 0.0).vel(dx, dy, dz).spawn(world);
                }
            }
            affected = true;
        }
        if (!world.field_72995_K) {
            int radius = (int)this.getProperty("effect_radius").floatValue();
            int x0 = (int)caster.field_70165_t;
            int y0 = (int)caster.field_70163_u;
            int z0 = (int)caster.field_70161_v;
            for (int x = x0 - radius; x <= x0 + radius; ++x) {
                for (int y = y0 - radius; y <= y0 + radius; ++y) {
                    for (int z = z0 - radius; z <= z0 + radius; ++z) {
                        double dist;
                        BlockPos pos = new BlockPos(x, y, z);
                        if (world.func_180495_p(pos).func_177230_c() != Blocks.field_150335_W || !((dist = Math.sqrt(pos.func_177954_c((double)x0, (double)y0, (double)z0))) <= (double)radius)) continue;
                        world.func_175698_g(pos);
                        EntityTNTPrimed tnt = new EntityTNTPrimed(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.75, (double)pos.func_177952_p() + 0.5, (EntityLivingBase)(caster instanceof EntityLiving ? (EntityLiving)caster : null));
                        world.func_72838_d((Entity)tnt);
                        world.func_184133_a(null, pos, SoundEvents.field_187904_gd, SoundCategory.BLOCKS, 1.0f, 1.0f);
                        affected = true;
                    }
                }
            }
        }
        return affected;
    }

    public boolean applicableForItem(Item item) {
        return item == ASItems.ancient_spellcraft_spell_book || item == ASItems.ancient_spellcraft_scroll;
    }
}

