/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.ancientspellcraft.spell;

import com.windanesz.ancientspellcraft.Settings;
import com.windanesz.ancientspellcraft.block.BlockLightning;
import com.windanesz.ancientspellcraft.entity.projectile.EntityMasterBolt;
import com.windanesz.ancientspellcraft.registry.ASBlocks;
import com.windanesz.ancientspellcraft.registry.ASItems;
import com.windanesz.ancientspellcraft.util.ASUtils;
import electroblob.wizardry.Wizardry;
import electroblob.wizardry.data.IStoredVariable;
import electroblob.wizardry.data.Persistence;
import electroblob.wizardry.data.WizardData;
import electroblob.wizardry.item.SpellActions;
import electroblob.wizardry.registry.WizardryPotions;
import electroblob.wizardry.registry.WizardrySounds;
import electroblob.wizardry.spell.Spell;
import electroblob.wizardry.util.BlockUtils;
import electroblob.wizardry.util.InventoryUtils;
import electroblob.wizardry.util.Location;
import electroblob.wizardry.util.NBTExtras;
import electroblob.wizardry.util.SpellModifiers;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;

public class MasterBolt
extends Spell {
    public static final IStoredVariable<List<Location>> MASTER_BOLT_LOCATIONS_KEY = new IStoredVariable.StoredVariable("masterBoltLocationsKey", s -> NBTExtras.listToNBT((Collection)s, Location::toNBT), t -> new ArrayList(NBTExtras.NBTToList((NBTTagList)t, Location::fromNBT)), Persistence.RESPAWN).setSynced();
    public static final IStoredVariable<Integer> COUNTDOWN_KEY = IStoredVariable.StoredVariable.ofInt((String)"masterBoltTpCountdown", (Persistence)Persistence.NEVER).withTicker(MasterBolt::update);

    public MasterBolt() {
        super("ancientspellcraft", "master_bolt", SpellActions.POINT_UP, false);
        WizardData.registerStoredVariables((IStoredVariable[])new IStoredVariable[]{MASTER_BOLT_LOCATIONS_KEY, COUNTDOWN_KEY});
        this.addProperties(new String[]{"damage"});
    }

    public static void storeLocation(World world, EntityPlayer player, BlockPos pos) {
        BlockPos posI;
        WizardData data = WizardData.get((EntityPlayer)player);
        Location here = new Location(pos, player.field_71093_bK);
        ArrayList<Location> locations = (ArrayList<Location>)data.getVariable(MASTER_BOLT_LOCATIONS_KEY);
        if (locations != null && !locations.isEmpty() && world.func_180495_p(posI = ((Location)locations.get((int)0)).pos).func_177230_c() == ASBlocks.master_bolt) {
            world.func_175698_g(posI);
        }
        locations = new ArrayList<Location>();
        locations.add(here);
        data.setVariable(MASTER_BOLT_LOCATIONS_KEY, locations);
        data.sync();
        if (!world.field_72995_K) {
            player.func_146105_b((ITextComponent)new TextComponentTranslation("spell.ancientspellcraft:master_bolt.remember", new Object[0]), true);
        }
    }

    public boolean cast(World world, EntityPlayer caster, EnumHand hand, int ticksInUse, SpellModifiers modifiers) {
        WizardData data;
        if (caster != null && (data = WizardData.get((EntityPlayer)caster)) != null) {
            List locations = (List)data.getVariable(MASTER_BOLT_LOCATIONS_KEY);
            if (!caster.func_70093_af()) {
                boolean removed = false;
                if (InventoryUtils.doesPlayerHaveItem((EntityPlayer)caster, (Item)ASItems.master_bolt)) {
                    for (ItemStack stack : caster.field_71071_by.field_70462_a) {
                        if (stack.func_77973_b() != ASItems.master_bolt) continue;
                        stack.func_190918_g(1);
                        removed = true;
                    }
                    for (ItemStack stack : caster.field_71071_by.field_70460_b) {
                        if (stack.func_77973_b() != ASItems.master_bolt) continue;
                        stack.func_190918_g(1);
                        removed = true;
                    }
                    for (ItemStack stack : caster.field_71071_by.field_184439_c) {
                        if (stack.func_77973_b() != ASItems.master_bolt) continue;
                        stack.func_190918_g(1);
                        removed = true;
                    }
                    if (removed && !world.field_72995_K) {
                        float speed = 1.5f;
                        if (!caster.field_70122_E) {
                            speed *= 3.0f;
                        }
                        EntityMasterBolt masterBolt = new EntityMasterBolt(world);
                        masterBolt.aim((EntityLivingBase)caster, speed);
                        masterBolt.setCaster((EntityLivingBase)caster);
                        world.func_72838_d((Entity)masterBolt);
                    }
                    return false;
                }
                caster.func_184185_a(WizardrySounds.ENTITY_SPARK_BOMB_THROW, 0.5f, 0.4f / (caster.field_70170_p.field_73012_v.nextFloat() * 0.4f + 0.8f));
                caster.func_184811_cZ().func_185145_a(ASItems.master_bolt, 20);
                if (!world.field_72995_K) {
                    float speed = 1.5f;
                    if (!caster.field_70122_E) {
                        speed *= 3.0f;
                    }
                    EntityMasterBolt masterBolt = new EntityMasterBolt(world);
                    masterBolt.aim((EntityLivingBase)caster, speed);
                    masterBolt.setCaster((EntityLivingBase)caster);
                    world.func_72838_d((Entity)masterBolt);
                }
                return true;
            }
            if (caster.func_70093_af() && locations != null && locations.isEmpty()) {
                ASUtils.sendMessage((Entity)caster, "First, you must cast the spell without sneaking to shoot a bolt.", true, new Object[0]);
                return false;
            }
            Location destination = null;
            if (locations != null && !locations.isEmpty()) {
                destination = (Location)locations.get(locations.size() - 1);
                data.setVariable(COUNTDOWN_KEY, (Object)20);
                return true;
            }
            return false;
        }
        return false;
    }

    private static Integer update(EntityPlayer player, Integer countdown) {
        if (countdown == null) {
            return 0;
        }
        if (!player.field_70170_p.field_72995_K) {
            WizardData data = WizardData.get((EntityPlayer)player);
            List locations = (List)data.getVariable(MASTER_BOLT_LOCATIONS_KEY);
            if (locations == null || locations.isEmpty()) {
                return 0;
            }
            Location destination = (Location)locations.get(0);
            if (countdown > 1 && player.func_174818_b(destination.pos) > 2.0) {
                player.field_70737_aN = 20;
                player.func_70690_d(new PotionEffect(WizardryPotions.static_aura, 40));
                player.field_70170_p.func_175698_g(destination.pos);
                double distanceX = (double)destination.pos.func_177958_n() + 0.5 - player.field_70165_t;
                double distanceY = (double)destination.pos.func_177956_o() - player.field_70163_u;
                double distanceZ = (double)destination.pos.func_177952_p() + 0.5 - player.field_70161_v;
                double stepX = distanceX / (double)countdown.intValue();
                double stepY = distanceY / (double)countdown.intValue();
                double stepZ = distanceZ / (double)countdown.intValue();
                for (int i = 0; i < 10; ++i) {
                    double newX = player.field_70165_t + stepX;
                    double newY = player.field_70163_u + stepY;
                    double newZ = player.field_70161_v + stepZ;
                    BlockPos pos = new BlockPos(newX, newY, newZ);
                    player.func_70634_a(newX, newY, newZ);
                    if (player.field_70170_p.func_175623_d(pos)) {
                        player.field_70170_p.func_175656_a(pos, ASBlocks.lightning_block.func_176223_P());
                        BlockLightning.setProperties(player.field_70170_p, pos, (EntityLivingBase)player, 60, 3.0f);
                    }
                    if (pos != player.func_180425_c() && !(player.func_174818_b(destination.pos) < 2.0)) continue;
                    player.field_70170_p.func_72876_a((Entity)player, player.field_70165_t, player.field_70163_u, player.field_70161_v, Math.min(2.0f, player.field_70143_R * 0.05f), Settings.generalSettings.master_bolt_impact_deals_block_damage && BlockUtils.canBreakBlock((Entity)player, (World)player.field_70170_p, (BlockPos)destination.pos));
                    locations.remove(destination);
                    data.setVariable(MASTER_BOLT_LOCATIONS_KEY, null);
                    data.sync();
                    float radius = Math.max(1.0f, Math.min(3.0f, player.field_70143_R * 0.2f));
                    for (BlockPos pos1 : BlockUtils.getBlockSphere((BlockPos)player.func_180425_c(), (double)radius)) {
                        if (!player.field_70170_p.func_175623_d(pos1)) continue;
                        player.field_70170_p.func_175656_a(pos1, ASBlocks.lightning_block.func_176223_P());
                        BlockLightning.setProperties(player.field_70170_p, pos1, (EntityLivingBase)player, 90, 5.0f);
                    }
                    ASUtils.giveStackToPlayer(player, new ItemStack(ASItems.master_bolt));
                    player.field_70143_R = 0.0f;
                    return 0;
                }
            }
            if (countdown == 1) {
                locations.remove(destination);
                data.setVariable(MASTER_BOLT_LOCATIONS_KEY, null);
                data.sync();
            }
            if (countdown > 0) {
                Integer n = countdown;
                Integer n2 = countdown = Integer.valueOf(countdown - 1);
            }
        } else if (countdown == 1) {
            Wizardry.proxy.playBlinkEffect(player);
        }
        return countdown;
    }

    public boolean applicableForItem(Item item) {
        return item == ASItems.ancient_spellcraft_spell_book || item == ASItems.ancient_spellcraft_scroll;
    }
}

