/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.ancientspellcraft.spell;

import com.windanesz.ancientspellcraft.potion.PotionMetamagicEffect;
import com.windanesz.ancientspellcraft.registry.ASItems;
import electroblob.wizardry.item.ItemArtefact;
import electroblob.wizardry.registry.WizardryItems;
import electroblob.wizardry.spell.Spell;
import electroblob.wizardry.util.ParticleBuilder;
import electroblob.wizardry.util.SpellModifiers;
import java.util.Arrays;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class MetaSpellBuff
extends Spell {
    protected final Supplier<Potion>[] effects;
    protected Set<Potion> potionSet;
    protected final float r;
    protected final float g;
    protected final float b;
    protected float particleCount = 10.0f;
    public final String CHARGEUP_COOLDOWN = "chargeup_cooldown";

    @SafeVarargs
    public MetaSpellBuff(String name, float r, float g, float b, Supplier<Potion> ... effects) {
        super("ancientspellcraft", name, EnumAction.BOW, false);
        this.effects = effects;
        this.r = r;
        this.g = g;
        this.b = b;
        this.npcSelector((e, o) -> true);
    }

    public void init() {
        this.potionSet = Arrays.stream(this.effects).map(Supplier::get).collect(Collectors.toSet());
        for (Potion potion : this.potionSet) {
            if (potion.func_76403_b()) continue;
            this.addProperties(new String[]{MetaSpellBuff.getDurationKey(potion)});
        }
    }

    public boolean cast(World world, EntityPlayer caster, EnumHand hand, int ticksInUse, SpellModifiers modifiers) {
        if (!world.field_72995_K) {
            Set activePotions = caster.func_193076_bZ().keySet();
            for (Potion activePotion : activePotions) {
                for (Potion potion : this.potionSet) {
                    if (!(activePotion instanceof PotionMetamagicEffect) || potion == activePotion) continue;
                    caster.func_184589_d(activePotion);
                }
            }
            for (Potion potion : this.potionSet) {
                int bonusAmplifier;
                boolean shouldAmplify = false;
                int currentAmplifier = 0;
                boolean active = caster.func_70644_a(potion);
                if (active) {
                    currentAmplifier = caster.func_70660_b(potion).func_76458_c();
                }
                int n = active ? currentAmplifier + 1 : (bonusAmplifier = ItemArtefact.isArtefactActive((EntityPlayer)caster, (Item)ASItems.charm_metamagic_amplifier) ? 1 : 0);
                if (bonusAmplifier > 2) {
                    return false;
                }
                shouldAmplify = true;
                caster.func_184589_d(potion);
                caster.func_70690_d(new PotionEffect(potion, (int)(this.getProperty(MetaSpellBuff.getDurationKey(potion)).floatValue() * modifiers.get(WizardryItems.duration_upgrade)), bonusAmplifier, false, true));
                if (currentAmplifier != 2) continue;
                float cooldown = modifiers.get(WizardryItems.cooldown_upgrade);
                modifiers.set(WizardryItems.cooldown_upgrade, cooldown * 0.1f, true);
            }
            this.playSound(world, (EntityLivingBase)caster, ticksInUse, -1, modifiers, new String[0]);
            return true;
        }
        for (Potion potion : this.potionSet) {
            boolean active = caster.func_70644_a(potion);
            if (!active) continue;
            this.playSound(world, (EntityLivingBase)caster, ticksInUse, -1, modifiers, new String[0]);
            return true;
        }
        return false;
    }

    protected void spawnParticles(World world, EntityLivingBase caster, SpellModifiers modifiers) {
        int i = 0;
        while ((float)i < this.particleCount) {
            double x = caster.field_70165_t + world.field_73012_v.nextDouble() * 2.0 - 1.0;
            double y = caster.func_174813_aQ().field_72338_b + (double)caster.func_70047_e() - 0.5 + world.field_73012_v.nextDouble();
            double z = caster.field_70161_v + world.field_73012_v.nextDouble() * 2.0 - 1.0;
            ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.SPARKLE).pos(x, y, z).vel(0.0, 0.1, 0.0).clr(this.r, this.g, this.b).spawn(world);
            ++i;
        }
        ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.BUFF).entity((Entity)caster).clr(this.r, this.g, this.b).spawn(world);
    }

    protected static String getDurationKey(Potion potion) {
        return potion.getRegistryName().func_110623_a() + "_duration";
    }

    public boolean requiresPacket() {
        return true;
    }

    public boolean applicableForItem(Item item) {
        return item == ASItems.ancient_spell_book || item == ASItems.ancient_spellcraft_scroll;
    }

    @SideOnly(value=Side.CLIENT)
    public String getDisplayNameWithFormatting() {
        return TextFormatting.GOLD + I18n.func_135052_a((String)this.getTranslationKey(), (Object[])new Object[0]);
    }
}

