/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.ancientspellcraft.spell;

import com.windanesz.ancientspellcraft.registry.ASItems;
import electroblob.wizardry.data.IStoredVariable;
import electroblob.wizardry.data.Persistence;
import electroblob.wizardry.data.WizardData;
import electroblob.wizardry.item.SpellActions;
import electroblob.wizardry.spell.Spell;
import electroblob.wizardry.util.SpellModifiers;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.tileentity.TileEntityDispenser;
import net.minecraft.util.EnumHand;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class MetamagicProjectile
extends Spell {
    public static final IStoredVariable<Boolean> METAMAGIC_PROJECTILE = IStoredVariable.StoredVariable.ofBoolean((String)"metamagic_projectile", (Persistence)Persistence.ALWAYS).setSynced();

    public MetamagicProjectile() {
        super("ancientspellcraft", "metamagic_projectile", SpellActions.POINT_UP, false);
        WizardData.registerStoredVariables((IStoredVariable[])new IStoredVariable[]{METAMAGIC_PROJECTILE});
    }

    public boolean cast(World world, EntityPlayer caster, EnumHand hand, int ticksInUse, SpellModifiers modifiers) {
        if (WizardData.get((EntityPlayer)caster) != null) {
            WizardData data = WizardData.get((EntityPlayer)caster);
            this.playSound(world, (EntityLivingBase)caster, ticksInUse, -1, modifiers, new String[0]);
            data.setVariable(METAMAGIC_PROJECTILE, (Object)true);
            if (!world.field_72995_K) {
                data.sync();
            }
            return true;
        }
        return false;
    }

    public boolean canBeCastBy(TileEntityDispenser dispenser) {
        return false;
    }

    public boolean applicableForItem(Item item) {
        return item == ASItems.ancient_spell_book || item == ASItems.ancient_spellcraft_scroll;
    }

    @SideOnly(value=Side.CLIENT)
    public String getDisplayNameWithFormatting() {
        return TextFormatting.GOLD + I18n.func_135052_a((String)this.getTranslationKey(), (Object[])new Object[0]);
    }
}

