/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.ancientspellcraft.spell;

import com.windanesz.ancientspellcraft.block.ITemporaryBlock;
import com.windanesz.ancientspellcraft.registry.ASBlocks;
import com.windanesz.ancientspellcraft.registry.ASItems;
import electroblob.wizardry.item.SpellActions;
import electroblob.wizardry.registry.WizardryItems;
import electroblob.wizardry.spell.SpellRay;
import electroblob.wizardry.util.BlockUtils;
import electroblob.wizardry.util.ParticleBuilder;
import electroblob.wizardry.util.SpellModifiers;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class MoltenEarth
extends SpellRay {
    private static final String BLOCK_LIFETIME = "block_lifetime";

    public MoltenEarth() {
        super("ancientspellcraft", "molten_earth", SpellActions.POINT, false);
        this.ignoreLivingEntities(true);
        this.addProperties(new String[]{BLOCK_LIFETIME, "effect_radius"});
    }

    protected boolean onEntityHit(World world, Entity target, Vec3d hit, EntityLivingBase caster, Vec3d origin, int ticksInUse, SpellModifiers modifiers) {
        return false;
    }

    protected boolean onBlockHit(World world, BlockPos pos, EnumFacing side, Vec3d hit, EntityLivingBase caster, Vec3d origin, int ticksInUse, SpellModifiers modifiers) {
        pos = pos.func_177972_a(EnumFacing.DOWN);
        pos = pos.func_177972_a(side);
        if (world.field_72995_K) {
            ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.FLASH).pos((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 1.1, (double)pos.func_177952_p() + 0.5).scale(6.0f).time(20).face(EnumFacing.UP).clr(0.55f, 0.29f, 0.04f).spawn(world);
        } else {
            ITemporaryBlock.placeTemporaryBlock(caster, world, ASBlocks.CONJURED_MAGMA, pos, 600);
            BlockPos finalPos = pos;
            List list = BlockUtils.getBlockSphere((BlockPos)pos, (double)((float)this.getProperty("effect_radius").intValue() * modifiers.get(WizardryItems.blast_upgrade))).stream().filter(i -> !world.func_175623_d(i)).filter(i -> i.func_177956_o() == finalPos.func_177956_o()).collect(Collectors.toList());
            int blockLifetime = this.getProperty(BLOCK_LIFETIME).intValue();
            for (int i2 = 0; i2 < list.size(); ++i2) {
                BlockPos currPos = (BlockPos)list.get(i2);
                ITemporaryBlock.placeTemporaryBlock(caster, world, ASBlocks.CONJURED_MAGMA, currPos, 600);
            }
        }
        return true;
    }

    protected boolean onMiss(World world, EntityLivingBase caster, Vec3d origin, Vec3d direction, int ticksInUse, SpellModifiers modifiers) {
        return false;
    }

    public boolean applicableForItem(Item item) {
        return item == ASItems.ancient_spellcraft_spell_book || item == ASItems.ancient_spellcraft_scroll;
    }
}

