/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.ancientspellcraft.spell;

import com.windanesz.ancientspellcraft.registry.ASItems;
import com.windanesz.ancientspellcraft.spell.IClassSpell;
import com.windanesz.ancientspellcraft.spell.WarlockElementalSpellEffects;
import electroblob.wizardry.constants.Element;
import electroblob.wizardry.entity.EntityLevitatingBlock;
import electroblob.wizardry.item.ItemWizardArmour;
import electroblob.wizardry.item.SpellActions;
import electroblob.wizardry.registry.WizardryItems;
import electroblob.wizardry.spell.Spell;
import electroblob.wizardry.util.BlockUtils;
import electroblob.wizardry.util.ParticleBuilder;
import electroblob.wizardry.util.SpellModifiers;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.tileentity.TileEntityDispenser;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class Obliteration
extends Spell
implements IClassSpell {
    public static final String CHARGING_TIME = "charging_time";

    public Obliteration() {
        super("ancientspellcraft", "obliteration", SpellActions.SUMMON, true);
        this.soundValues(1.0f, 1.0f, 0.4f);
        this.addProperties(new String[]{"damage", "effect_radius", CHARGING_TIME});
    }

    public boolean cast(World world, EntityLiving caster, EnumHand hand, int ticksInUse, EntityLivingBase target, SpellModifiers modifiers) {
        return this.doSpellTick(world, (EntityLivingBase)caster, hand, ticksInUse, modifiers);
    }

    public boolean cast(World world, EntityPlayer caster, EnumHand hand, int ticksInUse, SpellModifiers modifiers) {
        return this.doSpellTick(world, (EntityLivingBase)caster, hand, ticksInUse, modifiers);
    }

    private boolean doSpellTick(World world, EntityLivingBase caster, EnumHand hand, int ticksInUse, SpellModifiers modifiers) {
        int chargeup = this.getProperty(CHARGING_TIME).intValue();
        Element element = this.getElementOrMagicElement(caster);
        if (ticksInUse < chargeup) {
            if (world.field_72995_K && caster.field_70173_aa % 1 == 0) {
                for (int i = 0; i < 10; ++i) {
                    ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.FLASH).entity((Entity)caster).spin(Math.min(3.0, 1.0 / ((0.1 + (double)ticksInUse) * (double)0.05f)), (double)0.006f).scale(Math.min(1.0f, 2.0f / (Math.max(1.2f, (float)ticksInUse * 0.2f) * 0.7f))).clr(WarlockElementalSpellEffects.PARTICLE_COLOURS.get(element)[world.field_73012_v.nextInt(2)]).pos(0.0, (double)(world.field_73012_v.nextFloat() + 0.2f), 0.0).time(40).spawn(world);
                }
            }
        } else if (ticksInUse == chargeup + 1) {
            if (world.field_72995_K) {
                Vec3d origin = caster.func_174791_d();
                int i = 0;
                while ((float)i < 40.0f * modifiers.get(WizardryItems.blast_upgrade)) {
                    double particleX = origin.field_72450_a - 1.0 + 2.0 * world.field_73012_v.nextDouble();
                    double particleZ = origin.field_72449_c - 1.0 + 2.0 * world.field_73012_v.nextDouble();
                    ParticleBuilder.create((ResourceLocation)WarlockElementalSpellEffects.getElementalParticle(element)).pos(particleX, origin.field_72448_b + (double)0.1f, particleZ).vel(particleX - origin.field_72450_a, 0.0, particleZ - origin.field_72449_c).clr(WarlockElementalSpellEffects.PARTICLE_COLOURS.get(element)[0]).spawn(world);
                    particleX = origin.field_72450_a - 1.0 + 2.0 * world.field_73012_v.nextDouble();
                    particleZ = origin.field_72449_c - 1.0 + 2.0 * world.field_73012_v.nextDouble();
                    ParticleBuilder.create((ResourceLocation)WarlockElementalSpellEffects.getElementalParticle(element)).pos(particleX, origin.field_72448_b + (double)0.1f, particleZ).vel(particleX - origin.field_72450_a, 0.0, particleZ - origin.field_72449_c).time(30).clr(WarlockElementalSpellEffects.PARTICLE_COLOURS.get(element)[0]).spawn(world);
                    particleX = origin.field_72450_a - 1.0 + 2.0 * world.field_73012_v.nextDouble();
                    particleZ = origin.field_72449_c - 1.0 + 2.0 * world.field_73012_v.nextDouble();
                    IBlockState block = world.func_180495_p(new BlockPos(origin.field_72450_a, origin.field_72448_b - 0.5, origin.field_72449_c));
                    if (block != null) {
                        world.func_175688_a(EnumParticleTypes.BLOCK_DUST, particleX, origin.field_72448_b + (double)0.1f, particleZ, particleX - origin.field_72450_a, 0.0, particleZ - origin.field_72449_c, new int[]{Block.func_176210_f((IBlockState)block)});
                    }
                    ++i;
                }
                ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.SPHERE).time(10).pos(origin.func_72441_c(0.0, 0.1, 0.0)).scale(this.getProperty("effect_radius").floatValue() * 0.8f).clr(WarlockElementalSpellEffects.PARTICLE_COLOURS.get(element)[0]).spawn(world);
                ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.SPHERE).time(20).pos(origin.func_72441_c(0.0, 0.1, 0.0)).scale(this.getProperty("effect_radius").floatValue() * 0.8f).clr(WarlockElementalSpellEffects.PARTICLE_COLOURS.get(element)[0]).spawn(world);
                ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.FLASH).pos(origin.func_72441_c(0.0, 0.1, 0.0)).scale(this.getProperty("effect_radius").floatValue() * 0.8f).clr(WarlockElementalSpellEffects.PARTICLE_COLOURS.get(element)[0]).face(EnumFacing.DOWN).time(60).spawn(world);
            } else {
                List list = BlockUtils.getBlockSphere((BlockPos)caster.func_180425_c(), (double)(this.getProperty("effect_radius").floatValue() * modifiers.get(WizardryItems.blast_upgrade)));
                Iterator iterator = list.iterator();
                if (iterator.hasNext()) {
                    BlockPos pos = (BlockPos)iterator.next();
                    EntityLevitatingBlock target = new EntityLevitatingBlock(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, world.func_180495_p(pos));
                    target.field_145812_b = 2;
                    target.damageMultiplier = modifiers.get("potency");
                    target.setCaster(caster);
                    double velocityFactor = 4.0;
                    double dx = target.field_70165_t - caster.func_174791_d().field_72450_a;
                    double dy = target.field_70163_u + 1.0 - caster.func_174791_d().field_72448_b;
                    double dz = target.field_70161_v - caster.func_174791_d().field_72449_c;
                    target.field_70159_w = 1.0;
                    target.field_70181_x = 1.0;
                    target.field_70179_y = 1.0;
                    world.func_72838_d((Entity)target);
                    return true;
                }
            }
        }
        return true;
    }

    boolean affectEntity(@Nullable EntityLivingBase caster, EntityLivingBase target, SpellModifiers modifiers, Element element) {
        WarlockElementalSpellEffects.affectEntity(target, element, caster, modifiers, true);
        return true;
    }

    @Override
    public ItemWizardArmour.ArmourClass getArmourClass() {
        return ItemWizardArmour.ArmourClass.WARLOCK;
    }

    public boolean applicableForItem(Item item) {
        return item == ASItems.forbidden_tome;
    }

    public boolean canBeCastBy(TileEntityDispenser dispenser) {
        return false;
    }

    public boolean canBeCastBy(EntityLiving npc, boolean override) {
        return this.canBeCastByClassNPC((EntityLivingBase)npc);
    }
}

