/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.ancientspellcraft.spell;

import com.windanesz.ancientspellcraft.AncientSpellcraft;
import com.windanesz.ancientspellcraft.item.ItemWarlockOrb;
import com.windanesz.ancientspellcraft.registry.ASBlocks;
import com.windanesz.ancientspellcraft.registry.ASDimensions;
import com.windanesz.ancientspellcraft.registry.ASItems;
import com.windanesz.ancientspellcraft.spell.IClassSpell;
import com.windanesz.ancientspellcraft.spell.PocketDimension;
import com.windanesz.ancientspellcraft.spell.WarlockElementalSpellEffects;
import com.windanesz.ancientspellcraft.util.SpellTeleporter;
import electroblob.wizardry.constants.Element;
import electroblob.wizardry.data.IStoredVariable;
import electroblob.wizardry.data.Persistence;
import electroblob.wizardry.data.WizardData;
import electroblob.wizardry.item.ItemWizardArmour;
import electroblob.wizardry.spell.Spell;
import electroblob.wizardry.util.Location;
import electroblob.wizardry.util.ParticleBuilder;
import electroblob.wizardry.util.SpellModifiers;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.tileentity.TileEntityDispenser;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public class OrbSpace
extends Spell
implements IClassSpell {
    public static final IStoredVariable<NBTTagCompound> LAST_ORB = IStoredVariable.StoredVariable.ofNBT((String)"LastOrbFromOrbSpace", (Persistence)Persistence.ALWAYS);
    public static final String ORB_SPACE_LOCATION = "OrbSpaceLocation";

    public OrbSpace() {
        super("ancientspellcraft", "orb_space", EnumAction.BLOCK, true);
        this.soundValues(0.8f, 1.2f, 0.2f);
        WizardData.registerStoredVariables((IStoredVariable[])new IStoredVariable[]{LAST_ORB});
    }

    public boolean cast(World world, EntityPlayer caster, EnumHand hand, int ticksInUse, SpellModifiers modifiers) {
        if (hand != EnumHand.MAIN_HAND) {
            return false;
        }
        if (ticksInUse == 0) {
            this.playSound(world, (EntityLivingBase)caster, ticksInUse, -1, modifiers, new String[0]);
            if (!world.field_72995_K) {
                WorldServer destinationWorld = caster.func_184102_h().func_71218_a(ASDimensions.POCKET_DIM_ID);
                OrbSpace.checkOrInitOrb(caster, (World)destinationWorld);
                return true;
            }
        }
        if (world.field_72995_K) {
            this.spawnParticles(world, (EntityLivingBase)caster, modifiers, ((ItemWarlockOrb)caster.func_184614_ca().func_77973_b()).element);
        }
        if (ticksInUse == 60 && !world.field_72995_K) {
            return OrbSpace.teleportPlayer((EntityLivingBase)caster);
        }
        return true;
    }

    public static boolean teleportPlayer(EntityLivingBase caster) {
        EntityPlayer player;
        WizardData data;
        if (caster instanceof EntityPlayer && !caster.field_70170_p.field_72995_K && (data = WizardData.get((EntityPlayer)(player = (EntityPlayer)caster))) != null) {
            NBTTagCompound location;
            if (caster.field_71093_bK == ASDimensions.POCKET_DIM_ID && data.getVariable(PocketDimension.POCKET_DIM_PREVIOUS_LOCATION) != null) {
                Location previousPos = Location.fromNBT((NBTTagCompound)((NBTTagCompound)data.getVariable(PocketDimension.POCKET_DIM_PREVIOUS_LOCATION)));
                SpellTeleporter.teleportEntity(previousPos.dimension, previousPos.pos.func_177958_n(), previousPos.pos.func_177956_o() + 1, previousPos.pos.func_177952_p(), true, player);
                return true;
            }
            data.setVariable(PocketDimension.POCKET_DIM_PREVIOUS_LOCATION, (Object)new Location(player.func_180425_c(), player.field_71093_bK).toNBT());
            ItemStack stack = player.func_184614_ca();
            if (stack.func_77942_o() && stack.func_77978_p().func_74764_b(ORB_SPACE_LOCATION) && (location = stack.func_77978_p().func_74775_l(ORB_SPACE_LOCATION)) != null) {
                BlockPos pocketPos = NBTUtil.func_186861_c((NBTTagCompound)location);
                data.setVariable(LAST_ORB, (Object)stack.serializeNBT());
                stack.func_190918_g(1);
                data.sync();
                SpellTeleporter.teleportEntity(ASDimensions.POCKET_DIM_ID, pocketPos.func_177958_n(), pocketPos.func_177956_o(), pocketPos.func_177952_p(), true, player);
                return true;
            }
        }
        return false;
    }

    protected void spawnParticles(World world, EntityLivingBase caster, SpellModifiers modifiers, Element element) {
        for (int i = 0; i < 10; ++i) {
            double dx = world.field_73012_v.nextDouble() * (double)(world.field_73012_v.nextBoolean() ? 1 : -1) * 0.1;
            double dy = world.field_73012_v.nextDouble() * (double)(world.field_73012_v.nextBoolean() ? 1 : -1) * 0.1;
            double dz = world.field_73012_v.nextDouble() * (double)(world.field_73012_v.nextBoolean() ? 1 : -1) * 0.1;
            ParticleBuilder.create((ResourceLocation)WarlockElementalSpellEffects.getElementalParticle(element)).entity((Entity)caster).clr(WarlockElementalSpellEffects.PARTICLE_COLOURS.get(element)[0]).pos(0.0, (double)(caster.field_70131_O / 2.0f), 0.0).vel(dx, dy, dz).spawn(world);
        }
    }

    public static void checkOrInitOrb(EntityPlayer player, World pocketWorld) {
        WizardData data = WizardData.get((EntityPlayer)player);
        if (data != null) {
            NBTTagCompound compound;
            NBTTagCompound nbt = player.func_184614_ca().func_77978_p();
            if (nbt == null) {
                nbt = new NBTTagCompound();
            }
            NBTTagCompound nBTTagCompound = compound = nbt.func_74764_b(ORB_SPACE_LOCATION) ? nbt.func_74775_l(ORB_SPACE_LOCATION) : null;
            if (compound == null) {
                BlockPos pocketLocation = OrbSpace.findSuitablePocketPos(pocketWorld);
                OrbSpace.createPocket(pocketLocation, pocketWorld, ((ItemWarlockOrb)player.func_184614_ca().func_77973_b()).element);
                nbt.func_74782_a(ORB_SPACE_LOCATION, (NBTBase)NBTUtil.func_186859_a((BlockPos)pocketLocation.func_177967_a(EnumFacing.UP, 6)));
                player.func_184614_ca().func_77982_d(nbt);
            }
        }
    }

    public static void createPocket(BlockPos pos, World pocketWorld, Element element) {
        pos = pos.func_177981_b(5);
        IBlockState block = ((Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("ancientspellcraft", "dimension_boundary_" + element.toString().toLowerCase()))).func_176223_P();
        for (int i = 0; i < 5; ++i) {
            int pocketSize = 2 + i;
            int pocketHeight = 3 + i;
            OrbSpace.createPlatform(pos.func_177967_a(EnumFacing.DOWN, i), pocketWorld, pocketHeight, block);
            OrbSpace.createWalls(pos, pocketWorld, pocketSize, pocketHeight, block);
            OrbSpace.createPlatform(pos.func_177967_a(EnumFacing.UP, pocketHeight + 1), pocketWorld, pocketSize, block);
            pocketWorld.func_175656_a(pos, ASBlocks.DIMENSION_FOCUS_GOLD.func_176223_P());
        }
    }

    public static void createPocket(BlockPos pos, World pocketWorld, IBlockState block, IBlockState focusBlock, int radius) {
        for (int i = 0; i < 5; ++i) {
            int pocketHeight = radius + 1;
            OrbSpace.createPlatform(pos.func_177967_a(EnumFacing.DOWN, i), pocketWorld, pocketHeight, block);
            OrbSpace.createWalls(pos, pocketWorld, radius, pocketHeight, block);
            OrbSpace.createPlatform(pos.func_177967_a(EnumFacing.UP, pocketHeight + 1), pocketWorld, radius, block);
            pocketWorld.func_175656_a(pos, focusBlock);
        }
    }

    public static BlockPos findSuitablePocketPos(World pocketWorld) {
        BlockPos currPos = new BlockPos(0, 1, 0);
        while (!OrbSpace.isSuitablePosition(currPos, pocketWorld)) {
            currPos = OrbSpace.getRandomLocationWithOffset(currPos);
        }
        return currPos;
    }

    private static boolean isSuitablePosition(BlockPos pos, World pocketWorld) {
        boolean isFree = true;
        for (BlockPos currPos : BlockPos.func_177980_a((BlockPos)pos.func_177967_a(EnumFacing.WEST, 250).func_177967_a(EnumFacing.SOUTH, 250).func_177972_a(EnumFacing.DOWN), (BlockPos)pos.func_177967_a(EnumFacing.EAST, 250).func_177967_a(EnumFacing.NORTH, 250).func_177972_a(EnumFacing.UP))) {
            if (pocketWorld.func_175623_d(currPos)) continue;
            isFree = false;
            break;
        }
        return isFree;
    }

    private static BlockPos getRandomLocationWithOffset(BlockPos origPos) {
        int i;
        Random rand = AncientSpellcraft.rand;
        int n = i = rand.nextBoolean() ? 1 : -1;
        EnumFacing facing = rand.nextBoolean() ? EnumFacing.NORTH : (rand.nextBoolean() ? EnumFacing.SOUTH : (rand.nextBoolean() ? EnumFacing.EAST : EnumFacing.WEST));
        return origPos.func_177967_a(facing, 300 * i);
    }

    private static void createPlatform(BlockPos pos, World pocketWorld, int size, IBlockState block) {
        for (BlockPos currPos : BlockPos.func_177980_a((BlockPos)pos.func_177967_a(EnumFacing.SOUTH, size).func_177967_a(EnumFacing.WEST, size), (BlockPos)pos.func_177967_a(EnumFacing.NORTH, size).func_177967_a(EnumFacing.EAST, size))) {
            pocketWorld.func_175656_a(currPos, block);
        }
    }

    private static void createWalls(BlockPos center, World pocketWorld, int width, int height, IBlockState block) {
        for (BlockPos currPos : BlockPos.func_177980_a((BlockPos)center.func_177967_a(EnumFacing.SOUTH, width).func_177967_a(EnumFacing.WEST, width), (BlockPos)center.func_177967_a(EnumFacing.NORTH, width).func_177967_a(EnumFacing.WEST, width).func_177967_a(EnumFacing.UP, height))) {
            pocketWorld.func_175656_a(currPos, block);
        }
        for (BlockPos currPos : BlockPos.func_177980_a((BlockPos)center.func_177967_a(EnumFacing.SOUTH, width).func_177967_a(EnumFacing.EAST, width), (BlockPos)center.func_177967_a(EnumFacing.NORTH, width).func_177967_a(EnumFacing.EAST, width).func_177967_a(EnumFacing.UP, height))) {
            pocketWorld.func_175656_a(currPos, block);
        }
        for (BlockPos currPos : BlockPos.func_177980_a((BlockPos)center.func_177967_a(EnumFacing.SOUTH, width).func_177967_a(EnumFacing.EAST, -width), (BlockPos)center.func_177967_a(EnumFacing.SOUTH, width).func_177967_a(EnumFacing.EAST, width).func_177967_a(EnumFacing.UP, height))) {
            pocketWorld.func_175656_a(currPos, block);
        }
        for (BlockPos currPos : BlockPos.func_177980_a((BlockPos)center.func_177967_a(EnumFacing.NORTH, width).func_177967_a(EnumFacing.WEST, -width), (BlockPos)center.func_177967_a(EnumFacing.NORTH, width).func_177967_a(EnumFacing.WEST, width).func_177967_a(EnumFacing.UP, height))) {
            pocketWorld.func_175656_a(currPos, block);
        }
    }

    @Override
    public ItemWizardArmour.ArmourClass getArmourClass() {
        return ItemWizardArmour.ArmourClass.WARLOCK;
    }

    public boolean applicableForItem(Item item) {
        return item == ASItems.forbidden_tome;
    }

    public boolean canBeCastBy(TileEntityDispenser dispenser) {
        return false;
    }

    public boolean canBeCastBy(EntityLiving npc, boolean override) {
        return false;
    }
}

