/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.ancientspellcraft.spell;

import com.windanesz.ancientspellcraft.Settings;
import com.windanesz.ancientspellcraft.integration.baubles.ASBaublesIntegration;
import com.windanesz.ancientspellcraft.item.ItemVesselOfTheWitheredOath;
import com.windanesz.ancientspellcraft.registry.ASItems;
import com.windanesz.ancientspellcraft.spell.IOverrideSpell;
import electroblob.wizardry.item.ItemArtefact;
import electroblob.wizardry.item.SpellActions;
import electroblob.wizardry.registry.WizardryItems;
import electroblob.wizardry.spell.Spell;
import electroblob.wizardry.spell.SpellAreaEffect;
import electroblob.wizardry.spell.SpellBuff;
import electroblob.wizardry.util.MagicDamage;
import electroblob.wizardry.util.ParticleBuilder;
import electroblob.wizardry.util.SpellModifiers;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class PlagueOfDarknessAS
extends SpellAreaEffect
implements IOverrideSpell {
    public PlagueOfDarknessAS() {
        super("plague_of_darkness", SpellActions.POINT_DOWN, false);
        this.alwaysSucceed(true);
        this.addProperties(new String[]{"damage", "effect_duration", "effect_strength"});
        this.soundValues(1.0f, 1.1f, 0.2f);
        this.handleNetworkIDChange((Spell)this, Settings.spellCompatSettings.plagueOfDarknessSpellNetworkID);
    }

    public boolean cast(World world, EntityPlayer caster, EnumHand hand, int ticksInUse, SpellModifiers modifiers) {
        boolean result = this.findAndAffectEntities(world, caster.func_174791_d(), (EntityLivingBase)caster, ticksInUse, modifiers);
        if (result) {
            ItemStack itemstack;
            this.playSound(world, (EntityLivingBase)caster, ticksInUse, -1, modifiers, new String[0]);
            if (ItemArtefact.isArtefactActive((EntityPlayer)caster, (Item)ASItems.charm_vessel_of_the_withered_oath) && (itemstack = ASBaublesIntegration.getEquippedArtefactStacks(caster, ItemArtefact.Type.CHARM).get(0)).func_77973_b() == ASItems.charm_vessel_of_the_withered_oath) {
                ((ItemVesselOfTheWitheredOath)itemstack.func_77973_b()).removeStoredCurse(itemstack);
                ASBaublesIntegration.setArtefactToSlot(caster, itemstack, ItemArtefact.Type.CHARM);
            }
        }
        return result;
    }

    protected boolean affectEntity(World world, Vec3d origin, @Nullable EntityLivingBase caster, EntityLivingBase target, int targetCount, int ticksInUse, SpellModifiers modifiers) {
        Potion curse;
        ItemStack itemstack;
        if (caster instanceof EntityPlayer && ItemArtefact.isArtefactActive((EntityPlayer)((EntityPlayer)caster), (Item)ASItems.charm_vessel_of_the_withered_oath) && (itemstack = ASBaublesIntegration.getEquippedArtefactStacks((EntityPlayer)caster, ItemArtefact.Type.CHARM).get(0)).func_77973_b() == ASItems.charm_vessel_of_the_withered_oath && (curse = ((ItemVesselOfTheWitheredOath)itemstack.func_77973_b()).getStoredCurse(itemstack)) != null && target != null) {
            target.func_70690_d(new PotionEffect(curse, Integer.MAX_VALUE));
        }
        if (!MagicDamage.isEntityImmune((MagicDamage.DamageType)MagicDamage.DamageType.WITHER, (Entity)target)) {
            target.func_70097_a(MagicDamage.causeDirectMagicDamage((Entity)caster, (MagicDamage.DamageType)MagicDamage.DamageType.WITHER), this.getProperty("damage").floatValue() * modifiers.get("potency"));
            target.func_70690_d(new PotionEffect(MobEffects.field_82731_v, (int)(this.getProperty("effect_duration").floatValue() * modifiers.get(WizardryItems.duration_upgrade)), this.getProperty("effect_strength").intValue() + SpellBuff.getStandardBonusAmplifier((float)modifiers.get("potency"))));
        }
        return true;
    }

    protected void spawnParticleEffect(World world, Vec3d origin, double radius, @Nullable EntityLivingBase caster, SpellModifiers modifiers) {
        int i = 0;
        while ((float)i < 40.0f * modifiers.get(WizardryItems.blast_upgrade)) {
            double particleX = origin.field_72450_a - 1.0 + 2.0 * world.field_73012_v.nextDouble();
            double particleZ = origin.field_72449_c - 1.0 + 2.0 * world.field_73012_v.nextDouble();
            ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.DARK_MAGIC).pos(particleX, origin.field_72448_b, particleZ).vel(particleX - origin.field_72450_a, 0.0, particleZ - origin.field_72449_c).clr(0.1f, 0.0f, 0.0f).spawn(world);
            particleX = origin.field_72450_a - 1.0 + 2.0 * world.field_73012_v.nextDouble();
            particleZ = origin.field_72449_c - 1.0 + 2.0 * world.field_73012_v.nextDouble();
            ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.SPARKLE).pos(particleX, origin.field_72448_b, particleZ).vel(particleX - origin.field_72450_a, 0.0, particleZ - origin.field_72449_c).time(30).clr(0.1f, 0.0f, 0.05f).spawn(world);
            particleX = origin.field_72450_a - 1.0 + 2.0 * world.field_73012_v.nextDouble();
            particleZ = origin.field_72449_c - 1.0 + 2.0 * world.field_73012_v.nextDouble();
            IBlockState block = world.func_180495_p(new BlockPos(origin.field_72450_a, origin.field_72448_b - 0.5, origin.field_72449_c));
            if (block != null) {
                world.func_175688_a(EnumParticleTypes.BLOCK_DUST, particleX, origin.field_72448_b, particleZ, particleX - origin.field_72450_a, 0.0, particleZ - origin.field_72449_c, new int[]{Block.func_176210_f((IBlockState)block)});
            }
            ++i;
        }
        ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.SPHERE).pos(origin.func_72441_c(0.0, 0.1, 0.0)).scale((float)radius * 0.8f).clr(0.8f, 0.0f, 0.05f).spawn(world);
    }
}

