/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.ancientspellcraft.spell;

import com.windanesz.ancientspellcraft.AncientSpellcraft;
import com.windanesz.ancientspellcraft.registry.ASItems;
import com.windanesz.ancientspellcraft.spell.IClassSpell;
import com.windanesz.ancientspellcraft.util.ASUtils;
import com.windanesz.ancientspellcraft.util.WizardArmourUtils;
import electroblob.wizardry.Wizardry;
import electroblob.wizardry.data.IStoredVariable;
import electroblob.wizardry.data.Persistence;
import electroblob.wizardry.data.WizardData;
import electroblob.wizardry.item.ItemWizardArmour;
import electroblob.wizardry.item.SpellActions;
import electroblob.wizardry.spell.Spell;
import electroblob.wizardry.util.NBTExtras;
import electroblob.wizardry.util.SpellModifiers;
import electroblob.wizardry.worldgen.MossifierTemplateProcessor;
import electroblob.wizardry.worldgen.MultiTemplateProcessor;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBush;
import net.minecraft.block.BlockDoor;
import net.minecraft.block.BlockGrass;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.BlockStainedHardenedClay;
import net.minecraft.block.BlockTallGrass;
import net.minecraft.block.BlockTorch;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.structure.template.ITemplateProcessor;
import net.minecraft.world.gen.structure.template.PlacementSettings;
import net.minecraft.world.gen.structure.template.Template;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.fml.common.FMLLog;

public class PocketLibrary
extends Spell
implements IClassSpell {
    public static final String FIRST_CAST = "first_cast";
    public static final String SIZE = "size";
    public static final String LIBRARY_BLOCKS = "libraryBlocks";
    public static final String CENTER_POS = "centerPos";
    public static final String SAVED_DATA = "savedData";
    public static final String LIBRARY_IS_SUMMONED = "library_is_summoned";
    public static final String PLAYER_BLOCKS = "player_blocks";
    private static final int STRUCTURE_HEIGHT = 15;
    private static final int STRUCTURE_WIDTH = 7;
    private static final int STRUCTURE_LENGTH = 7;
    private static final int STRUCTURE_WEST_OFFSET = 4;
    private static final int STRUCTURE_NORTH_OFFSET = 4;
    private static final double MAX_PACK_DISTANCE = 3.0;
    private static final int PLAYER_BLOCKS_RANGE = 3;
    private static final IStoredVariable<NBTTagCompound> POCKET_LIBRARY_DATA_NBT = IStoredVariable.StoredVariable.ofNBT((String)"pocketLibraryData", (Persistence)Persistence.ALWAYS);
    private static final ResourceLocation POCKET_LIBRARY = new ResourceLocation("ancientspellcraft", "pocket_library");

    public PocketLibrary() {
        super("ancientspellcraft", "pocket_library", SpellActions.POINT_DOWN, false);
        WizardData.registerStoredVariables((IStoredVariable[])new IStoredVariable[]{POCKET_LIBRARY_DATA_NBT});
        this.addProperties(new String[]{SIZE});
    }

    public static boolean isFirstCast(NBTTagCompound nbt) {
        return !nbt.func_74764_b(FIRST_CAST) || nbt.func_74764_b(FIRST_CAST) && nbt.func_74767_n(FIRST_CAST);
    }

    public static NBTTagCompound getData(EntityPlayer player) {
        NBTTagCompound libraryData;
        WizardData data = WizardData.get((EntityPlayer)player);
        if (data != null && (libraryData = (NBTTagCompound)data.getVariable(POCKET_LIBRARY_DATA_NBT)) != null) {
            return libraryData;
        }
        return new NBTTagCompound();
    }

    public static void saveData(EntityPlayer player, NBTTagCompound nbt) {
        WizardData data = WizardData.get((EntityPlayer)player);
        if (data != null) {
            data.setVariable(POCKET_LIBRARY_DATA_NBT, (Object)nbt);
            data.sync();
        }
    }

    private static float getBiomeMossiness(Biome biome) {
        if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.DENSE)) {
            return 0.7f;
        }
        if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.JUNGLE)) {
            return 0.7f;
        }
        if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.WET)) {
            return 0.5f;
        }
        if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.SWAMP)) {
            return 0.5f;
        }
        if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.FOREST)) {
            return 0.3f;
        }
        if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.LUSH)) {
            return 0.3f;
        }
        if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.DRY)) {
            return 0.0f;
        }
        if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.COLD)) {
            return 0.0f;
        }
        if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.DEAD)) {
            return 0.0f;
        }
        if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.WASTELAND)) {
            return 0.0f;
        }
        if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.NETHER)) {
            return 0.0f;
        }
        return 0.1f;
    }

    public static boolean isLibrarySummoned(EntityPlayer player) {
        NBTTagCompound nbt = PocketLibrary.getData(player);
        return nbt.func_74764_b(LIBRARY_IS_SUMMONED) && nbt.func_74767_n(LIBRARY_IS_SUMMONED);
    }

    public static void changeLibrarySummonedStatus(EntityPlayer player, NBTTagCompound nbt, boolean isSummoned) {
        nbt.func_74757_a(LIBRARY_IS_SUMMONED, isSummoned);
        PocketLibrary.saveData(player, nbt);
    }

    public boolean cast(World world, EntityPlayer caster, EnumHand hand, int ticksInUse, SpellModifiers modifiers) {
        if (PocketLibrary.isFirstCast(PocketLibrary.getData(caster))) {
            return this.spawnStructureInitially(caster, world);
        }
        if (PocketLibrary.isLibrarySummoned(caster)) {
            BlockPos libraryPosition = NBTUtil.func_186861_c((NBTTagCompound)PocketLibrary.getData(caster).func_74775_l(CENTER_POS));
            double distance = Math.sqrt(caster.func_180425_c().func_177951_i((Vec3i)libraryPosition));
            if (distance > 3.0) {
                ASUtils.sendMessage((Entity)caster, "spell.ancientspellcraft:pocket_library.too_far_away", true, new Object[0]);
                return false;
            }
            Wizardry.proxy.playBlinkEffect(caster);
            return this.packStructure(caster, world);
        }
        Wizardry.proxy.playBlinkEffect(caster);
        boolean success = this.spawnStructure(caster, world);
        if (!world.field_72995_K && success) {
            caster.func_70634_a((double)caster.func_180425_c().func_177958_n() + 0.5, caster.field_70163_u + 1.0, (double)caster.func_180425_c().func_177952_p() + 0.5);
        }
        return success;
    }

    @Override
    public ItemWizardArmour.ArmourClass getArmourClass() {
        return ItemWizardArmour.ArmourClass.SAGE;
    }

    public boolean applicableForItem(Item item) {
        return item == ASItems.mystic_spell_book;
    }

    private boolean spawnStructureInitially(EntityPlayer caster, World world) {
        if (!world.field_72995_K) {
            NBTTagCompound data = PocketLibrary.getData(caster);
            Template template = world.func_72860_G().func_186340_h().func_186237_a(world.func_73046_m(), POCKET_LIBRARY);
            BlockPos size = template.func_186259_a();
            if (size.func_177958_n() == 0 || size.func_177956_o() == 0 || size.func_177952_p() == 0) {
                AncientSpellcraft.logger.warn("Structure template file {} is missing or empty!", (Object)POCKET_LIBRARY);
                return false;
            }
            BlockPos origin = caster.func_180425_c().func_177967_a(EnumFacing.WEST, 4).func_177967_a(EnumFacing.NORTH, 4);
            if (!this.validateSpaceForLibrary(world, caster, origin)) {
                return false;
            }
            HashSet<BlockPos> blocksPlaced = new HashSet<BlockPos>();
            Rotation rotation = Rotation.NONE;
            PlacementSettings settings = new PlacementSettings().func_186220_a(rotation);
            ITemplateProcessor processor = this.createTemplateProcessor(world, caster, blocksPlaced);
            template.func_189960_a(world, origin, processor, settings, 18);
            if (blocksPlaced != null && blocksPlaced.size() > 0) {
                NBTTagCompound blocks = new NBTTagCompound();
                NBTExtras.storeTagSafely((NBTTagCompound)blocks, (String)LIBRARY_BLOCKS, (NBTBase)NBTExtras.listToNBT(blocksPlaced, NBTUtil::func_186859_a));
                data.func_74782_a(LIBRARY_BLOCKS, (NBTBase)blocks);
                NBTTagCompound centerPos = NBTUtil.func_186859_a((BlockPos)caster.func_180425_c());
                data.func_74782_a(CENTER_POS, (NBTBase)centerPos);
                data.func_74757_a(FIRST_CAST, false);
                PocketLibrary.changeLibrarySummonedStatus(caster, data, true);
                PocketLibrary.saveData(caster, data);
            }
            caster.func_70634_a((double)caster.func_180425_c().func_177958_n() + 0.5, caster.field_70163_u + 1.0, (double)caster.func_180425_c().func_177952_p() + 0.5);
        }
        if (world.field_72995_K) {
            this.spawnPortalParticles(world, caster);
            Wizardry.proxy.playBlinkEffect(caster);
        }
        return true;
    }

    private void spawnPortalParticles(World world, EntityPlayer player) {
        for (int i = 0; i < 10; ++i) {
            double dx = player.field_70165_t;
            double dy = player.field_70163_u + (double)(2.0f * world.field_73012_v.nextFloat());
            double dz = player.field_70161_v;
            world.func_175688_a(EnumParticleTypes.PORTAL, dx, dy, dz, world.field_73012_v.nextDouble() - 0.5, world.field_73012_v.nextDouble() - 0.5, world.field_73012_v.nextDouble() - 0.5, new int[0]);
        }
    }

    private boolean packStructure(EntityPlayer caster, World world) {
        NBTTagCompound nbtData;
        if (!world.field_72995_K && (nbtData = PocketLibrary.getData(caster)).func_74764_b(LIBRARY_BLOCKS)) {
            BlockPos centerPos = NBTUtil.func_186861_c((NBTTagCompound)nbtData.func_74775_l(CENTER_POS));
            NBTTagCompound blocksCompound = nbtData.func_74775_l(LIBRARY_BLOCKS);
            NBTTagList blocksList = blocksCompound.func_150295_c(LIBRARY_BLOCKS, 10);
            if (!blocksList.func_82582_d()) {
                HashSet blocksPlaced = new HashSet(NBTExtras.NBTToList((NBTTagList)blocksList, NBTUtil::func_186861_c));
                HashSet<BlockPos> allBlocks = new HashSet<BlockPos>(blocksPlaced);
                allBlocks.add(centerPos);
                BlockPos min = centerPos.func_177982_a(-1, 1, -1);
                BlockPos max = centerPos.func_177982_a(1, 4, 1);
                for (BlockPos pos : BlockPos.func_177980_a((BlockPos)min, (BlockPos)max)) {
                    allBlocks.add(pos);
                }
                ArrayList<TileEntity> tileEntityList = new ArrayList<TileEntity>();
                NBTTagList tileEntityDataList = new NBTTagList();
                NBTTagList blockDataList = new NBTTagList();
                NBTTagList playerBlocksList = new NBTTagList();
                this.collectTileEntityData(world, allBlocks, tileEntityList);
                this.collectBlockStateData(world, allBlocks, centerPos, blockDataList);
                NBTTagCompound savedData = new NBTTagCompound();
                savedData.func_74782_a("Blocks", (NBTBase)blockDataList);
                savedData.func_74782_a("PlayerBlocks", (NBTBase)playerBlocksList);
                for (TileEntity tileEntity : tileEntityList) {
                    if (!this.isAllowedTile(tileEntity)) continue;
                    try {
                        NBTTagCompound tileNBT = tileEntity.func_189515_b(new NBTTagCompound());
                        BlockPos relativePos = tileEntity.func_174877_v().func_177973_b((Vec3i)centerPos);
                        tileNBT.func_74768_a("x", relativePos.func_177958_n());
                        tileNBT.func_74768_a("y", relativePos.func_177956_o());
                        tileNBT.func_74768_a("z", relativePos.func_177952_p());
                        tileEntityDataList.func_74742_a((NBTBase)tileNBT);
                    }
                    catch (Exception e) {
                        FMLLog.log.error("A TileEntity type {} has thrown an exception trying to write state. It will not persist. Report this to the mod author", (Object)tileEntity.getClass().getName(), (Object)e);
                    }
                }
                savedData.func_74782_a("TileEntities", (NBTBase)tileEntityDataList);
                nbtData.func_74782_a(SAVED_DATA, (NBTBase)savedData);
                PocketLibrary.changeLibrarySummonedStatus(caster, nbtData, false);
                PocketLibrary.saveData(caster, nbtData);
                this.removeLibraryBlocks(world, allBlocks);
            }
        }
        return true;
    }

    private void collectTileEntityData(World world, Set<BlockPos> blocksPlaced, List<TileEntity> tileEntityList) {
        for (BlockPos pos : blocksPlaced) {
            TileEntity tile = world.func_175625_s(pos);
            if (!this.isAllowedTile(tile)) continue;
            tileEntityList.add(tile);
        }
    }

    private void collectBlockStateData(World world, Set<BlockPos> blocksPlaced, BlockPos centerPos, NBTTagList blockDataList) {
        for (BlockPos pos : blocksPlaced) {
            NBTTagCompound blockData = new NBTTagCompound();
            NBTTagCompound state = new NBTTagCompound();
            TileEntity tileEntity = world.func_175625_s(pos);
            if (tileEntity == null || this.isAllowedTile(tileEntity)) {
                NBTUtil.func_190009_a((NBTTagCompound)state, (IBlockState)world.func_180495_p(pos));
            } else {
                NBTUtil.func_190009_a((NBTTagCompound)state, (IBlockState)Blocks.field_150350_a.func_176223_P());
            }
            blockData.func_74782_a("state", (NBTBase)state);
            blockData.func_74782_a("pos", (NBTBase)NBTUtil.func_186859_a((BlockPos)pos.func_177973_b((Vec3i)centerPos)));
            blockDataList.func_74742_a((NBTBase)blockData);
        }
    }

    private void removeLibraryBlocks(World world, Set<BlockPos> blocksPlaced) {
        if (!blocksPlaced.isEmpty()) {
            TileEntity tileEntity;
            for (BlockPos pos : blocksPlaced) {
                tileEntity = world.func_175625_s(pos);
                if (tileEntity == null || !this.isAllowedTile(tileEntity)) continue;
                world.func_175713_t(pos);
            }
            for (BlockPos pos : blocksPlaced) {
                if (!(world.func_180495_p(pos).func_177230_c() instanceof BlockTorch)) continue;
                world.func_175698_g(pos);
            }
            for (BlockPos pos : blocksPlaced) {
                if (!(world.func_180495_p(pos).func_177230_c() instanceof BlockDoor) || world.func_180495_p(pos).func_177229_b((IProperty)BlockDoor.field_176523_O) != BlockDoor.EnumDoorHalf.LOWER) continue;
                world.func_175698_g(pos);
            }
            for (BlockPos pos : blocksPlaced) {
                tileEntity = world.func_175625_s(pos);
                if (tileEntity != null && !this.isAllowedTile(tileEntity)) continue;
                world.func_175698_g(pos);
            }
        }
    }

    private boolean spawnStructure(EntityPlayer caster, World world) {
        if (!world.field_72995_K) {
            BlockPos origin = caster.func_180425_c().func_177967_a(EnumFacing.WEST, 4).func_177967_a(EnumFacing.NORTH, 4);
            if (!this.validateSpaceForLibrary(world, caster, origin)) {
                return false;
            }
            NBTTagCompound nbtData = PocketLibrary.getData(caster);
            if (nbtData.func_74764_b(SAVED_DATA)) {
                BlockPos currPos;
                BlockPos relativePos;
                IBlockState oldState;
                HashSet<BlockPos> blocksPlaced = new HashSet<BlockPos>();
                BlockPos centerPos = caster.func_180425_c();
                NBTTagCompound savedData = nbtData.func_74775_l(SAVED_DATA);
                NBTTagList blockTagList = savedData.func_150295_c("Blocks", 10);
                NBTTagList playerBlockTagList = savedData.func_150295_c("PlayerBlocks", 10);
                ArrayList blockList = new ArrayList();
                blockTagList.forEach(entry -> {
                    if (entry instanceof NBTTagCompound) {
                        blockList.add((NBTTagCompound)entry);
                    }
                });
                ArrayList playerBlockList = new ArrayList();
                playerBlockTagList.forEach(entry -> {
                    if (entry instanceof NBTTagCompound) {
                        playerBlockList.add((NBTTagCompound)entry);
                    }
                });
                ArrayList remainingBlockList = new ArrayList(blockList);
                for (Object compound : blockList) {
                    oldState = NBTUtil.func_190008_d((NBTTagCompound)compound.func_74775_l("state"));
                    if (oldState.func_177230_c() instanceof BlockTorch || oldState.func_177230_c() instanceof BlockDoor) continue;
                    relativePos = NBTUtil.func_186861_c((NBTTagCompound)compound.func_74775_l("pos"));
                    currPos = relativePos.func_177971_a((Vec3i)centerPos);
                    if (this.canSafelyReplace(world, currPos)) {
                        world.func_175656_a(currPos, oldState);
                        blocksPlaced.add(currPos);
                    }
                    remainingBlockList.remove(compound);
                }
                for (Object compound : remainingBlockList) {
                    oldState = NBTUtil.func_190008_d((NBTTagCompound)compound.func_74775_l("state"));
                    relativePos = NBTUtil.func_186861_c((NBTTagCompound)compound.func_74775_l("pos"));
                    currPos = relativePos.func_177971_a((Vec3i)centerPos);
                    if (!this.canSafelyReplace(world, currPos)) continue;
                    world.func_175656_a(currPos, oldState);
                    blocksPlaced.add(currPos);
                }
                for (Object compound : playerBlockList) {
                    oldState = NBTUtil.func_190008_d((NBTTagCompound)compound.func_74775_l("state"));
                    relativePos = NBTUtil.func_186861_c((NBTTagCompound)compound.func_74775_l("pos"));
                    currPos = relativePos.func_177971_a((Vec3i)centerPos);
                    if (!this.canSafelyReplace(world, currPos)) continue;
                    world.func_175656_a(currPos, oldState);
                    blocksPlaced.add(currPos);
                }
                NBTTagList tileTagList = savedData.func_150295_c("TileEntities", 10);
                for (NBTBase nbtBase : tileTagList) {
                    if (!(nbtBase instanceof NBTTagCompound)) continue;
                    NBTTagCompound tileNBT = (NBTTagCompound)nbtBase;
                    BlockPos relativePos2 = new BlockPos(tileNBT.func_74762_e("x"), tileNBT.func_74762_e("y"), tileNBT.func_74762_e("z"));
                    BlockPos currPos2 = relativePos2.func_177971_a((Vec3i)centerPos);
                    world.func_175690_a(currPos2, TileEntity.func_190200_a((World)world, (NBTTagCompound)tileNBT));
                }
                NBTTagCompound blocks = new NBTTagCompound();
                if (blocksPlaced != null && blocksPlaced.size() > 0) {
                    NBTExtras.storeTagSafely((NBTTagCompound)blocks, (String)LIBRARY_BLOCKS, (NBTBase)NBTExtras.listToNBT(blocksPlaced, NBTUtil::func_186859_a));
                    nbtData.func_74782_a(LIBRARY_BLOCKS, (NBTBase)blocks);
                    NBTTagCompound centerPosNBT = NBTUtil.func_186859_a((BlockPos)caster.func_180425_c());
                    nbtData.func_74782_a(CENTER_POS, (NBTBase)centerPosNBT);
                    nbtData.func_74757_a(FIRST_CAST, false);
                    PocketLibrary.changeLibrarySummonedStatus(caster, nbtData, true);
                    PocketLibrary.saveData(caster, nbtData);
                }
            }
        }
        return true;
    }

    private boolean isAllowedTile(TileEntity tile) {
        return tile != null;
    }

    private int getStructureRadius() {
        return Math.max(7, 7) + 2;
    }

    private boolean canSafelyReplace(World world, BlockPos pos) {
        if (world.func_175623_d(pos)) {
            return true;
        }
        Block block = world.func_180495_p(pos).func_177230_c();
        return block instanceof BlockGrass || block instanceof BlockTallGrass || block instanceof BlockBush;
    }

    private boolean validateSpaceForLibrary(World world, EntityPlayer player, BlockPos origin) {
        BlockPos endCorner = origin.func_177967_a(EnumFacing.UP, 15).func_177967_a(EnumFacing.SOUTH, 7).func_177967_a(EnumFacing.EAST, 7);
        for (BlockPos currTestPos : BlockPos.func_177980_a((BlockPos)origin, (BlockPos)endCorner)) {
            if (!world.func_175678_i(currTestPos)) {
                player.func_146105_b((ITextComponent)new TextComponentTranslation("spell.ancientspellcraft:pocket_library.no_room", new Object[0]), true);
                return false;
            }
            if (this.canSafelyReplace(world, currTestPos)) continue;
            player.func_146105_b((ITextComponent)new TextComponentTranslation("spell.ancientspellcraft:pocket_library.cannot_replace", new Object[0]), true);
            return false;
        }
        return true;
    }

    private ITemplateProcessor createTemplateProcessor(World world, EntityPlayer player, Set<BlockPos> blocksPlaced) {
        EnumDyeColor color = this.determineRoofColor(player);
        Biome biome = world.func_180494_b(player.func_180425_c());
        float mossiness = PocketLibrary.getBiomeMossiness(biome);
        return new MultiTemplateProcessor(true, new ITemplateProcessor[]{(w, p, i) -> i.field_186243_b.func_177230_c() instanceof BlockStainedHardenedClay ? new Template.BlockInfo(i.field_186242_a, i.field_186243_b.func_177226_a((IProperty)BlockStainedHardenedClay.field_176581_a, (Comparable)color), i.field_186244_c) : i, new MossifierTemplateProcessor(mossiness, 0.04f, player.func_180425_c().func_177956_o() + 1), (w, p, i) -> {
            if (i.field_186243_b.func_177230_c() != Blocks.field_150350_a) {
                blocksPlaced.add(p);
            }
            return i;
        }, (w, p, i) -> {
            if (i.field_186243_b.func_177230_c() == Blocks.field_150350_a) {
                return i;
            }
            if (this.canSafelyReplace(w, p)) {
                return i;
            }
            return new Template.BlockInfo(i.field_186242_a, Blocks.field_150350_a.func_176223_P(), i.field_186244_c);
        }});
    }

    private EnumDyeColor determineRoofColor(EntityPlayer player) {
        EnumDyeColor color = EnumDyeColor.values()[player.field_70170_p.field_73012_v.nextInt(EnumDyeColor.values().length)];
        switch (WizardArmourUtils.getFullSetElementForClass((EntityLivingBase)player, ItemWizardArmour.ArmourClass.SAGE)) {
            case MAGIC: {
                color = EnumDyeColor.GRAY;
                break;
            }
            case FIRE: {
                color = EnumDyeColor.ORANGE;
                break;
            }
            case ICE: {
                color = EnumDyeColor.LIGHT_BLUE;
                break;
            }
            case LIGHTNING: {
                color = EnumDyeColor.BLUE;
                break;
            }
            case NECROMANCY: {
                color = EnumDyeColor.PURPLE;
                break;
            }
            case EARTH: {
                color = EnumDyeColor.BROWN;
                break;
            }
            case SORCERY: {
                color = EnumDyeColor.CYAN;
                break;
            }
            case HEALING: {
                color = EnumDyeColor.YELLOW;
            }
        }
        return color;
    }

    private Set<BlockPos> findPlayerPlacedBlocks(World world, BlockPos centerPos, int range, Set<BlockPos> existingBlocks) {
        HashSet<BlockPos> playerBlocks = new HashSet<BlockPos>();
        BlockPos minPos = centerPos.func_177982_a(-range, -range, -range);
        BlockPos maxPos = centerPos.func_177982_a(range, range, range);
        for (BlockPos pos : BlockPos.func_177980_a((BlockPos)minPos, (BlockPos)maxPos)) {
            Block block;
            if (world.func_175623_d(pos) || existingBlocks.contains(pos) || (block = world.func_180495_p(pos).func_177230_c()) instanceof BlockLeaves || block instanceof BlockGrass || block instanceof BlockTallGrass || block instanceof BlockBush) continue;
            playerBlocks.add(pos);
        }
        return playerBlocks;
    }
}

