/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.ancientspellcraft.spell;

import com.windanesz.ancientspellcraft.registry.ASItems;
import com.windanesz.ancientspellcraft.util.ASUtils;
import electroblob.wizardry.item.SpellActions;
import electroblob.wizardry.registry.WizardryItems;
import electroblob.wizardry.spell.Spell;
import electroblob.wizardry.util.EntityUtils;
import electroblob.wizardry.util.ParticleBuilder;
import electroblob.wizardry.util.SpellModifiers;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.item.Item;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;

public class RevealUndead
extends Spell {
    public RevealUndead() {
        super("ancientspellcraft", "reveal_undead", SpellActions.POINT_UP, false);
        this.addProperties(new String[]{"effect_radius", "effect_duration"});
    }

    public boolean cast(World world, EntityPlayer caster, EnumHand hand, int ticksInUse, SpellModifiers modifiers) {
        double radius = this.getProperty("effect_radius").floatValue() * modifiers.get(WizardryItems.blast_upgrade);
        int count = 0;
        for (EntityLivingBase entity : EntityUtils.getEntitiesWithinRadius((double)radius, (double)caster.field_70165_t, (double)caster.field_70163_u, (double)caster.field_70161_v, (World)world, EntityLivingBase.class)) {
            if (!ASUtils.isEntityConsideredUndead((Entity)entity)) continue;
            entity.func_70690_d(new PotionEffect(MobEffects.field_188423_x, (int)((float)this.getProperty("effect_duration").intValue() * modifiers.get(WizardryItems.duration_upgrade)), 0));
            ++count;
        }
        if (!world.field_72995_K) {
            caster.func_146105_b((ITextComponent)new TextComponentTranslation("spell.ancientspellcraft:reveal_undead.count", new Object[]{count}), false);
        } else {
            Vec3d origin = caster.func_174824_e(1.0f);
            for (int i = 0; i < 30; ++i) {
                double x = origin.field_72450_a - 1.0 + world.field_73012_v.nextDouble() * 2.0;
                double y = origin.field_72448_b - 0.25 + world.field_73012_v.nextDouble() * 0.5;
                double z = origin.field_72449_c - 1.0 + world.field_73012_v.nextDouble() * 2.0;
                ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.SPARKLE).pos(x, y, z).vel(0.0, 0.1, 0.0).fade(0, 0, 0).spin((double)0.3f, (double)0.03f).clr(250, 248, 205).spawn(world);
            }
        }
        return true;
    }

    public boolean applicableForItem(Item item) {
        return item == ASItems.ancient_spellcraft_spell_book || item == ASItems.ancient_spellcraft_scroll;
    }
}

