/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.ancientspellcraft.spell;

import com.windanesz.ancientspellcraft.block.BlockArcaneAnvil;
import com.windanesz.ancientspellcraft.registry.ASItems;
import com.windanesz.ancientspellcraft.spell.IClassSpell;
import com.windanesz.ancientspellcraft.spell.IRunicHammerSpell;
import com.windanesz.ancientspellcraft.util.ASUtils;
import electroblob.wizardry.item.ItemWizardArmour;
import electroblob.wizardry.spell.SpellRay;
import electroblob.wizardry.util.EntityUtils;
import electroblob.wizardry.util.RayTracer;
import electroblob.wizardry.util.SpellModifiers;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;

public abstract class RunesmithingSpellBase
extends SpellRay
implements IRunicHammerSpell,
IClassSpell {
    public RunesmithingSpellBase(String name, EnumAction action, boolean isContinuous) {
        super("ancientspellcraft", name, action, isContinuous);
    }

    protected boolean onEntityHit(World world, Entity target, Vec3d hit, @Nullable EntityLivingBase caster, Vec3d origin, int ticksInUse, SpellModifiers modifiers) {
        ASUtils.sendMessage((Entity)caster, "generic.ancientspellcraft:runic_hammer_spell.no_anvil", true, new Object[0]);
        return false;
    }

    protected boolean onBlockHit(World world, BlockPos pos, EnumFacing side, Vec3d hit, @Nullable EntityLivingBase caster, Vec3d origin, int ticksInUse, SpellModifiers modifiers) {
        if (caster instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)caster;
            if (RunesmithingSpellBase.isAnvilBlock(world, pos)) {
                return this.doAnvilEffect(world, pos, side, hit, caster, origin, ticksInUse, modifiers);
            }
            ASUtils.sendMessage((Entity)player, "generic.ancientspellcraft:runic_hammer_spell.no_anvil", true, new Object[0]);
            return false;
        }
        return true;
    }

    public abstract boolean doAnvilEffect(World var1, BlockPos var2, EnumFacing var3, Vec3d var4, @Nullable EntityLivingBase var5, Vec3d var6, int var7, SpellModifiers var8);

    protected boolean onMiss(World world, @Nullable EntityLivingBase caster, Vec3d origin, Vec3d direction, int ticksInUse, SpellModifiers modifiers) {
        double range = this.getRange(world, origin, direction, caster, ticksInUse, modifiers);
        Vec3d endpoint = origin.func_178787_e(direction.func_186678_a(range));
        RayTraceResult rayTrace = RayTracer.rayTrace((World)world, (Vec3d)origin, (Vec3d)endpoint, (float)this.aimAssist, (boolean)this.hitLiquids, (boolean)this.ignoreUncollidables, (boolean)false, Entity.class, (Predicate)(this.ignoreLivingEntities ? EntityUtils::isLiving : RayTracer.ignoreEntityFilter((Entity)caster)));
        if (rayTrace != null && rayTrace.field_72313_a == RayTraceResult.Type.BLOCK && RunesmithingSpellBase.isAnvilBlock(world, rayTrace.func_178782_a())) {
            return false;
        }
        if (caster instanceof EntityPlayer && !world.field_72995_K) {
            ((EntityPlayer)caster).func_146105_b((ITextComponent)new TextComponentTranslation("generic.ancientspellcraft:runic_hammer_spell.no_anvil", new Object[0]), true);
        }
        return true;
    }

    @Override
    public ItemWizardArmour.ArmourClass getArmourClass() {
        return ItemWizardArmour.ArmourClass.BATTLEMAGE;
    }

    public boolean applicableForItem(Item item) {
        return item == ASItems.runic_plate;
    }

    public static boolean isAnvilBlock(World world, BlockPos pos) {
        return world.func_180495_p(pos).func_177230_c() instanceof BlockArcaneAnvil;
    }
}

