/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.ancientspellcraft.spell;

import com.windanesz.ancientspellcraft.registry.ASItems;
import com.windanesz.ancientspellcraft.registry.ASPotions;
import com.windanesz.ancientspellcraft.spell.IClassSpell;
import com.windanesz.ancientspellcraft.spell.WarlockElementalSpellEffects;
import electroblob.wizardry.Wizardry;
import electroblob.wizardry.constants.Element;
import electroblob.wizardry.data.IStoredVariable;
import electroblob.wizardry.data.Persistence;
import electroblob.wizardry.data.WizardData;
import electroblob.wizardry.item.ItemWizardArmour;
import electroblob.wizardry.item.SpellActions;
import electroblob.wizardry.registry.WizardryPotions;
import electroblob.wizardry.spell.SpellRay;
import electroblob.wizardry.util.ParticleBuilder;
import electroblob.wizardry.util.SpellModifiers;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.potion.PotionEffect;
import net.minecraft.tileentity.TileEntityDispenser;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class ScryingOrb
extends SpellRay
implements IClassSpell {
    public static final IStoredVariable<BlockPos> SCRYING_ORB_POS = IStoredVariable.StoredVariable.ofBlockPos((String)"ancientSpellcraftScryingOrbPos", (Persistence)Persistence.NEVER).setSynced();
    public static final IStoredVariable<Boolean> IS_SCRYING = IStoredVariable.StoredVariable.ofBoolean((String)"ancientSpellcraftIsScryingOrb", (Persistence)Persistence.NEVER).setSynced();

    public ScryingOrb() {
        super("ancientspellcraft", "scrying_orb", SpellActions.POINT, false);
        WizardData.registerStoredVariables((IStoredVariable[])new IStoredVariable[]{SCRYING_ORB_POS, IS_SCRYING});
        this.addProperties(new String[]{"effect_duration"});
    }

    public static boolean isScrying(EntityPlayer player) {
        Boolean b = (Boolean)WizardData.get((EntityPlayer)player).getVariable(IS_SCRYING);
        return b != null && b != false;
    }

    public static BlockPos getBlockPos(EntityPlayer player) {
        return WizardData.get((EntityPlayer)player).getVariable(SCRYING_ORB_POS) != null ? (BlockPos)WizardData.get((EntityPlayer)player).getVariable(SCRYING_ORB_POS) : BlockPos.field_177992_a;
    }

    public static void setScrying(EntityPlayer player, boolean scrying) {
        WizardData data = WizardData.get((EntityPlayer)player);
        data.setVariable(IS_SCRYING, (Object)scrying);
        data.sync();
    }

    public boolean cast(World world, EntityPlayer caster, EnumHand hand, int ticksInUse, SpellModifiers modifiers) {
        if (!world.field_72995_K && ScryingOrb.isScrying(caster)) {
            ScryingOrb.setScrying(caster, false);
            caster.func_184589_d(WizardryPotions.sixth_sense);
            caster.func_184589_d(ASPotions.astral_projection);
            return true;
        }
        if (!caster.func_70093_af()) {
            if (ScryingOrb.getBlockPos(caster) != null) {
                BlockPos pos = ScryingOrb.getBlockPos(caster);
                if (world.field_72995_K) {
                    int[] colours = WarlockElementalSpellEffects.PARTICLE_COLOURS.get(Element.MAGIC);
                    ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.FLASH).scale(3.5f).pos((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o(), (double)pos.func_177952_p() + 0.5).scale(0.35f).time(160).clr(colours[0]).spawn(world);
                    ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.FLASH).scale(2.5f).pos((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o(), (double)pos.func_177952_p() + 0.5).scale(0.35f).time(160).clr(colours[0]).spawn(world);
                    double r = 0.12;
                    for (int i = 0; i < 3; ++i) {
                        double x = r * (world.field_73012_v.nextDouble() * 2.0 - 1.0);
                        double y = r * (world.field_73012_v.nextDouble() * 2.0 - 1.0);
                        double z = r * (world.field_73012_v.nextDouble() * 2.0 - 1.0);
                        ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.DUST).pos((double)pos.func_177958_n() + 0.5, (double)((float)pos.func_177956_o() + 0.5f), (double)pos.func_177952_p() + 0.5).vel(x * -0.03, -0.02, z * -0.03).scale(2.0f).time(160 + world.field_73012_v.nextInt(8)).clr(colours[0]).fade(colours[1]).spawn(world);
                    }
                } else {
                    caster.func_70690_d(new PotionEffect(ASPotions.astral_projection, 120, 0));
                    caster.func_70690_d(new PotionEffect(WizardryPotions.sixth_sense, 120, 0));
                }
                ScryingOrb.setScrying(caster, true);
            }
            return true;
        }
        Vec3d look = caster.func_70040_Z();
        Vec3d origin = new Vec3d(caster.field_70165_t, caster.field_70163_u + (double)caster.func_70047_e() - 0.25, caster.field_70161_v);
        if (!this.isContinuous && world.field_72995_K && !Wizardry.proxy.isFirstPerson((Entity)caster)) {
            origin = origin.func_178787_e(look.func_186678_a(1.2));
        }
        if (!this.shootSpell(world, origin, look, (EntityLivingBase)caster, ticksInUse, modifiers)) {
            return false;
        }
        if (this.casterSwingsArm(world, (EntityLivingBase)caster, hand, ticksInUse, modifiers)) {
            caster.func_184609_a(hand);
        }
        this.playSound(world, (EntityLivingBase)caster, ticksInUse, -1, modifiers, new String[0]);
        return true;
    }

    protected boolean onEntityHit(World world, Entity target, Vec3d hit, EntityLivingBase caster, Vec3d origin, int ticksInUse, SpellModifiers modifiers) {
        return false;
    }

    protected boolean onBlockHit(World world, BlockPos pos, EnumFacing side, Vec3d hit, EntityLivingBase caster, Vec3d origin, int ticksInUse, SpellModifiers modifiers) {
        EntityPlayer player = (EntityPlayer)caster;
        WizardData data = WizardData.get((EntityPlayer)player);
        data.setVariable(SCRYING_ORB_POS, (Object)pos.func_177967_a(side, 2));
        data.sync();
        return true;
    }

    protected boolean onMiss(World world, EntityLivingBase caster, Vec3d origin, Vec3d direction, int ticksInUse, SpellModifiers modifiers) {
        return true;
    }

    protected void spawnParticleRay(World world, Vec3d origin, Vec3d direction, EntityLivingBase caster, double distance) {
        if (caster != null) {
            ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.BEAM).entity((Entity)caster).pos(origin.func_178788_d(caster.func_174791_d())).length(distance).clr(WarlockElementalSpellEffects.PARTICLE_COLOURS.get(Element.MAGIC)[0]).scale(MathHelper.func_76126_a((float)((float)caster.field_70173_aa * 0.2f)) * 0.1f + 1.4f).spawn(world);
        } else {
            ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.BEAM).pos(origin).target(origin.func_178787_e(direction.func_186678_a(distance))).clr(WarlockElementalSpellEffects.PARTICLE_COLOURS.get(Element.MAGIC)[0]).scale(MathHelper.func_76126_a((float)((float)Wizardry.proxy.getThePlayer().field_70173_aa * 0.2f)) * 0.1f + 1.4f).spawn(world);
        }
    }

    @Override
    public ItemWizardArmour.ArmourClass getArmourClass() {
        return ItemWizardArmour.ArmourClass.WARLOCK;
    }

    public boolean applicableForItem(Item item) {
        return item == ASItems.forbidden_tome;
    }

    public boolean canBeCastBy(TileEntityDispenser dispenser) {
        return false;
    }

    public boolean canBeCastBy(EntityLiving npc, boolean override) {
        return this.canBeCastByClassNPC((EntityLivingBase)npc);
    }
}

