/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.ancientspellcraft.spell;

import com.windanesz.ancientspellcraft.block.BlockSageLectern;
import com.windanesz.ancientspellcraft.registry.ASItems;
import com.windanesz.ancientspellcraft.spell.IClassSpell;
import com.windanesz.ancientspellcraft.tileentity.TileSageLectern;
import com.windanesz.ancientspellcraft.util.ASUtils;
import electroblob.wizardry.block.BlockReceptacle;
import electroblob.wizardry.constants.Element;
import electroblob.wizardry.item.ItemWizardArmour;
import electroblob.wizardry.spell.SpellRay;
import electroblob.wizardry.util.EntityUtils;
import electroblob.wizardry.util.ParticleBuilder;
import electroblob.wizardry.util.RayTracer;
import electroblob.wizardry.util.SpellModifiers;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;

public abstract class SpellLecternInteract
extends SpellRay
implements IClassSpell {
    public static final String MAX_DISTANCE_FROM_LECTERN = "max_distance_from_lectern";

    public SpellLecternInteract(String name, EnumAction action, boolean isContinuous) {
        super("ancientspellcraft", name, action, isContinuous);
        this.soundValues(1.0f, 1.1f, 0.2f);
    }

    protected void spawnLecternParticles(World world, int ticksInUse, BlockPos pos, int minTicks) {
        int[] colours = (int[])BlockReceptacle.PARTICLE_COLOURS.get(Element.MAGIC);
        if (world.field_72995_K && ticksInUse < minTicks) {
            int i = 0;
            while ((double)i < (double)ticksInUse * 0.1 * 2.0) {
                ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.DUST).pos((double)((float)pos.func_177958_n() + world.field_73012_v.nextFloat()), (double)(pos.func_177956_o() + 1), (double)((float)pos.func_177952_p() + world.field_73012_v.nextFloat())).vel(0.0, 0.05 + (double)world.field_73012_v.nextFloat() * 0.1, 0.0).clr(colours[1]).fade(colours[2]).time(40).shaded(false).spawn(world);
                ++i;
            }
        }
    }

    protected void spawnParticle(World world, double x, double y, double z, double vx, double vy, double vz) {
    }

    protected boolean onEntityHit(World world, Entity target, Vec3d hit, @Nullable EntityLivingBase caster, Vec3d origin, int ticksInUse, SpellModifiers modifiers) {
        ASUtils.sendMessage((Entity)caster, "generic.ancientspellcraft:spell_lectern_interact.no_lectern", true, new Object[0]);
        return false;
    }

    protected boolean onMiss(World world, @Nullable EntityLivingBase caster, Vec3d origin, Vec3d direction, int ticksInUse, SpellModifiers modifiers) {
        double range = this.getRange(world, origin, direction, caster, ticksInUse, modifiers);
        Vec3d endpoint = origin.func_178787_e(direction.func_186678_a(range));
        RayTraceResult rayTrace = RayTracer.rayTrace((World)world, (Vec3d)origin, (Vec3d)endpoint, (float)this.aimAssist, (boolean)this.hitLiquids, (boolean)this.ignoreUncollidables, (boolean)false, Entity.class, (Predicate)(this.ignoreLivingEntities ? EntityUtils::isLiving : RayTracer.ignoreEntityFilter((Entity)caster)));
        if (rayTrace != null && rayTrace.field_72313_a == RayTraceResult.Type.BLOCK && SpellLecternInteract.isLecternBlock(world, rayTrace.func_178782_a())) {
            return false;
        }
        if (caster instanceof EntityPlayer && !world.field_72995_K) {
            ((EntityPlayer)caster).func_146105_b((ITextComponent)new TextComponentTranslation("generic.ancientspellcraft:spell_lectern_interact.no_lectern", new Object[0]), true);
        }
        return true;
    }

    @Override
    public ItemWizardArmour.ArmourClass getArmourClass() {
        return ItemWizardArmour.ArmourClass.SAGE;
    }

    public boolean applicableForItem(Item item) {
        return item == ASItems.mystic_spell_book;
    }

    public static boolean isLecternBlock(World world, BlockPos pos) {
        return world.func_180495_p(pos).func_177230_c() instanceof BlockSageLectern;
    }

    public boolean persistsOnBookRemoval() {
        return false;
    }

    public void persistentEffectOnLecternClick(TileSageLectern lectern, EntityPlayer player) {
    }
}

