/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.ancientspellcraft.spell;

import electroblob.wizardry.Wizardry;
import electroblob.wizardry.item.SpellActions;
import electroblob.wizardry.spell.SpellRay;
import electroblob.wizardry.util.ParticleBuilder;
import electroblob.wizardry.util.SpellModifiers;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class SpellPlasmaCutter
extends SpellRay {
    public SpellPlasmaCutter() {
        super("ancientspellcraft", "plasma_cutter", SpellActions.POINT, true);
    }

    protected boolean onEntityHit(World world, Entity target, Vec3d hit, @Nullable EntityLivingBase caster, Vec3d origin, int ticksInUse, SpellModifiers modifiers) {
        return false;
    }

    protected boolean onBlockHit(World world, BlockPos pos, EnumFacing side, Vec3d hit, @Nullable EntityLivingBase caster, Vec3d origin, int ticksInUse, SpellModifiers modifiers) {
        if (!world.field_72995_K && caster instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)caster;
            IBlockState state = world.func_180495_p(pos);
            float hardness = state.func_185887_b(world, pos);
            if (hardness >= 0.0f) {
                double breakSpeed;
                String tool = state.func_177230_c().getHarvestTool(state);
                if (tool != null) {
                    ItemStack toolStack;
                    switch (tool) {
                        case "pickaxe": {
                            toolStack = new ItemStack(Items.field_151046_w);
                            break;
                        }
                        case "shovel": {
                            toolStack = new ItemStack(Items.field_151047_v);
                            break;
                        }
                        case "axe": {
                            toolStack = new ItemStack(Items.field_151056_x);
                            break;
                        }
                        default: {
                            toolStack = ItemStack.field_190927_a;
                        }
                    }
                    breakSpeed = !toolStack.func_190926_b() ? (double)toolStack.func_150997_a(state) * 5.0 : (double)player.getDigSpeed(state, pos) * 5.0;
                } else {
                    breakSpeed = (double)player.getDigSpeed(state, pos) * 5.0;
                }
                double potency = modifiers.get("potency");
                System.out.println("breakSpeed: " + (breakSpeed *= potency) + ", potency: " + potency);
                int extraMinTicks = 0;
                if (potency >= 1.0 && potency < 1.15) {
                    extraMinTicks = 15;
                } else if (potency >= 1.15 && potency < 1.3) {
                    extraMinTicks = 10;
                } else if (potency >= 1.45 && potency <= 1.6) {
                    extraMinTicks = 5;
                }
                int baseMinTicks = 5;
                int maxTicks = 20;
                double base = 20.0;
                int minTicks = 5 + extraMinTicks;
                int ticksToBreak = (int)Math.ceil(Math.max((double)minTicks, Math.min(20.0, (double)hardness * 20.0 / breakSpeed)));
                System.out.println("minTicks: " + minTicks + ", ticksToBreak: " + ticksToBreak);
                if ((player.field_70173_aa + pos.hashCode()) % ticksToBreak == 0) {
                    world.func_175655_b(pos, true);
                }
            }
        }
        return true;
    }

    protected boolean onMiss(World world, @Nullable EntityLivingBase caster, Vec3d origin, Vec3d direction, int ticksInUse, SpellModifiers modifiers) {
        if (world.field_72995_K) {
            this.spawnParticleRay(world, origin, direction, caster, 6.0);
        }
        return false;
    }

    protected void spawnParticleRay(World world, Vec3d origin, Vec3d direction, EntityLivingBase caster, double distance) {
        if (caster != null) {
            ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.BEAM).entity((Entity)caster).pos(origin.func_178788_d(caster.func_174791_d())).length(distance).clr(6976435).scale(MathHelper.func_76126_a((float)((float)caster.field_70173_aa * 0.2f)) * 0.1f + 1.4f).spawn(world);
        } else {
            ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.BEAM).pos(origin).target(origin.func_178787_e(direction.func_186678_a(distance))).clr(1.0f, 0.6f + 0.3f * world.field_73012_v.nextFloat(), 0.2f).scale(MathHelper.func_76126_a((float)((float)Wizardry.proxy.getThePlayer().field_70173_aa * 0.2f)) * 0.1f + 1.4f).spawn(world);
        }
    }
}

