/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.ancientspellcraft.spell;

import com.windanesz.ancientspellcraft.registry.ASItems;
import com.windanesz.ancientspellcraft.spell.IClassSpell;
import electroblob.wizardry.block.BlockTransportationStone;
import electroblob.wizardry.data.IVariable;
import electroblob.wizardry.data.WizardData;
import electroblob.wizardry.item.ItemArtefact;
import electroblob.wizardry.item.ItemWizardArmour;
import electroblob.wizardry.item.SpellActions;
import electroblob.wizardry.spell.SpellRay;
import electroblob.wizardry.spell.Transportation;
import electroblob.wizardry.util.BlockUtils;
import electroblob.wizardry.util.Location;
import electroblob.wizardry.util.ParticleBuilder;
import electroblob.wizardry.util.SpellModifiers;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeChunkManager;

public class TeleportObject
extends SpellRay
implements IClassSpell {
    public TeleportObject() {
        super("ancientspellcraft", "teleport_object", SpellActions.POINT, false);
        this.soundValues(1.0f, 1.1f, 0.2f);
    }

    protected boolean onEntityHit(World world, Entity target, Vec3d hit, EntityLivingBase caster, Vec3d origin, int ticksInUse, SpellModifiers modifiers) {
        return false;
    }

    protected boolean onBlockHit(World world, BlockPos blockPosToMove, EnumFacing side, Vec3d hit, EntityLivingBase caster, Vec3d origin, int ticksInUse, SpellModifiers modifiers) {
        if (caster instanceof EntityPlayer && !world.field_72995_K) {
            WizardData data = WizardData.get((EntityPlayer)((EntityPlayer)caster));
            List locations = (List)data.getVariable((IVariable)Transportation.LOCATIONS_KEY);
            if (locations == null || locations.isEmpty()) {
                ((EntityPlayer)caster).func_146105_b((ITextComponent)new TextComponentTranslation("spell.ebwizardry:transportation.undefined", new Object[0]), true);
                return false;
            }
            Location destination = (Location)locations.get(locations.size() - 1);
            if (!BlockTransportationStone.testForCircle((World)world, (BlockPos)destination.pos)) {
                ((EntityPlayer)caster).func_146105_b((ITextComponent)new TextComponentTranslation("spell.ebwizardry:transportation.missing", new Object[0]), true);
                return false;
            }
            if (!world.func_175697_a(blockPosToMove, 1)) {
                ForgeChunkManager.Ticket tk = ForgeChunkManager.requestTicket((Object)"ancientspellcraft", (World)world, (ForgeChunkManager.Type)ForgeChunkManager.Type.NORMAL);
                ForgeChunkManager.forceChunk((ForgeChunkManager.Ticket)tk, (ChunkPos)new ChunkPos(destination.pos));
            }
            BlockPos targetPos = new BlockPos((Vec3i)destination.pos);
            if (ItemArtefact.isArtefactActive((EntityPlayer)((EntityPlayer)caster), (Item)ASItems.charm_hoarders_orb)) {
                boolean foundSpot = false;
                for (int i = 0; i < 20; ++i) {
                    BlockPos randomPos = BlockUtils.findNearbyFloorSpace((World)world, (BlockPos)destination.pos, (int)4, (int)1, (boolean)false);
                    if (randomPos == null || randomPos.equals((Object)destination.pos) || randomPos.equals((Object)destination.pos.func_177977_b()) || world.func_180495_p(randomPos.func_177977_b()).func_177230_c() instanceof BlockTransportationStone) continue;
                    targetPos = randomPos;
                    foundSpot = true;
                    break;
                }
                if (!foundSpot) {
                    ((EntityPlayer)caster).func_146105_b((ITextComponent)new TextComponentTranslation("spell.ancientspellcraft:teleport_object.no_free_pos", new Object[0]), true);
                    return false;
                }
            }
            if (BlockUtils.canBlockBeReplaced((World)world, (BlockPos)targetPos)) {
                IBlockState state = world.func_180495_p(blockPosToMove);
                TileEntity tileEntity = world.func_175625_s(blockPosToMove);
                if (!BlockUtils.isBlockUnbreakable((World)world, (BlockPos)blockPosToMove) && BlockUtils.canBreakBlock((Entity)caster, (World)world, (BlockPos)blockPosToMove)) {
                    world.func_175698_g(targetPos);
                    world.func_175656_a(targetPos, state);
                    if (tileEntity != null) {
                        NBTTagCompound tileData = tileEntity.serializeNBT();
                        world.func_175690_a(targetPos, TileEntity.func_190200_a((World)world, (NBTTagCompound)tileData));
                        world.func_175713_t(blockPosToMove);
                    }
                    world.func_175698_g(blockPosToMove);
                }
            } else {
                ((EntityPlayer)caster).func_146105_b((ITextComponent)new TextComponentTranslation("spell.ancientspellcraft:teleport_object.obstructed", new Object[0]), true);
            }
        }
        return true;
    }

    protected boolean onMiss(World world, EntityLivingBase caster, Vec3d origin, Vec3d direction, int ticksInUse, SpellModifiers modifiers) {
        return true;
    }

    protected void spawnParticle(World world, double x, double y, double z, double vx, double vy, double vz) {
        ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.DARK_MAGIC).pos(x, y, z).clr(5709413).spawn(world);
        ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.DARK_MAGIC).pos(x, y, z).clr(2430473).spawn(world);
        ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.SPARKLE).pos(x, y, z).time(12 + world.field_73012_v.nextInt(8)).clr(740160).spawn(world);
    }

    @Override
    public ItemWizardArmour.ArmourClass getArmourClass() {
        return ItemWizardArmour.ArmourClass.SAGE;
    }

    public boolean applicableForItem(Item item) {
        return item == ASItems.mystic_spell_book;
    }
}

