/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.ancientspellcraft.spell;

import com.windanesz.ancientspellcraft.registry.ASItems;
import electroblob.wizardry.constants.Constants;
import electroblob.wizardry.item.SpellActions;
import electroblob.wizardry.spell.SpellRay;
import electroblob.wizardry.util.ParticleBuilder;
import electroblob.wizardry.util.SpellModifiers;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.potion.PotionEffect;
import net.minecraft.tileentity.TileEntityDispenser;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class Transference
extends SpellRay {
    public static final String TRANSFERRED_EFFECTS = "transferred_effects";

    public Transference() {
        super("ancientspellcraft", "transference", SpellActions.POINT, false);
        this.addProperties(new String[]{TRANSFERRED_EFFECTS});
    }

    public boolean canBeCastBy(TileEntityDispenser dispenser) {
        return false;
    }

    protected boolean onEntityHit(World world, Entity target, Vec3d hit, @Nullable EntityLivingBase caster, Vec3d origin, int ticksInUse, SpellModifiers modifiers) {
        if (caster != null && target instanceof EntityLivingBase) {
            List positivePotions = new ArrayList<PotionEffect>(caster.func_70651_bq());
            positivePotions.removeIf(p -> p.func_188419_a().func_76398_f());
            positivePotions.removeIf(p -> p.func_76459_b() > 100000);
            if (!world.field_72995_K) {
                if (positivePotions.isEmpty()) {
                    return false;
                }
                int bonusEffects = (int)((modifiers.get("potency") - 1.0f) / Constants.POTENCY_INCREASE_PER_TIER + 0.5f) - 1;
                int n = this.getProperty(TRANSFERRED_EFFECTS).intValue() + bonusEffects;
                if (n <= 1) {
                    n = 1;
                }
                Collections.shuffle(positivePotions);
                positivePotions = positivePotions.subList(0, positivePotions.size() < n ? positivePotions.size() : n);
                positivePotions.forEach(p -> caster.func_184589_d(p.func_188419_a()));
                positivePotions.forEach(arg_0 -> ((EntityLivingBase)((EntityLivingBase)target)).func_70690_d(arg_0));
            } else {
                ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.BUFF).entity((Entity)caster).clr(1.0f, 1.0f, 0.3f).spawn(world);
            }
        }
        return true;
    }

    protected boolean onBlockHit(World world, BlockPos pos, EnumFacing side, Vec3d hit, @Nullable EntityLivingBase caster, Vec3d origin, int ticksInUse, SpellModifiers modifiers) {
        return false;
    }

    protected boolean onMiss(World world, @Nullable EntityLivingBase caster, Vec3d origin, Vec3d direction, int ticksInUse, SpellModifiers modifiers) {
        return true;
    }

    protected void spawnParticle(World world, double x, double y, double z, double vx, double vy, double vz) {
        ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.BUFF).pos(x, y, z).clr(0.1f, 0.0f, 0.0f).spawn(world);
        ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.SPARKLE).pos(x, y, z).time(12 + world.field_73012_v.nextInt(8)).clr(0.9f, 0.9f, 0.85f).spawn(world);
    }

    public boolean applicableForItem(Item item) {
        return item == ASItems.ancient_spellcraft_spell_book || item == ASItems.ancient_spellcraft_scroll;
    }
}

