/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.ancientspellcraft.spell;

import com.google.common.collect.ImmutableMap;
import com.windanesz.ancientspellcraft.registry.ASSpells;
import com.windanesz.ancientspellcraft.util.SpellcastUtils;
import electroblob.wizardry.constants.Element;
import electroblob.wizardry.registry.WizardryPotions;
import electroblob.wizardry.util.EntityUtils;
import electroblob.wizardry.util.MagicDamage;
import electroblob.wizardry.util.ParticleBuilder;
import electroblob.wizardry.util.SpellModifiers;
import java.util.Map;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;

public class WarlockElementalSpellEffects {
    public static Map<Element, int[]> PARTICLE_COLOURS = ImmutableMap.builder().put((Object)Element.MAGIC, (Object)new int[]{16515843, 0x400101, 10300659, 0xFFFFFF}).put((Object)Element.FIRE, (Object)new int[]{16750080, 11220483, 13641472, 0xFFFFFF}).put((Object)Element.ICE, (Object)new int[]{0xFAFEFF, 15465727, 11924735, 0xFFFFFF}).put((Object)Element.LIGHTNING, (Object)new int[]{0xFFFFFF, 3095890, 2249844, 0xFFFFFF}).put((Object)Element.NECROMANCY, (Object)new int[]{5638507, 5505364, 3679078, 0xFFFFFF}).put((Object)Element.EARTH, (Object)new int[]{7710728, 7241748, 7953448, 0xFFFFFF}).put((Object)Element.SORCERY, (Object)new int[]{5695630, 3179108, 1484406, 0xFFFFFF}).put((Object)Element.HEALING, (Object)new int[]{0xFFFFF6, 16774814, 16769379, 0xFFFFFF}).build();
    private static final Map<Element, MagicDamage.DamageType> DAMAGE_TYPE = ImmutableMap.builder().put((Object)Element.MAGIC, (Object)MagicDamage.DamageType.MAGIC).put((Object)Element.FIRE, (Object)MagicDamage.DamageType.FIRE).put((Object)Element.ICE, (Object)MagicDamage.DamageType.FROST).put((Object)Element.LIGHTNING, (Object)MagicDamage.DamageType.SHOCK).put((Object)Element.NECROMANCY, (Object)MagicDamage.DamageType.WITHER).put((Object)Element.EARTH, (Object)MagicDamage.DamageType.POISON).put((Object)Element.SORCERY, (Object)MagicDamage.DamageType.FORCE).put((Object)Element.HEALING, (Object)MagicDamage.DamageType.RADIANT).build();
    public static ImmutableMap<Element, ResourceLocation> ELEMENTAL_PARTICLES = ImmutableMap.builder().put((Object)Element.MAGIC, (Object)ParticleBuilder.Type.FLASH).put((Object)Element.FIRE, (Object)ParticleBuilder.Type.MAGIC_FIRE).put((Object)Element.ICE, (Object)ParticleBuilder.Type.SNOW).put((Object)Element.LIGHTNING, (Object)ParticleBuilder.Type.SPARK).put((Object)Element.NECROMANCY, (Object)ParticleBuilder.Type.SPARKLE).put((Object)Element.EARTH, (Object)ParticleBuilder.Type.LEAF).put((Object)Element.SORCERY, (Object)ParticleBuilder.Type.FLASH).put((Object)Element.HEALING, (Object)ParticleBuilder.Type.SPARKLE).build();

    public static MagicDamage.DamageType getDamageType(Element element) {
        return DAMAGE_TYPE.get(element);
    }

    public static ResourceLocation getElementalParticle(Element element) {
        return (ResourceLocation)ELEMENTAL_PARTICLES.get((Object)element);
    }

    public static void affectEntity(EntityLivingBase target, Element element, EntityLivingBase caster, SpellModifiers modifiers, boolean damageEntity) {
        World world = target.field_70170_p;
        switch (element) {
            case MAGIC: {
                if (!damageEntity || MagicDamage.isEntityImmune((MagicDamage.DamageType)MagicDamage.DamageType.MAGIC, (Entity)target)) break;
                EntityUtils.attackEntityWithoutKnockback((Entity)target, (DamageSource)MagicDamage.causeDirectMagicDamage((Entity)caster, (MagicDamage.DamageType)MagicDamage.DamageType.MAGIC), (float)4.0f);
                break;
            }
            case FIRE: {
                if (!target.func_70027_ad()) {
                    target.func_70015_d(4);
                }
                if (!damageEntity || MagicDamage.isEntityImmune((MagicDamage.DamageType)MagicDamage.DamageType.FIRE, (Entity)target)) break;
                EntityUtils.attackEntityWithoutKnockback((Entity)target, (DamageSource)MagicDamage.causeDirectMagicDamage((Entity)caster, (MagicDamage.DamageType)MagicDamage.DamageType.FIRE), (float)2.0f);
                break;
            }
            case ICE: {
                target.func_70690_d(new PotionEffect(WizardryPotions.frost, 60));
                if (!damageEntity || MagicDamage.isEntityImmune((MagicDamage.DamageType)MagicDamage.DamageType.FROST, (Entity)target)) break;
                EntityUtils.attackEntityWithoutKnockback((Entity)target, (DamageSource)MagicDamage.causeDirectMagicDamage((Entity)caster, (MagicDamage.DamageType)MagicDamage.DamageType.FROST), (float)2.0f);
                break;
            }
            case LIGHTNING: {
                if (target.field_70170_p.field_72995_K) {
                    ParticleBuilder.spawnShockParticles((World)target.field_70170_p, (double)target.field_70165_t, (double)(target.field_70163_u + (double)(target.field_70131_O / 2.0f)), (double)target.field_70161_v);
                }
                if (!damageEntity || MagicDamage.isEntityImmune((MagicDamage.DamageType)MagicDamage.DamageType.SHOCK, (Entity)target)) break;
                target.func_70097_a(MagicDamage.causeDirectMagicDamage((Entity)caster, (MagicDamage.DamageType)MagicDamage.DamageType.SHOCK), 3.0f);
                break;
            }
            case NECROMANCY: {
                if (damageEntity && !MagicDamage.isEntityImmune((MagicDamage.DamageType)MagicDamage.DamageType.WITHER, (Entity)target)) {
                    EntityUtils.attackEntityWithoutKnockback((Entity)target, (DamageSource)MagicDamage.causeDirectMagicDamage((Entity)caster, (MagicDamage.DamageType)MagicDamage.DamageType.WITHER), (float)2.0f);
                }
                if (target.func_70644_a(MobEffects.field_82731_v)) break;
                target.func_70690_d(new PotionEffect(MobEffects.field_82731_v, 40, 1));
                break;
            }
            case EARTH: {
                if (damageEntity && !MagicDamage.isEntityImmune((MagicDamage.DamageType)MagicDamage.DamageType.POISON, (Entity)target)) {
                    EntityUtils.attackEntityWithoutKnockback((Entity)target, (DamageSource)MagicDamage.causeDirectMagicDamage((Entity)caster, (MagicDamage.DamageType)MagicDamage.DamageType.POISON), (float)2.0f);
                }
                if (target.func_70644_a(MobEffects.field_76436_u)) break;
                target.func_70690_d(new PotionEffect(MobEffects.field_76436_u, 60));
                break;
            }
            case SORCERY: {
                if (MagicDamage.isEntityImmune((MagicDamage.DamageType)MagicDamage.DamageType.FORCE, (Entity)target)) break;
                modifiers.set("potency", damageEntity ? 0.8f : 0.0f, false);
                if (caster instanceof EntityPlayer) {
                    SpellcastUtils.proxyTargetedSpell(world, caster, (Entity)target, ASSpells.force_shove, modifiers);
                    break;
                }
                SpellcastUtils.tryCastSpellAsMob((EntityLiving)caster, ASSpells.force_shove, target);
                break;
            }
            case HEALING: {
                if (damageEntity && !MagicDamage.isEntityImmune((MagicDamage.DamageType)MagicDamage.DamageType.RADIANT, (Entity)target)) {
                    EntityUtils.attackEntityWithoutKnockback((Entity)target, (DamageSource)MagicDamage.causeDirectMagicDamage((Entity)caster, (MagicDamage.DamageType)MagicDamage.DamageType.RADIANT), (float)2.0f);
                }
                if (!target.func_70644_a(MobEffects.field_76440_q)) {
                    target.func_70690_d(new PotionEffect(MobEffects.field_76440_q, 40));
                }
                if (!target.func_70662_br() || target.func_70027_ad()) break;
                target.func_70015_d(4);
            }
        }
    }
}

