/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.ancientspellcraft.tileentity;

import com.windanesz.ancientspellcraft.tileentity.AbstractMagicFlameTileEntity;
import com.windanesz.ancientspellcraft.util.ASUtils;
import com.windanesz.ancientspellcraft.util.SpellTeleporter;
import electroblob.wizardry.util.EntityUtils;
import electroblob.wizardry.util.Location;
import electroblob.wizardry.util.MagicDamage;
import electroblob.wizardry.util.ParticleBuilder;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.MobEffects;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;

public class TileEntityTeleportationFlame
extends AbstractMagicFlameTileEntity {
    private Location targetLocation = null;
    private static final int TELEPORT_TICKS_REQUIRED = 20;
    private boolean hasValidFireplace = true;
    private int teleportCounter = 0;
    private static final double COLLISION_RADIUS = 0.5;

    @Override
    protected void spawnParticles() {
        boolean hasCollidingEntities = this.teleportCounter > 0;
        int baseParticles = hasCollidingEntities ? 5 : 3;
        for (int i = 0; i < baseParticles; ++i) {
            double x = (double)this.field_174879_c.func_177958_n() + 0.2 + this.field_145850_b.field_73012_v.nextDouble() * 0.6;
            double y = (double)this.field_174879_c.func_177956_o() + 0.2 + this.field_145850_b.field_73012_v.nextDouble() * 0.6;
            double z = (double)this.field_174879_c.func_177952_p() + 0.2 + this.field_145850_b.field_73012_v.nextDouble() * 0.6;
            ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.SPARKLE).pos(x, y, z).vel(0.0, this.field_145850_b.field_73012_v.nextDouble() * 0.05, 0.0).time(10 + this.field_145850_b.field_73012_v.nextInt(10)).clr(0.0f, 0.7f + this.field_145850_b.field_73012_v.nextFloat() * 0.3f, 0.2f).spawn(this.field_145850_b);
            if (!hasCollidingEntities || this.field_145850_b.field_73012_v.nextInt(2) != 0) continue;
            ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.SPARKLE).pos(x, y, z).vel(0.0, this.field_145850_b.field_73012_v.nextDouble() * 0.55, 0.0).time(10 + this.field_145850_b.field_73012_v.nextInt(10)).clr(0.0f, 0.7f + this.field_145850_b.field_73012_v.nextFloat() * 0.3f, 0.2f).spawn(this.field_145850_b);
        }
    }

    public Location getTargetLocation() {
        return this.targetLocation;
    }

    public void setTargetLocation(Location location) {
        this.targetLocation = location;
        this.func_70296_d();
    }

    @Override
    public MagicDamage.DamageType getDamageType() {
        return MagicDamage.DamageType.FIRE;
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (!this.field_145850_b.field_72995_K) {
            double posZ;
            double posY;
            double posX = (double)this.field_174879_c.func_177958_n() + 0.5;
            List entities = EntityUtils.getEntitiesWithinRadius((double)1.0, (double)posX, (double)(posY = (double)this.field_174879_c.func_177956_o() + 0.5), (double)(posZ = (double)this.field_174879_c.func_177952_p() + 0.5), (World)this.field_145850_b, EntityLivingBase.class);
            if (!entities.isEmpty()) {
                EntityLivingBase entity = (EntityLivingBase)entities.get(0);
                this.processEntityCollision(entity);
            } else {
                this.resetTeleportCounter();
            }
        }
    }

    private boolean processEntityCollision(EntityLivingBase entity) {
        if (entity == null) {
            return false;
        }
        entity.func_70015_d(2);
        if (this.targetLocation == null || !this.hasValidFireplace) {
            if (!this.field_145850_b.field_72995_K && this.ticksExisted % 40 == 0) {
                ASUtils.sendMessage((Entity)entity, "spell.ancientspellcraft:teleportation_flame.no_target", true, new Object[0]);
            }
            return false;
        }
        if (entity.func_70644_a(MobEffects.field_76440_q)) {
            this.teleportCounter = 0;
            return false;
        }
        ++this.teleportCounter;
        if (this.teleportCounter >= 20) {
            this.resetTeleportCounter();
            if (!this.hasValidFireplace()) {
                ASUtils.sendMessage((Entity)entity, "spell.ancientspellcraft:teleportation_flame.no_fireplace", true, new Object[0]);
            }
            SpellTeleporter.teleportPlayerOrMob(entity, this.targetLocation);
            return true;
        }
        entity.func_70015_d(2);
        return false;
    }

    public void resetTeleportCounter() {
        this.teleportCounter = 0;
    }

    public boolean hasValidFireplace() {
        return this.hasValidFireplace;
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        if (this.targetLocation != null) {
            compound.func_74782_a("targetLocation", (NBTBase)this.targetLocation.toNBT());
        }
        return super.func_189515_b(compound);
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        if (compound.func_74764_b("targetLocation")) {
            this.setTargetLocation(Location.fromNBT((NBTTagCompound)compound.func_74775_l("targetLocation")));
        } else {
            this.targetLocation = null;
        }
        super.func_145839_a(compound);
    }
}

