/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.ancientspellcraft.tileentity;

import com.windanesz.ancientspellcraft.tileentity.AbstractMagicFlameTileEntity;
import electroblob.wizardry.util.AllyDesignationSystem;
import electroblob.wizardry.util.BlockUtils;
import electroblob.wizardry.util.EntityUtils;
import electroblob.wizardry.util.MagicDamage;
import electroblob.wizardry.util.ParticleBuilder;
import java.util.Comparator;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class TileEntityWildfireFlame
extends AbstractMagicFlameTileEntity {
    private float spreadRadius = 3.0f;
    private int movementCooldown = 0;
    private static final int MOVEMENT_COOLDOWN_MAX = 1;
    private boolean entityNearby = false;
    protected boolean canSpreadFire = false;

    @Override
    protected void spawnParticles() {
        int particleCount = this.entityNearby ? 6 : 1;
        for (int i = 0; i < particleCount; ++i) {
            double x = (double)this.field_174879_c.func_177958_n() + 0.2 + this.field_145850_b.field_73012_v.nextDouble() * 0.6;
            double y = (double)this.field_174879_c.func_177956_o() + 0.2 + this.field_145850_b.field_73012_v.nextDouble() * 0.6;
            double z = (double)this.field_174879_c.func_177952_p() + 0.2 + this.field_145850_b.field_73012_v.nextDouble() * 0.6;
            ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.SPARKLE).pos(x, y, z).vel(0.0, this.field_145850_b.field_73012_v.nextDouble() * 0.05, 0.0).time(10 + this.field_145850_b.field_73012_v.nextInt(10)).clr(0.9f + this.field_145850_b.field_73012_v.nextFloat() * 0.1f, 0.2f + this.field_145850_b.field_73012_v.nextFloat() * 0.2f, 0.0f).spawn(this.field_145850_b);
            if (this.field_145850_b.field_73012_v.nextInt(2) == 0) {
                this.field_145850_b.func_175688_a(EnumParticleTypes.FLAME, x, y, z, (this.field_145850_b.field_73012_v.nextDouble() - 0.5) * 0.05, this.field_145850_b.field_73012_v.nextDouble() * 0.05, (this.field_145850_b.field_73012_v.nextDouble() - 0.5) * 0.05, new int[0]);
            }
            if (this.field_145850_b.field_73012_v.nextInt(10) == 0) {
                this.field_145850_b.func_175688_a(EnumParticleTypes.LAVA, x, y, z, 0.0, 0.0, 0.0, new int[0]);
            }
            if (!this.entityNearby || this.field_145850_b.field_73012_v.nextInt(5) != 0) continue;
            this.field_145850_b.func_175688_a(EnumParticleTypes.SMOKE_LARGE, x, y + 0.3, z, (this.field_145850_b.field_73012_v.nextDouble() - 0.5) * 0.02, this.field_145850_b.field_73012_v.nextDouble() * 0.08, (this.field_145850_b.field_73012_v.nextDouble() - 0.5) * 0.02, new int[0]);
        }
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (!this.field_145850_b.field_72995_K) {
            this.checkAndMoveTowardsTarget();
        }
    }

    private void checkAndMoveTowardsTarget() {
        BlockPos downPos;
        int dx;
        if (this.movementCooldown > 0) {
            --this.movementCooldown;
            return;
        }
        AxisAlignedBB searchArea = new AxisAlignedBB((double)((float)this.field_174879_c.func_177958_n() - this.spreadRadius), (double)(this.field_174879_c.func_177956_o() - 1), (double)((float)this.field_174879_c.func_177952_p() - this.spreadRadius), (double)((float)this.field_174879_c.func_177958_n() + this.spreadRadius), (double)(this.field_174879_c.func_177956_o() + 2), (double)((float)this.field_174879_c.func_177952_p() + this.spreadRadius));
        List nearbyEntities = this.field_145850_b.func_72872_a(EntityLivingBase.class, searchArea);
        boolean isCollidingWithEntity = false;
        for (EntityLivingBase entity2 : nearbyEntities) {
            AxisAlignedBB entityBB = entity2.func_174813_aQ();
            if (!entityBB.func_72326_a(new AxisAlignedBB(this.field_174879_c))) continue;
            isCollidingWithEntity = true;
            break;
        }
        if (isCollidingWithEntity) {
            this.entityNearby = true;
            this.movementCooldown = 1;
            return;
        }
        EntityLivingBase caster = this.getCaster();
        List hostileEntities = EntityUtils.getEntitiesWithinRadius((double)this.spreadRadius, (double)((double)this.field_174879_c.func_177958_n() + 0.5), (double)((double)this.field_174879_c.func_177956_o() + 0.5), (double)((double)this.field_174879_c.func_177952_p() + 0.5), (World)this.field_145850_b, EntityLivingBase.class);
        hostileEntities.removeIf(entity -> {
            if (entity == caster) {
                return true;
            }
            if (caster == null) {
                return false;
            }
            if (entity.func_70045_F()) {
                return true;
            }
            float height = entity.field_70131_O;
            float width = entity.field_70130_N;
            if (height * width < 0.2f) {
                return true;
            }
            if (height > 3.0f) {
                return true;
            }
            return AllyDesignationSystem.isAllied((EntityLivingBase)caster, (EntityLivingBase)entity);
        });
        if (hostileEntities.isEmpty()) {
            this.entityNearby = false;
            this.movementCooldown = 1;
            return;
        }
        this.entityNearby = true;
        EntityLivingBase target = hostileEntities.stream().min(Comparator.comparingDouble(e -> e.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5))).orElse(null);
        if (target == null) {
            this.movementCooldown = 1;
            return;
        }
        Vec3d targetVec = new Vec3d(target.field_70165_t, target.field_70163_u, target.field_70161_v);
        Vec3d currentVec = new Vec3d((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5);
        Vec3d direction = targetVec.func_178788_d(currentVec).func_72432_b();
        int n = direction.field_72450_a > 0.2 ? 1 : (dx = direction.field_72450_a < -0.2 ? -1 : 0);
        int dz = direction.field_72449_c > 0.2 ? 1 : (direction.field_72449_c < -0.2 ? -1 : 0);
        BlockPos nextPos = this.field_174879_c.func_177982_a(dx, 0, dz);
        if (target.field_70163_u > (double)this.field_174879_c.func_177956_o() + 0.5) {
            BlockPos upPos = nextPos.func_177984_a();
            if ((this.field_145850_b.func_175623_d(upPos) || BlockUtils.canBlockBeReplaced((World)this.field_145850_b, (BlockPos)upPos, (boolean)true) || this.field_145850_b.func_180495_p(upPos).func_177230_c() == Blocks.field_150329_H || this.field_145850_b.func_180495_p(upPos).func_177230_c() == Blocks.field_150398_cm) && this.field_145850_b.func_180495_p(upPos.func_177977_b()).func_185896_q()) {
                nextPos = upPos;
            }
        } else if (target.field_70163_u < (double)this.field_174879_c.func_177956_o() - 0.5 && (this.field_145850_b.func_175623_d(downPos = nextPos.func_177977_b()) || BlockUtils.canBlockBeReplaced((World)this.field_145850_b, (BlockPos)downPos, (boolean)true) || this.field_145850_b.func_180495_p(downPos).func_177230_c() == Blocks.field_150329_H || this.field_145850_b.func_180495_p(downPos).func_177230_c() == Blocks.field_150398_cm) && this.field_145850_b.func_180495_p(downPos.func_177977_b()).func_185896_q()) {
            nextPos = downPos;
        }
        boolean canPlaceAtNext = false;
        if ((this.field_145850_b.func_175623_d(nextPos) || BlockUtils.canBlockBeReplaced((World)this.field_145850_b, (BlockPos)nextPos, (boolean)true) || this.field_145850_b.func_180495_p(nextPos).func_177230_c() == Blocks.field_150329_H || this.field_145850_b.func_180495_p(nextPos).func_177230_c() == Blocks.field_150398_cm) && this.field_145850_b.func_180495_p(nextPos.func_177977_b()).func_185896_q()) {
            canPlaceAtNext = true;
        } else if (this.field_145850_b.func_180495_p(nextPos).func_185896_q() && (this.field_145850_b.func_175623_d(nextPos.func_177984_a()) || BlockUtils.canBlockBeReplaced((World)this.field_145850_b, (BlockPos)nextPos.func_177984_a(), (boolean)true))) {
            nextPos = nextPos.func_177984_a();
            canPlaceAtNext = true;
        }
        if (canPlaceAtNext) {
            IBlockState currentState = this.field_145850_b.func_180495_p(this.field_174879_c);
            NBTTagCompound tileData = this.func_189515_b(new NBTTagCompound());
            if ((this.field_145850_b.func_175623_d(nextPos) || BlockUtils.canBlockBeReplaced((World)this.field_145850_b, (BlockPos)nextPos, (boolean)true) || this.field_145850_b.func_180495_p(nextPos).func_177230_c() == Blocks.field_150329_H || this.field_145850_b.func_180495_p(nextPos).func_177230_c() == Blocks.field_150398_cm) && !this.field_145850_b.func_175623_d(this.field_174879_c)) {
                if (!this.field_145850_b.func_175623_d(nextPos)) {
                    this.field_145850_b.func_175698_g(nextPos);
                }
            } else {
                this.movementCooldown = 1;
                return;
            }
            this.field_145850_b.func_175698_g(this.field_174879_c);
            this.field_145850_b.func_175656_a(nextPos, currentState);
            TileEntity newTileEntity = this.field_145850_b.func_175625_s(nextPos);
            if (newTileEntity instanceof TileEntityWildfireFlame) {
                ((TileEntityWildfireFlame)newTileEntity).func_145839_a(tileData);
                ((TileEntityWildfireFlame)newTileEntity).movementCooldown = 0;
            }
        }
        this.movementCooldown = 1;
    }

    public void setSpreadRadius(float radius) {
        this.spreadRadius = radius;
        this.func_70296_d();
    }

    public float getSpreadRadius() {
        return this.spreadRadius;
    }

    @Override
    public MagicDamage.DamageType getDamageType() {
        return MagicDamage.DamageType.FIRE;
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        if (compound.func_74764_b("canSpreadFire")) {
            this.canSpreadFire = compound.func_74767_n("canSpreadFire");
        }
        if (compound.func_74764_b("spreadRadius")) {
            this.spreadRadius = compound.func_74760_g("spreadRadius");
        }
        if (compound.func_74764_b("entityNearby")) {
            this.entityNearby = compound.func_74767_n("entityNearby");
        }
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound = super.func_189515_b(compound);
        compound.func_74757_a("canSpreadFire", this.canSpreadFire);
        compound.func_74776_a("spreadRadius", this.spreadRadius);
        compound.func_74757_a("entityNearby", this.entityNearby);
        return compound;
    }
}

