/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.ancientspellcraft.tileentity;

import com.windanesz.ancientspellcraft.AncientSpellcraft;
import com.windanesz.ancientspellcraft.block.BlockSentinel;
import com.windanesz.ancientspellcraft.entity.living.EntitySpellCaster;
import com.windanesz.ancientspellcraft.registry.ASSounds;
import electroblob.wizardry.constants.Element;
import electroblob.wizardry.event.SpellCastEvent;
import electroblob.wizardry.packet.PacketCastSpell;
import electroblob.wizardry.packet.WizardryPacketHandler;
import electroblob.wizardry.registry.Spells;
import electroblob.wizardry.spell.Spell;
import electroblob.wizardry.util.AllyDesignationSystem;
import electroblob.wizardry.util.EntityUtils;
import electroblob.wizardry.util.ParticleBuilder;
import electroblob.wizardry.util.SpellModifiers;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.item.EntityArmorStand;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ITickable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileSentinel
extends TileEntity
implements ITickable {
    private final double maxAttackDistance = 5.0;
    public float crystalRotation;
    public float crystalRotationPrev;
    public float tRot;
    private Spell spell = Spells.magic_missile;
    private int spellCastFrequency = 60;
    private int ticksUntilNextSpell = 60;
    private SpellModifiers modifiers = new SpellModifiers();
    private int lifetime = -1;
    private EntitySpellCaster spellCaster = null;
    private float spellCasterHealth = 0.0f;
    private UUID ownerUUID;
    private boolean large = false;
    private Element crystalElement;

    public Spell getSpell() {
        return this.spell;
    }

    public float getSpellCasterHealth() {
        if (this.spellCaster != null) {
            return this.spellCaster.func_110143_aJ();
        }
        return this.spellCasterHealth;
    }

    public void setSpellCasterHealth(float spellCasterHealth) {
        this.spellCasterHealth = spellCasterHealth;
    }

    public boolean isLarge() {
        return this.large;
    }

    public void setLarge(boolean large) {
        this.large = large;
    }

    @Nullable
    public UUID getOwnerId() {
        return this.ownerUUID;
    }

    @Nullable
    public EntityLivingBase getOwner() {
        Entity entity = EntityUtils.getEntityByUUID((World)this.field_145850_b, (UUID)this.getOwnerId());
        if (entity != null && !(entity instanceof EntityLivingBase)) {
            AncientSpellcraft.logger.warn("{} has a non-living owner!", (Object)this);
            entity = null;
        }
        return (EntityLivingBase)entity;
    }

    public void func_145839_a(NBTTagCompound compound) {
        Spell storedSpell;
        super.func_145839_a(compound);
        this.ticksUntilNextSpell = compound.func_74762_e("ticks_until_next_spell");
        this.spellCastFrequency = compound.func_74762_e("spell_cast_frequency");
        this.spellCasterHealth = compound.func_74760_g("spellcaster_health");
        if (compound.func_74764_b("owner_id")) {
            this.ownerUUID = UUID.fromString(compound.func_74779_i("owner_id"));
        }
        Spell spell = this.spell = (storedSpell = (Spell)Spell.registry.getValue(new ResourceLocation(compound.func_74779_i("spell")))) == null ? Spells.none : storedSpell;
        if (compound.func_74764_b("lifetime")) {
            this.lifetime = compound.func_74762_e("lifetime");
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        compound.func_74768_a("ticks_until_next_spell", this.ticksUntilNextSpell);
        compound.func_74768_a("spell_cast_frequency", this.spellCastFrequency);
        compound.func_74776_a("spellcaster_health", this.spellCasterHealth);
        if (this.ownerUUID != null) {
            compound.func_74778_a("owner_id", this.ownerUUID.toString());
        }
        compound.func_74778_a("spell", this.spell.getRegistryName().toString());
        if (this.spellCaster != null) {
            compound.func_74768_a("lifetime", this.spellCaster.getLifetime());
        } else {
            compound.func_74768_a("lifetime", this.lifetime);
        }
        return compound;
    }

    public final NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.field_174879_c, this.func_145832_p(), this.func_189517_E_());
    }

    public EntitySpellCaster getSpellCasterEntity() {
        return this.spellCaster;
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        Block type = this.func_145838_q();
        AxisAlignedBB bb = type instanceof BlockSentinel ? new AxisAlignedBB(this.field_174879_c, this.field_174879_c.func_177982_a(4, 4, 4)) : this.func_145831_w().func_180495_p(this.field_174879_c).func_185900_c((IBlockAccess)this.field_145850_b, this.field_174879_c);
        return bb;
    }

    public void func_73660_a() {
        List entities;
        this.doRotation();
        if (this.field_145850_b.func_82737_E() % 32L == 0L) {
            this.field_145850_b.func_184148_a(null, (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), ASSounds.SENTINEL_AMBIENT, SoundCategory.NEUTRAL, 1.1f, 1.0f);
        }
        if (this.spellCaster == null) {
            this.initSpellcaster();
        } else {
            this.spellCasterHealth = this.spellCaster.func_110143_aJ();
        }
        this.decrementSpellTimer();
        if (this.ticksUntilNextSpell == 0 && !(entities = EntityUtils.getEntitiesWithinRadius((double)5.0, (double)((float)this.field_174879_c.func_177958_n() + 0.5f), (double)((float)this.field_174879_c.func_177956_o() + 0.5f), (double)((float)this.field_174879_c.func_177952_p() + 0.5f), (World)this.field_145850_b, EntityLivingBase.class)).isEmpty()) {
            for (EntityLivingBase target : entities) {
                double distanceSq;
                if (this.ownerUUID == null && target instanceof EntityPlayer) {
                    distanceSq = target.func_70092_e((double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p());
                    if (!(Math.sqrt(distanceSq) <= 5.0) || !this.tryCastSpell(target)) continue;
                    this.resetSpellTimer(10);
                    break;
                }
                if (this.ownerUUID == null || target instanceof EntityArmorStand || !this.isValidTarget((Entity)target) || !target.func_70089_S() || !(Math.sqrt(distanceSq = target.func_70092_e((double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p())) <= 5.0) || !this.tryCastSpell(target)) continue;
                this.resetSpellTimer();
                break;
            }
        }
        if (this.getSpellCasterHealth() == 0.0f) {
            this.field_145850_b.func_175698_g(this.field_174879_c);
        }
        if (this.field_145850_b.field_72995_K && this.field_145850_b.field_73012_v.nextBoolean() && this.field_145850_b.field_73012_v.nextBoolean()) {
            double d = (double)this.field_174879_c.func_177956_o() + 0.5;
            float f = this.crystalRotation;
            ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.FLASH).pos((double)this.field_174879_c.func_177958_n() + 0.5, d += (double)(MathHelper.func_76126_a((float)(f * 2.0f)) * 0.12f), (double)((float)this.field_174879_c.func_177952_p() + 0.5f)).vel(0.0, 0.01, 0.0).time(20 + this.field_145850_b.field_73012_v.nextInt(10)).clr(0.5f + this.field_145850_b.field_73012_v.nextFloat() / 5.0f, 0.5f + this.field_145850_b.field_73012_v.nextFloat() / 5.0f, 0.5f + this.field_145850_b.field_73012_v.nextFloat() / 2.0f).scale(0.5f).spawn(this.field_145850_b);
            double d2 = 0.12;
        }
    }

    private boolean isVisibleTarget(EntityLivingBase entity) {
        if (entity.func_82150_aj()) {
            return false;
        }
        return this.field_145850_b.func_147447_a(new Vec3d((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5), new Vec3d(entity.field_70165_t, entity.field_70163_u + (double)entity.func_70047_e(), entity.field_70161_v), false, true, false) == null;
    }

    private void decrementSpellTimer() {
        if (this.ticksUntilNextSpell > 0) {
            --this.ticksUntilNextSpell;
        }
    }

    public Element getCrystalElement() {
        return this.crystalElement;
    }

    public void setCrystalElement(Element crystalElement) {
        this.crystalElement = crystalElement;
    }

    private void resetSpellTimer() {
        this.ticksUntilNextSpell = (int)((double)this.spellCastFrequency * (this.large ? 0.6 : 1.0));
    }

    private void resetSpellTimer(int i) {
        this.ticksUntilNextSpell = i;
    }

    public boolean isValidTarget(Entity target) {
        return target != this.spellCaster && AllyDesignationSystem.isValidTarget((Entity)this.getOwner(), (Entity)target);
    }

    private void doRotation() {
        float f2;
        this.crystalRotationPrev = this.crystalRotation;
        this.tRot += 0.02f;
        while (this.crystalRotation >= (float)Math.PI) {
            this.crystalRotation -= (float)Math.PI * 2;
        }
        while (this.crystalRotation < (float)(-Math.PI)) {
            this.crystalRotation += (float)Math.PI * 2;
        }
        while (this.tRot >= (float)Math.PI) {
            this.tRot -= (float)Math.PI * 2;
        }
        while (this.tRot < (float)(-Math.PI)) {
            this.tRot += (float)Math.PI * 2;
        }
        for (f2 = this.tRot - this.crystalRotation; f2 >= (float)Math.PI; f2 -= (float)Math.PI * 2) {
        }
        while (f2 < (float)(-Math.PI)) {
            f2 += (float)Math.PI * 2;
        }
        this.crystalRotation += f2 * 0.4f;
    }

    public boolean tryCastSpell(EntityLivingBase target) {
        if (this.spell == null || this.spellCaster == null) {
            return false;
        }
        if (this.spell.isContinuous) {
            return false;
        }
        if (!this.spell.canBeCastBy((EntityLiving)this.spellCaster, true)) {
            return false;
        }
        if (MinecraftForge.EVENT_BUS.post((Event)new SpellCastEvent.Pre(SpellCastEvent.Source.NPC, this.spell, (EntityLivingBase)this.spellCaster, this.modifiers))) {
            return false;
        }
        if (this.spell.cast(this.field_145850_b, (EntityLiving)this.spellCaster, EnumHand.MAIN_HAND, 0, target, this.modifiers)) {
            MinecraftForge.EVENT_BUS.post((Event)new SpellCastEvent.Post(SpellCastEvent.Source.OTHER, this.spell, this.field_145850_b, (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), EnumFacing.UP, this.modifiers));
            if (this.spell.requiresPacket()) {
                PacketCastSpell.Message msg = new PacketCastSpell.Message(this.spellCaster.func_145782_y(), EnumHand.MAIN_HAND, this.spell, this.modifiers);
                WizardryPacketHandler.net.sendToDimension((IMessage)msg, this.field_145850_b.field_73011_w.getDimension());
            }
        }
        if (this.spellCaster.func_70089_S()) {
            // empty if block
        }
        return true;
    }

    public void setLifeTime(int lifetime) {
        this.lifetime = lifetime;
        if (this.spellCaster == null) {
            this.initSpellcaster();
        }
        if (this.spellCaster != null) {
            this.spellCaster.setLifetime(lifetime);
        }
    }

    private void initSpellcaster() {
        EntitySpellCaster spellCaster = new EntitySpellCaster(this.field_145850_b);
        spellCaster.func_70107_b((float)this.field_174879_c.func_177958_n() + 0.5f, this.field_174879_c.func_177956_o(), (float)this.field_174879_c.func_177952_p() + 0.5f);
        spellCaster.setContinuousSpell(this.spell);
        spellCaster.setModifiers(this.modifiers);
        spellCaster.setOwnerId(this.ownerUUID);
        spellCaster.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a((double)this.getSpellCasterHealth());
        spellCaster.func_70606_j(this.getSpellCasterHealth());
        spellCaster.setLifetime(this.lifetime);
        if (!this.field_145850_b.field_72995_K) {
            this.field_145850_b.func_72838_d((Entity)spellCaster);
        }
        this.spellCaster = spellCaster;
    }
}

